/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.screencapture.ve_gl;

import android.opengl.GLES20;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GlUtil {
    private GlUtil() {
    }

    public static void checkNoGLES2Error(String msg) {
        int error = GLES20.glGetError();
        if (error != 0) {
            throw new RuntimeException(msg + ": GLES20 error: " + error);
        }
    }

    public static FloatBuffer createFloatBuffer(float[] coords) {
        ByteBuffer bb = ByteBuffer.allocateDirect(coords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(coords);
        fb.position(0);
        return fb;
    }

    public static int generateTexture(int target) {
        int[] textureArray = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureArray, (int)0);
        int textureId = textureArray[0];
        GLES20.glBindTexture((int)target, (int)textureId);
        GLES20.glTexParameterf((int)target, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10240, (float)9729.0f);
        GLES20.glTexParameterf((int)target, (int)10242, (float)33071.0f);
        GLES20.glTexParameterf((int)target, (int)10243, (float)33071.0f);
        GlUtil.checkNoGLES2Error("generateTexture");
        return textureId;
    }

    public static int generateFrameBuffer(int textureId) {
        int[] frameBufferArray = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBufferArray, (int)0);
        int frameBufferId = frameBufferArray[0];
        GLES20.glBindFramebuffer((int)36160, (int)frameBufferId);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)textureId, (int)0);
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            return -1;
        }
        GlUtil.checkNoGLES2Error("generateFrameBuffer");
        return frameBufferId;
    }
}

