/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.screencapture.ve_gl;

import android.opengl.GLES20;
import com.zego.zegoavkit2.screencapture.ve_gl.GlShader;
import com.zego.zegoavkit2.screencapture.ve_gl.GlUtil;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.IdentityHashMap;
import java.util.Map;

public class GlRectDrawer {
    private static final String VERTEX_SHADER_STRING = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String YUV_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D y_tex;\nuniform sampler2D u_tex;\nuniform sampler2D v_tex;\n\nvoid main() {\n  float y = texture2D(y_tex, interp_tc).r;\n  float u = texture2D(u_tex, interp_tc).r - 0.5;\n  float v = texture2D(v_tex, interp_tc).r - 0.5;\n  gl_FragColor = vec4(y + 1.403 * v,                       y - 0.344 * u - 0.714 * v,                       y + 1.77 * u, 1);\n}\n";
    private static final String RGB_FRAGMENT_SHADER_STRING = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D rgb_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(rgb_tex, interp_tc);\n}\n";
    private static final String OES_FRAGMENT_SHADER_STRING = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES oes_tex;\n\nvoid main() {\n  gl_FragColor = texture2D(oes_tex, interp_tc);\n}\n";
    private static final FloatBuffer FULL_RECTANGLE_BUF = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private final Map<String, Shader> shaders = new IdentityHashMap<String, Shader>();

    public void drawOes(int oesTextureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(OES_FRAGMENT_SHADER_STRING, texMatrix);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)oesTextureId);
        this.drawRectangle(viewportX, viewportY, viewportWidth, viewportHeight);
        GLES20.glBindTexture((int)36197, (int)0);
    }

    public void drawRgb(int textureId, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        this.prepareShader(RGB_FRAGMENT_SHADER_STRING, texMatrix);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        this.drawRectangle(viewportX, viewportY, viewportWidth, viewportHeight);
        GLES20.glBindTexture((int)3553, (int)0);
    }

    public void drawYuv(int[] yuvTextures, float[] texMatrix, int frameWidth, int frameHeight, int viewportX, int viewportY, int viewportWidth, int viewportHeight) {
        int i;
        this.prepareShader(YUV_FRAGMENT_SHADER_STRING, texMatrix);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)yuvTextures[i]);
        }
        this.drawRectangle(viewportX, viewportY, viewportWidth, viewportHeight);
        for (i = 0; i < 3; ++i) {
            GLES20.glActiveTexture((int)(33984 + i));
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    private void drawRectangle(int x, int y, int width, int height) {
        GLES20.glViewport((int)x, (int)y, (int)width, (int)height);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
    }

    private void prepareShader(String fragmentShader, float[] texMatrix) {
        Shader shader;
        if (this.shaders.containsKey(fragmentShader)) {
            shader = this.shaders.get(fragmentShader);
        } else {
            shader = new Shader(fragmentShader);
            this.shaders.put(fragmentShader, shader);
            shader.glShader.useProgram();
            if (fragmentShader == YUV_FRAGMENT_SHADER_STRING) {
                shader.tex0Location = shader.glShader.getUniformLocation("y_tex");
                shader.tex1Location = shader.glShader.getUniformLocation("u_tex");
                shader.tex2Location = shader.glShader.getUniformLocation("v_tex");
            } else if (fragmentShader == RGB_FRAGMENT_SHADER_STRING) {
                shader.tex0Location = shader.glShader.getUniformLocation("rgb_tex");
            } else if (fragmentShader == OES_FRAGMENT_SHADER_STRING) {
                shader.tex0Location = shader.glShader.getUniformLocation("oes_tex");
            } else {
                throw new IllegalStateException("Unknown fragment shader: " + fragmentShader);
            }
            GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        }
        shader.glShader.useProgram();
        if (shader.tex0Location != 0) {
            GLES20.glUniform1i((int)shader.tex0Location, (int)0);
        }
        if (shader.tex1Location != 0) {
            GLES20.glUniform1i((int)shader.tex1Location, (int)1);
        }
        if (shader.tex2Location != 0) {
            GLES20.glUniform1i((int)shader.tex1Location, (int)2);
        }
        GLES20.glEnableVertexAttribArray((int)shader.posLocation);
        GLES20.glEnableVertexAttribArray((int)shader.tcLocation);
        GLES20.glVertexAttribPointer((int)shader.posLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_BUF);
        GLES20.glVertexAttribPointer((int)shader.tcLocation, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)FULL_RECTANGLE_TEX_BUF);
        GLES20.glUniformMatrix4fv((int)shader.texMatrixLocation, (int)1, (boolean)false, (float[])texMatrix, (int)0);
    }

    public void release() {
        for (Shader shader : this.shaders.values()) {
            shader.glShader.release();
        }
        this.shaders.clear();
    }

    private static class Shader {
        public final GlShader glShader;
        public final int texMatrixLocation;
        public final int posLocation;
        public final int tcLocation;
        public int tex0Location;
        public int tex1Location;
        public int tex2Location;

        public Shader(String fragmentShader) {
            this.glShader = new GlShader(GlRectDrawer.VERTEX_SHADER_STRING, fragmentShader);
            this.texMatrixLocation = this.glShader.getUniformLocation("texMatrix");
            this.posLocation = this.glShader.getAttribLocation("in_pos");
            this.tcLocation = this.glShader.getAttribLocation("in_tc");
            GLES20.glEnableVertexAttribArray((int)this.posLocation);
            GLES20.glEnableVertexAttribArray((int)this.tcLocation);
            this.tex2Location = 0;
            this.tex1Location = 0;
            this.tex0Location = 0;
        }
    }
}

