/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.screencapture;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.projection.MediaProjection;
import com.zego.zegoavkit2.ZegoVideoCaptureDevice;
import com.zego.zegoavkit2.ZegoVideoCaptureFactory;
import com.zego.zegoavkit2.screencapture.ZegoScreenCaptureDevice;

@TargetApi(value=21)
public class ZegoScreenCaptureFactory
extends ZegoVideoCaptureFactory {
    public static final int SCREEN_CAPTURE_SIZE_DEFAULT = 0;
    private Context mContext;
    private volatile ZegoScreenCaptureDevice mDevice = null;
    private volatile MediaProjection mMediaProjection = null;
    private volatile int mCaptureWidth = 0;
    private volatile int mCaptureHeight = 0;

    public ZegoScreenCaptureFactory(Context context) {
        this.mContext = context;
    }

    @Override
    public ZegoVideoCaptureDevice create(String device_id) {
        if (null == this.mDevice) {
            this.mDevice = new ZegoScreenCaptureDevice(this.mContext, this.mMediaProjection, this.mCaptureWidth, this.mCaptureHeight);
        }
        return this.mDevice;
    }

    @Override
    public void destroy(ZegoVideoCaptureDevice vc) {
        if (vc == this.mDevice) {
            this.mMediaProjection = null;
            this.mDevice.setMediaProjection(null);
            this.mDevice = null;
        }
    }

    public void setMediaProjection(MediaProjection mediaProjection) {
        this.mMediaProjection = mediaProjection;
        ZegoScreenCaptureDevice device = this.mDevice;
        if (device != null) {
            device.setMediaProjection(mediaProjection);
        }
    }

    public void setCaptureResolution(int captureWidth, int captureHeight) {
        if (captureWidth == 0 && captureHeight == 0 || captureWidth > 0 || captureHeight > 0) {
            this.mCaptureWidth = captureWidth;
            this.mCaptureHeight = captureHeight;
            ZegoScreenCaptureDevice device = this.mDevice;
            if (device != null) {
                device.setCaptureResolution(captureWidth, captureHeight);
            }
        }
    }
}

