/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.screencapture;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.Surface;
import android.view.View;
import android.view.WindowManager;
import com.zego.zegoavkit2.ZegoVideoCaptureDevice;
import com.zego.zegoavkit2.screencapture.ve_gl.EglBase;
import com.zego.zegoavkit2.screencapture.ve_gl.EglBase14;
import com.zego.zegoavkit2.screencapture.ve_gl.GlRectDrawer;
import com.zego.zegoavkit2.screencapture.ve_gl.GlUtil;
import com.zego.zegoliveroom.ZegoLiveRoom;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@TargetApi(value=21)
class ZegoScreenCaptureDevice
extends ZegoVideoCaptureDevice
implements SurfaceTexture.OnFrameAvailableListener {
    private volatile ZegoVideoCaptureDevice.Client mClient = null;
    private HandlerThread mHandlerThread = null;
    private Handler mHandler = null;
    private WindowManager mWindowManager;
    private volatile MediaProjection mMediaProjection;
    private volatile VirtualDisplay mVirtualDisplay = null;
    private DisplayMetrics mOutMetrics;
    private int mSetCaptureWidth;
    private int mSetCaptureHeight;
    private int mCaptureWidth;
    private int mCaptureHeight;
    private int mSdkSurfaceBufferWidth = 0;
    private int mSdkSurfaceBufferHeight = 0;
    private volatile boolean isScreenCapturing = false;
    private volatile boolean isStartPreview = false;
    private volatile boolean isStartCapture = false;
    private volatile Surface mSurface = null;
    private SurfaceTexture mSysSurfaceTexture;
    private SurfaceTexture mSdkSurfaceTexture;
    private float[] transformationMatrix = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private float[] mInputMatrix = new float[16];
    private EglBase mEglSysToVideoMemory;
    private GlRectDrawer mSysToVideoMemoryDrawer;
    private EglBase mEglVideoMemoryToSDK;
    private GlRectDrawer mVideoMemoryToSDKDrawer;
    private int mFrameBufferId;
    private int mSysTextureId;
    private int mSDKTextureId;
    private boolean mEgl14Supported;
    private volatile int mDrawToSDKInterval = 66;
    private DrawRunnable mDrawRunnable = new DrawRunnable();

    ZegoScreenCaptureDevice(Context context, MediaProjection mediaProjection, int captureWidth, int captureHeight) {
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mOutMetrics = new DisplayMetrics();
        this.mMediaProjection = mediaProjection;
        this.mSetCaptureWidth = captureWidth;
        this.mSetCaptureHeight = captureHeight;
    }

    @Override
    protected void allocateAndStart(ZegoVideoCaptureDevice.Client client) {
        this.mClient = client;
        this.mHandlerThread = new HandlerThread("ZegoScreenCapture");
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
    }

    @Override
    protected void stopAndDeAllocate() {
        if (this.mClient != null) {
            this.mClient.destroy();
            this.mClient = null;
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
            this.mHandlerThread = null;
            this.mHandler = null;
        }
    }

    private void startScreenCapture() {
        if (this.mClient != null && !this.isScreenCapturing && this.mMediaProjection != null) {
            this.isScreenCapturing = true;
            this.initCaptureSize();
            this.getSurface();
            this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay("ScreenCapture", this.mCaptureWidth, this.mCaptureHeight, 1, 1, this.mSurface, null, this.mHandler);
        }
    }

    private boolean isDefaultCaptureSize() {
        return this.mSetCaptureWidth == 0 || this.mSetCaptureHeight == 0;
    }

    private void initCaptureSize() {
        if (this.isDefaultCaptureSize()) {
            this.mWindowManager.getDefaultDisplay().getRealMetrics(this.mOutMetrics);
            this.mCaptureWidth = this.mOutMetrics.widthPixels;
            this.mCaptureHeight = this.mOutMetrics.heightPixels;
        } else {
            this.mCaptureWidth = this.mSetCaptureWidth;
            this.mCaptureHeight = this.mSetCaptureHeight;
        }
        ZegoLiveRoom._logPrint("ZegoScreenCaptureDevice mSetCaptureWidth mSetCaptureWidth: %d, mSetCaptureHeight: %d, mCaptureWidth: %d, mCaptureHeight: %d, mSdkSurfaceBufferWidth: %d, mSdkSurfaceBufferHeight: %d", this.mSetCaptureWidth, this.mSetCaptureHeight, this.mCaptureWidth, this.mCaptureHeight, this.mSdkSurfaceBufferWidth, this.mSetCaptureHeight);
        if (this.mSdkSurfaceBufferWidth == 0 && this.mSdkSurfaceBufferHeight == 0) {
            this.mSdkSurfaceBufferWidth = this.mCaptureWidth;
            this.mSdkSurfaceBufferHeight = this.mCaptureHeight;
        }
    }

    private void resizeVirtualDisplayInNeed() {
        int width = this.mSetCaptureWidth;
        int height = this.mSetCaptureHeight;
        if (this.isDefaultCaptureSize()) {
            this.mWindowManager.getDefaultDisplay().getRealMetrics(this.mOutMetrics);
            width = this.mOutMetrics.widthPixels;
            height = this.mOutMetrics.heightPixels;
        }
        if (this.mCaptureWidth == width && this.mCaptureHeight == height) {
            return;
        }
        ZegoLiveRoom._logPrint("ZegoScreenCaptureDevice resizeVirtualDisplayInNeed mSetCaptureWidth: %d, mSetCaptureHeight: %d, mCaptureWidth: %d, mCaptureHeight: %d, newWidth: %d, newHeight: %d", this.mSetCaptureWidth, this.mSetCaptureHeight, this.mCaptureWidth, this.mCaptureHeight, width, height);
        this.mCaptureWidth = width;
        this.mCaptureHeight = height;
        if (this.mEglSysToVideoMemory != null) {
            this.mEglSysToVideoMemory.makeCurrent();
        }
        if (this.mFrameBufferId != 0) {
            int[] frameBuffers = new int[]{this.mFrameBufferId};
            GLES20.glDeleteFramebuffers((int)1, (int[])frameBuffers, (int)0);
            this.mFrameBufferId = 0;
        }
        if (this.mSDKTextureId != 0) {
            int[] textures = new int[]{this.mSDKTextureId};
            GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
            this.mSDKTextureId = 0;
        }
        if (this.mSysSurfaceTexture != null) {
            this.mSysSurfaceTexture.setDefaultBufferSize(this.mCaptureWidth, this.mCaptureHeight);
        }
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.resize(this.mCaptureWidth, this.mCaptureHeight, 1);
        }
        if (this.mEglSysToVideoMemory != null) {
            this.mEglSysToVideoMemory.detachCurrent();
        }
    }

    void setCaptureResolution(int captureWidth, int captureHeight) {
        this.mSetCaptureWidth = captureWidth;
        this.mSetCaptureHeight = captureHeight;
    }

    private void stopScreenCaptureInNeed() {
        if (this.isStartPreview || this.isStartCapture) {
            return;
        }
        this.isScreenCapturing = false;
        if (this.mVirtualDisplay != null) {
            this.mVirtualDisplay.release();
            this.mVirtualDisplay = null;
        }
        this.releaseEGLSurface();
    }

    @Override
    protected int startCapture() {
        this.isStartCapture = true;
        this.startScreenCapture();
        return 0;
    }

    @Override
    protected int stopCapture() {
        this.isStartCapture = false;
        this.stopScreenCaptureInNeed();
        return 0;
    }

    @Override
    protected int startPreview() {
        this.isStartPreview = true;
        this.startScreenCapture();
        return 0;
    }

    @Override
    protected int stopPreview() {
        this.isStartPreview = false;
        this.stopScreenCaptureInNeed();
        return 0;
    }

    private void getSurface() {
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ZegoScreenCaptureDevice.this.mEglSysToVideoMemory == null) {
                    ZegoScreenCaptureDevice.this.mEglSysToVideoMemory = EglBase.create(null, EglBase.CONFIG_PIXEL_BUFFER);
                }
                if (!ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.hasSurface()) {
                    try {
                        ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.createDummyPbufferSurface();
                        ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.makeCurrent();
                        ZegoScreenCaptureDevice.this.mSysToVideoMemoryDrawer = new GlRectDrawer();
                    }
                    catch (RuntimeException e) {
                        ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.releaseSurface();
                        e.printStackTrace();
                        throw e;
                    }
                }
                ZegoScreenCaptureDevice.this.mEgl14Supported = EglBase14.isEGL14Supported();
                ZegoScreenCaptureDevice.this.mSysTextureId = GlUtil.generateTexture(36197);
                ZegoScreenCaptureDevice.this.mSysSurfaceTexture = new SurfaceTexture(ZegoScreenCaptureDevice.this.mSysTextureId);
                ZegoScreenCaptureDevice.this.mSysSurfaceTexture.setDefaultBufferSize(ZegoScreenCaptureDevice.this.mCaptureWidth, ZegoScreenCaptureDevice.this.mCaptureHeight);
                ZegoScreenCaptureDevice.this.mSurface = new Surface(ZegoScreenCaptureDevice.this.mSysSurfaceTexture);
                ZegoScreenCaptureDevice.this.mSysSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)ZegoScreenCaptureDevice.this);
                if (ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK == null) {
                    ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK = EglBase.create(ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.getEglBaseContext(), EglBase.CONFIG_RECORDABLE);
                }
                if (!ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.hasSurface()) {
                    ZegoScreenCaptureDevice.this.mSdkSurfaceTexture = ZegoScreenCaptureDevice.this.mClient.getSurfaceTexture();
                    ZegoScreenCaptureDevice.this.mSdkSurfaceTexture.setDefaultBufferSize(ZegoScreenCaptureDevice.this.mSdkSurfaceBufferWidth, ZegoScreenCaptureDevice.this.mSdkSurfaceBufferHeight);
                    try {
                        ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.createSurface(ZegoScreenCaptureDevice.this.mSdkSurfaceTexture);
                        ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.makeCurrent();
                        ZegoScreenCaptureDevice.this.mVideoMemoryToSDKDrawer = new GlRectDrawer();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                        ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.releaseSurface();
                        return;
                    }
                }
                ZegoScreenCaptureDevice.this.mHandler.postDelayed((Runnable)ZegoScreenCaptureDevice.this.mDrawRunnable, (long)ZegoScreenCaptureDevice.this.mDrawToSDKInterval);
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private synchronized void drawOESTexture() {
        if (this.mEglSysToVideoMemory != null) {
            this.mEglSysToVideoMemory.makeCurrent();
        }
        this.mSysSurfaceTexture.updateTexImage();
        this.mSysSurfaceTexture.getTransformMatrix(this.mInputMatrix);
        if (this.mSDKTextureId == 0) {
            GLES20.glActiveTexture((int)33984);
            this.mSDKTextureId = GlUtil.generateTexture(3553);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mCaptureWidth, (int)this.mCaptureHeight, (int)0, (int)6408, (int)5121, null);
            this.mFrameBufferId = GlUtil.generateFrameBuffer(this.mSDKTextureId);
        } else {
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferId);
        }
        GLES20.glClear((int)16384);
        this.mSysToVideoMemoryDrawer.drawOes(this.mSysTextureId, this.mInputMatrix, this.mCaptureWidth, this.mCaptureHeight, 0, 0, this.mCaptureWidth, this.mCaptureHeight);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    private synchronized void drawRGBTextureToSDK() {
        try {
            this.mEglVideoMemoryToSDK.makeCurrent();
            long timestamp = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
            GLES20.glClear((int)16384);
            this.mVideoMemoryToSDKDrawer.drawRgb(this.mSDKTextureId, this.transformationMatrix, this.mCaptureWidth, this.mCaptureHeight, 0, 0, this.mSdkSurfaceBufferWidth, this.mSdkSurfaceBufferHeight);
            if (this.mEgl14Supported) {
                ((EglBase14)this.mEglVideoMemoryToSDK).swapBuffers(timestamp);
            } else {
                this.mEglVideoMemoryToSDK.swapBuffers();
            }
            this.mEglVideoMemoryToSDK.detachCurrent();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private void releaseEGLSurface() {
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mHandler.removeCallbacks((Runnable)this.mDrawRunnable);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK != null && ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.hasSurface()) {
                    ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.makeCurrent();
                    ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.releaseSurface();
                    ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.detachCurrent();
                    ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK.release();
                    ZegoScreenCaptureDevice.this.mEglVideoMemoryToSDK = null;
                }
                if (ZegoScreenCaptureDevice.this.mEglSysToVideoMemory != null && ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.hasSurface()) {
                    int[] textures;
                    ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.makeCurrent();
                    if (ZegoScreenCaptureDevice.this.mFrameBufferId != 0) {
                        int[] frameBuffers = new int[]{ZegoScreenCaptureDevice.this.mFrameBufferId};
                        GLES20.glDeleteFramebuffers((int)1, (int[])frameBuffers, (int)0);
                        ZegoScreenCaptureDevice.this.mFrameBufferId = 0;
                    }
                    if (ZegoScreenCaptureDevice.this.mSDKTextureId != 0) {
                        textures = new int[]{ZegoScreenCaptureDevice.this.mSDKTextureId};
                        GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
                        ZegoScreenCaptureDevice.this.mSDKTextureId = 0;
                    }
                    if (ZegoScreenCaptureDevice.this.mSysTextureId != 0) {
                        textures = new int[]{ZegoScreenCaptureDevice.this.mSysTextureId};
                        GLES20.glDeleteTextures((int)1, (int[])textures, (int)0);
                        ZegoScreenCaptureDevice.this.mSysTextureId = 0;
                    }
                    ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.releaseSurface();
                    ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.detachCurrent();
                    ZegoScreenCaptureDevice.this.mEglSysToVideoMemory.release();
                    ZegoScreenCaptureDevice.this.mEglSysToVideoMemory = null;
                }
                if (ZegoScreenCaptureDevice.this.mSurface != null) {
                    ZegoScreenCaptureDevice.this.mSurface.release();
                    ZegoScreenCaptureDevice.this.mSurface = null;
                }
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        if (!this.isScreenCapturing) {
            return;
        }
        this.drawOESTexture();
    }

    @Override
    protected int supportBufferType() {
        return 4;
    }

    @Override
    protected int setFrameRate(int fps) {
        this.mDrawToSDKInterval = 1000 / fps;
        ZegoLiveRoom._logPrint("ZegoScreenCaptureDevice setFrameRate fps: %d, mDrawToSDKInterval: %d", fps, this.mDrawToSDKInterval);
        return 0;
    }

    @Override
    protected int setResolution(final int width, final int height) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ZegoScreenCaptureDevice.this.resizeSdkSurface(width, height);
            }
        });
        return 0;
    }

    private void resizeSdkSurface(int width, int height) {
        ZegoLiveRoom._logPrint("ZegoScreenCaptureDevice resizeSdkSurface mSdkSurfaceBufferWidth: %d, mSdkSurfaceBufferHeight %d, width %d, height: %d", this.mSdkSurfaceBufferWidth, this.mSdkSurfaceBufferHeight, width, height);
        if (this.mSdkSurfaceBufferWidth == width && this.mSdkSurfaceBufferHeight == height) {
            return;
        }
        this.mSdkSurfaceBufferWidth = width;
        this.mSdkSurfaceBufferHeight = height;
        if (this.mEglVideoMemoryToSDK != null) {
            this.mEglVideoMemoryToSDK.makeCurrent();
        }
        if (this.mSdkSurfaceTexture != null) {
            this.mSdkSurfaceTexture.setDefaultBufferSize(this.mSdkSurfaceBufferWidth, this.mSdkSurfaceBufferHeight);
        }
        if (this.mEglVideoMemoryToSDK != null) {
            this.mEglVideoMemoryToSDK.detachCurrent();
        }
    }

    @Override
    protected int setFrontCam(int i) {
        return 0;
    }

    @Override
    protected int setView(View view) {
        return 0;
    }

    @Override
    protected int setViewMode(int i) {
        return 0;
    }

    @Override
    protected int setViewRotation(int i) {
        return 0;
    }

    @Override
    protected int setCaptureRotation(int i) {
        return 0;
    }

    @Override
    protected int enableTorch(boolean b) {
        return 0;
    }

    @Override
    protected int takeSnapshot() {
        return 0;
    }

    @Override
    protected int setPowerlineFreq(int i) {
        return 0;
    }

    void setMediaProjection(MediaProjection mediaProjection) {
        this.mMediaProjection = mediaProjection;
        if (this.isScreenCapturing && this.mClient != null && this.mMediaProjection != null && this.mSurface != null) {
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.release();
            }
            this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay("ScreenCapture", this.mCaptureWidth, this.mCaptureHeight, 1, 1, this.mSurface, null, this.mHandler);
        }
    }

    private class DrawRunnable
    implements Runnable {
        private DrawRunnable() {
        }

        @Override
        public void run() {
            ZegoScreenCaptureDevice.this.resizeVirtualDisplayInNeed();
            ZegoScreenCaptureDevice.this.drawRGBTextureToSDK();
            if (ZegoScreenCaptureDevice.this.mHandler != null) {
                ZegoScreenCaptureDevice.this.mHandler.postDelayed((Runnable)ZegoScreenCaptureDevice.this.mDrawRunnable, (long)ZegoScreenCaptureDevice.this.mDrawToSDKInterval);
            }
        }
    }
}

