/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.mixstream;

import com.zego.zegoavkit2.mixstream.IZegoMixStreamCallback;
import com.zego.zegoavkit2.mixstream.IZegoMixStreamExCallback;
import com.zego.zegoavkit2.mixstream.IZegoMixStreamRelayCDNCallback;
import com.zego.zegoavkit2.mixstream.IZegoSoundLevelInMixStreamCallback;
import com.zego.zegoavkit2.mixstream.ZegoCompleteMixStreamInfo;
import com.zego.zegoavkit2.mixstream.ZegoMixStreamConfig;
import com.zego.zegoavkit2.mixstream.ZegoMixStreamInfo;
import com.zego.zegoavkit2.mixstream.ZegoMixStreamJNI;
import com.zego.zegoavkit2.mixstream.ZegoMixStreamOutput;

public class ZegoStreamMixer {
    public static final String NON_EXIST_STREAM_ID_KEY = "NonExists";
    public static final String SEQ_KEY = "ReqSeq";

    public void setCallback(IZegoMixStreamCallback callback) {
        ZegoMixStreamJNI.setCallback(callback);
    }

    public void setMixStreamExCallback(IZegoMixStreamExCallback callback) {
        ZegoMixStreamJNI.setMixStreamExCallback(callback);
    }

    public void setSoundLevelInMixStreamCallback(IZegoSoundLevelInMixStreamCallback callback) {
        ZegoMixStreamJNI.setSoundLevelInMixStreamCallback(callback);
    }

    public void setRelayCDNStateCallback(IZegoMixStreamRelayCDNCallback callback) {
        ZegoMixStreamJNI.setRelayCDNCallback(callback);
    }

    public boolean mixStream(ZegoCompleteMixStreamInfo config, int seq) {
        return ZegoMixStreamJNI.mixStream(config, seq);
    }

    public int mixStreamEx(ZegoMixStreamConfig config, String mixStreamID) {
        int idx;
        if (mixStreamID.length() == 0) {
            return -1;
        }
        if (config.inputStreamList != null && config.inputStreamList.length > 0) {
            for (idx = 0; idx < config.inputStreamList.length; ++idx) {
                ZegoMixStreamInfo input = config.inputStreamList[idx];
                if (input != null && input.streamID != null && input.streamID.length() >= 1 && input.streamID.length() <= 512) continue;
                return -1;
            }
        }
        if (config.outputList != null && config.outputList.length > 0) {
            for (idx = 0; idx < config.outputList.length; ++idx) {
                ZegoMixStreamOutput output = config.outputList[idx];
                if (output != null && output.target != null && output.target.length() >= 1 && output.target.length() <= 512) continue;
                return -1;
            }
        }
        if (config.outputRateControlMode == 1 && (config.outputQuality < 1 || config.outputQuality > 51)) {
            return -1;
        }
        return ZegoMixStreamJNI.mixStreamEx(config, mixStreamID);
    }
}

