/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.mixstream;

import android.os.Handler;
import android.os.Looper;
import com.zego.zegoavkit2.entities.ZegoStreamRelayCDNInfo;
import com.zego.zegoavkit2.mixstream.IZegoMixStreamCallback;
import com.zego.zegoavkit2.mixstream.IZegoMixStreamExCallback;
import com.zego.zegoavkit2.mixstream.IZegoMixStreamRelayCDNCallback;
import com.zego.zegoavkit2.mixstream.IZegoSoundLevelInMixStreamCallback;
import com.zego.zegoavkit2.mixstream.ZegoCompleteMixStreamInfo;
import com.zego.zegoavkit2.mixstream.ZegoMixStreamConfig;
import com.zego.zegoavkit2.mixstream.ZegoMixStreamResultEx;
import com.zego.zegoavkit2.mixstream.ZegoSoundLevelInMixStreamInfo;
import java.util.ArrayList;
import java.util.HashMap;

public final class ZegoMixStreamJNI {
    private static IZegoMixStreamCallback mCallback = null;
    private static IZegoMixStreamExCallback mExCallback = null;
    private static IZegoSoundLevelInMixStreamCallback mSoundLevelCallback = null;
    private static IZegoMixStreamRelayCDNCallback mRelayCDNCallback = null;

    public static void setCallback(IZegoMixStreamCallback callback) {
        mCallback = callback;
        ZegoMixStreamJNI.setMixStreamCallback(callback != null);
    }

    public static void setMixStreamExCallback(IZegoMixStreamExCallback callback) {
        mExCallback = callback;
        ZegoMixStreamJNI.setMixStreamExCallback(callback != null);
    }

    public static void setSoundLevelInMixStreamCallback(IZegoSoundLevelInMixStreamCallback callback) {
        mSoundLevelCallback = callback;
        ZegoMixStreamJNI.setSoundLevelInMixStreamCallback(callback != null);
    }

    public static void setRelayCDNCallback(IZegoMixStreamRelayCDNCallback callback) {
        mRelayCDNCallback = callback;
    }

    public static void onMixStreamConfigUpdate(final int stateCode, final String mixStreamID, final HashMap<String, Object> streamInfo) {
        if (mCallback == null) {
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (mCallback != null) {
                    mCallback.onMixStreamConfigUpdate(stateCode, mixStreamID, streamInfo);
                }
            }
        });
    }

    public static void onMixStreamExConfigUpdate(final int stateCode, final String mixStreamID, final ZegoMixStreamResultEx streamInfo) {
        if (mExCallback == null) {
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (mExCallback != null) {
                    mExCallback.onMixStreamExConfigUpdate(stateCode, mixStreamID, streamInfo);
                }
            }
        });
    }

    public static void onMixStreamRelayCDNStateUpdate(final ZegoStreamRelayCDNInfo[] statesInfo, final String mixStreamID) {
        if (mRelayCDNCallback == null) {
            return;
        }
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                if (mRelayCDNCallback != null) {
                    mRelayCDNCallback.onMixStreamRelayCDNStateUpdate(statesInfo, mixStreamID);
                }
            }
        });
    }

    public static void onSoundLevelInMixStreamCallback(ArrayList<ZegoSoundLevelInMixStreamInfo> lists) {
        if (mSoundLevelCallback != null) {
            mSoundLevelCallback.onSoundLevelInMixStream(lists);
        }
    }

    public static native boolean mixStream(ZegoCompleteMixStreamInfo var0, int var1);

    public static native int mixStreamEx(ZegoMixStreamConfig var0, String var1);

    private static native void setMixStreamCallback(boolean var0);

    private static native void setMixStreamExCallback(boolean var0);

    private static native void setSoundLevelInMixStreamCallback(boolean var0);
}

