/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2.mediarecorder;

import android.os.Handler;
import android.os.Looper;
import com.zego.zegoavkit2.entities.ZegoPublishStreamQuality;
import com.zego.zegoavkit2.mediarecorder.IZegoMediaRecordCallback;
import com.zego.zegoavkit2.mediarecorder.IZegoMediaRecordCallback2;
import com.zego.zegoavkit2.mediarecorder.IZegoMediaRecordCallbackBase;
import com.zego.zegoavkit2.mediarecorder.ZegoMediaRecordChannelIndex;
import com.zego.zegoavkit2.mediarecorder.ZegoMediaRecordFormat;
import com.zego.zegoavkit2.mediarecorder.ZegoMediaRecordJNI;
import com.zego.zegoavkit2.mediarecorder.ZegoMediaRecordType;

public class ZegoMediaRecorder
implements IZegoMediaRecordCallback2 {
    private volatile IZegoMediaRecordCallbackBase mZegoMediaRecordCallback = null;
    private Handler mHandler = new Handler(Looper.getMainLooper());

    public boolean startRecord(ZegoMediaRecordChannelIndex channelIndex, ZegoMediaRecordType recordType, String storagePath) {
        if (channelIndex == null) {
            return false;
        }
        if (storagePath == null) {
            storagePath = "";
        }
        return ZegoMediaRecordJNI.startRecord(channelIndex.value(), recordType.value(), storagePath);
    }

    public boolean startRecord(ZegoMediaRecordChannelIndex channelIndex, ZegoMediaRecordType recordType, String storagePath, boolean enableStatusCallback, int interval) {
        if (channelIndex == null) {
            return false;
        }
        if (storagePath == null) {
            storagePath = "";
        }
        ZegoMediaRecordFormat format = ZegoMediaRecordFormat.FLV;
        return ZegoMediaRecordJNI.startRecordEx(channelIndex.value(), recordType.value(), storagePath, enableStatusCallback, interval, format.value(), false);
    }

    public boolean startRecord(ZegoMediaRecordChannelIndex channelIndex, ZegoMediaRecordType recordType, String storagePath, boolean enableStatusCallback, int interval, ZegoMediaRecordFormat recordFormat) {
        if (channelIndex == null) {
            return false;
        }
        if (storagePath == null) {
            storagePath = "";
        }
        return ZegoMediaRecordJNI.startRecordEx(channelIndex.value(), recordType.value(), storagePath, enableStatusCallback, interval, recordFormat.value(), false);
    }

    public boolean startRecord(ZegoMediaRecordChannelIndex channelIndex, ZegoMediaRecordType recordType, String storagePath, boolean enableStatusCallback, int interval, ZegoMediaRecordFormat recordFormat, boolean isFragment) {
        if (channelIndex == null) {
            return false;
        }
        if (storagePath == null) {
            storagePath = "";
        }
        return ZegoMediaRecordJNI.startRecordEx(channelIndex.value(), recordType.value(), storagePath, enableStatusCallback, interval, recordFormat.value(), isFragment);
    }

    public boolean stopRecord(ZegoMediaRecordChannelIndex channelIndex) {
        if (channelIndex == null) {
            return false;
        }
        ZegoMediaRecordJNI.stopRecord(channelIndex.value());
        return true;
    }

    public void setZegoMediaRecordCallback(IZegoMediaRecordCallback callback) {
        this.setZegoMediaRecordCallbackBase(callback);
    }

    public void setZegoMediaRecordCallback(IZegoMediaRecordCallback2 callback) {
        this.setZegoMediaRecordCallbackBase(callback);
    }

    private void setZegoMediaRecordCallbackBase(IZegoMediaRecordCallbackBase callback) {
        this.mZegoMediaRecordCallback = callback;
        if (callback != null) {
            ZegoMediaRecordJNI.setCallback(this);
            ZegoMediaRecordJNI.setMediaRecordCallback(true);
        } else {
            ZegoMediaRecordJNI.setCallback(null);
            ZegoMediaRecordJNI.setMediaRecordCallback(false);
        }
    }

    @Override
    public void onMediaRecord(final int errCode, final ZegoMediaRecordChannelIndex channelIndex, final String storagePath) {
        final IZegoMediaRecordCallbackBase callback = this.mZegoMediaRecordCallback;
        if (callback != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    callback.onMediaRecord(errCode, channelIndex, storagePath);
                }
            });
        }
    }

    @Override
    public void onRecordStatusUpdate(final ZegoMediaRecordChannelIndex channelIndex, final String storagePath, final long duration, final long fileSize, final ZegoPublishStreamQuality q) {
        final IZegoMediaRecordCallbackBase callback = this.mZegoMediaRecordCallback;
        if (callback != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (callback instanceof IZegoMediaRecordCallback) {
                        ((IZegoMediaRecordCallback)callback).onRecordStatusUpdate(channelIndex, storagePath, duration, fileSize);
                    } else if (callback instanceof IZegoMediaRecordCallback2) {
                        ((IZegoMediaRecordCallback2)callback).onRecordStatusUpdate(channelIndex, storagePath, duration, fileSize, q);
                    }
                }
            });
        }
    }
}

