/*
 * Decompiled with CFR 0.152.
 */
package com.zego.zegoavkit2;

import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.view.View;
import java.nio.ByteBuffer;

public abstract class ZegoVideoCaptureDevice {
    public static final int PIXEL_FORMAT_UNKNOWN = 0;
    public static final int PIXEL_FORMAT_I420 = 1;
    public static final int PIXEL_FORMAT_NV12 = 2;
    public static final int PIXEL_FORMAT_NV21 = 3;
    public static final int PIXEL_FORMAT_BGRA32 = 4;
    public static final int PIXEL_FORMAT_RGBA32 = 5;
    public static final int PIXEL_BUFFER_TYPE_UNKNOWN = 0;
    public static final int PIXEL_BUFFER_TYPE_MEM = 1;
    public static final int PIXEL_BUFFER_TYPE_CV_PIXEL_BUFFER = 2;
    public static final int PIXEL_BUFFER_TYPE_SURFACE_TEXTURE = 4;
    public static final int PIXEL_BUFFER_TYPE_GL_TEXTURE_2D = 8;
    public static final int PIXEL_BUFFER_TYPE_ENCODED_FRAME = 16;

    protected abstract void allocateAndStart(Client var1);

    protected abstract void stopAndDeAllocate();

    protected abstract int startCapture();

    protected abstract int stopCapture();

    protected abstract int supportBufferType();

    protected abstract int setFrameRate(int var1);

    protected abstract int setResolution(int var1, int var2);

    protected abstract int setFrontCam(int var1);

    protected abstract int setView(View var1);

    protected abstract int setViewMode(int var1);

    protected abstract int setViewRotation(int var1);

    protected abstract int setCaptureRotation(int var1);

    protected abstract int startPreview();

    protected abstract int stopPreview();

    protected abstract int enableTorch(boolean var1);

    protected abstract int takeSnapshot();

    protected abstract int setPowerlineFreq(int var1);

    public static interface Client {
        public void destroy();

        public void onByteBufferFrameCaptured(byte[] var1, int var2, VideoCaptureFormat var3, long var4, int var6);

        public void onByteBufferFrameCaptured(ByteBuffer var1, int var2, VideoCaptureFormat var3, long var4, int var6);

        public void onEncodedFrameCaptured(ByteBuffer var1, int var2, VideoCodecConfig var3, boolean var4, double var5);

        public void onError(String var1);

        public void onTakeSnapshot(Bitmap var1);

        public SurfaceTexture getSurfaceTexture();

        public void onTextureCaptured(int var1, int var2, int var3, double var4);

        public void setFillMode(int var1);

        public void setFlipMode(int var1);
    }

    public static class VideoCodecConfig {
        public int width = 0;
        public int height = 0;
        public int codec_type = 0;
        public int rotation = 0;
    }

    public static class VideoCaptureFormat {
        public int width = 0;
        public int height = 0;
        public int[] strides = new int[]{0, 0, 0, 0};
        public int rotation = 0;
        public int pixel_format = 0;
    }

    public static class ZegoVideoCodecType {
        public static final int ZegoVideoCodecTypeAVCAVCC = 0;
        public static final int ZegoVideoCodecTypeAVCANNEXB = 1;
    }

    public static class ZegoVideoFlipMode {
        public static final int None = 0;
        public static final int Horizontal = 1;
        public static final int Vertical = 2;
    }
}

