package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

/**
 * Advanced room configuration
 *
 * Configure maximum number of users in the room and authentication token, etc.
 */
public class ZegoRoomConfig {

    /** The maximum number of users in the room, Passing 0 means unlimited, the default is unlimited. */
    public int maxMemberCount;

    /** Whether to enable the user in and out of the room callback notification [onRoomUserUpdate], the default is off. */
    public boolean isUserStatusNotify;

    /** The token issued by the developer's business server is used to ensure security. The generation rules are detailed in [https://doc.zego.im/CN/565.html](https://doc.zego.im/CN/565.html). Default is empty string, that is, no authentication */
    public String token;

    public ZegoRoomConfig() {
        maxMemberCount = 0;
        isUserStatusNotify = false;
        token = "";    
    }

}
