package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

/**
 * Advanced engine configuration
 *
 * When you need to use the advanced functions of SDK, such as custom video capture, custom video rendering and other advanced functions, you need to set the instance corresponding to the advanced function configuration to the corresponding field of this type of instance to achieve the purpose of enabling the corresponding advanced functions of ZegoExpressEngine.
 * The configuration of the corresponding advanced functions needs to be set before [createEngine], and it is invalid to set after [createEngine].
 */
public class ZegoEngineConfig {

    /** Log configuration, if not set, use the default configuration */
    public ZegoLogConfig logConfig;

    /** Main channel custom video capture config, if not set, custom video capture config is not enabled by default */
    public ZegoCustomVideoCaptureConfig customVideoCaptureMainConfig;

    /** Auxiliary channel custom video capture config, if not set, custom video capture config is not enabled by default */
    public ZegoCustomVideoCaptureConfig customVideoCaptureAuxConfig;

    /** Custom video render config, if not set, custom video render config is not enabled by default */
    public ZegoCustomVideoRenderConfig customVideoRenderConfig;

    /** Other special function switches, if not set, no other special functions are used by default. The special functions referred to here do not include the functions listed in the other parameter fields of the custom video capture function and custom video rendering described above. */
    public HashMap<String, String> advancedConfig;

    /** Dynamic library path. For developers who need to dynamically load so, the default is empty string. Use project packaged so */
    public String soFullPath;

    public ZegoEngineConfig() {
        logConfig = new ZegoLogConfig();
        soFullPath = "";    
    }

}
