package im.zego.zegoexpress.constants;

/** Video Codec ID */
public enum ZegoVideoCodecID {
    /** default */
    DEFAULT(0),
    /** SVC */
    SVC(1),
    /** VP8 */
    VP8(2);

    private int value;

    private ZegoVideoCodecID(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ZegoVideoCodecID getZegoVideoCodecID(int value) {
        try {
            return ZegoVideoCodecID.values()[value];
        } catch (Exception e) {
            throw new RuntimeException("The enumeration cannot be found");
        }
    }
}