package im.zego.zegoexpress.constants;

public enum ZegoLatencyMode {
    /** 普通延迟模式
     */
    NORMAL(0),
    /** 低延迟模式，无法用于 RTMP 流 
     */
    LOW(1),
    /** 普通延迟模式，最高码率可达 192 kbps
     */
    NORMAL2(2),
    /** 低延迟模式，无法用于 RTMP 流。相对于 ZEGO_LATENCY_MODE_LOW 而言，CPU 开销稍低
     */
    LOW2(3),
    /** 低延迟模式，无法用于 RTMP 流。支持WebRTC必须使用此模式
     */
    LOW3(4),
    /** 普通延迟模式
     */
    NORMAL3(5);

    private int value;

    private ZegoLatencyMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
