/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.module.mediaplayer;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.module.mediaplayer.ZegoMediaplayer;
import im.zego.zegoexpress.module.mediaplayer.callback.IZegoMediaplayerAudioHandler;
import im.zego.zegoexpress.module.mediaplayer.callback.IZegoMediaplayerEventHandler;
import im.zego.zegoexpress.module.mediaplayer.callback.IZegoMediaplayerVideoHandler;
import im.zego.zegoexpress.module.mediaplayer.callback.ZegoMediaplayerLoadResourceCallback;
import im.zego.zegoexpress.module.mediaplayer.callback.ZegoMediaplayerSeekToCallback;
import im.zego.zegoexpress.module.mediaplayer.entity.ZegoMediaplayerNetworkEvent;
import im.zego.zegoexpress.module.mediaplayer.entity.ZegoMediaplayerState;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class ZegoMediaplayerJni {
    private static Handler mUIHandler = new Handler(Looper.getMainLooper());
    private static HashMap<ZegoMediaplayer, IdxAndHandler> mediaplayerToIdxAndEventhandler = new HashMap();

    static void setEventHandler(@NonNull ZegoMediaplayer mediaplayer, IZegoMediaplayerEventHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            idxAndHandler.eventHandler = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerStateUpdateCallback(int state, final int errorcode, int idx) {
        final ZegoMediaplayerState zegoMediaplayerState = ZegoMediaplayerState.values()[state];
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            for (final Map.Entry<ZegoMediaplayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaplayerIdx != idx) continue;
                if (item.getValue().eventHandler == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((IdxAndHandler)item.getValue()).eventHandler.onMediaPlayerStateUpdate((ZegoMediaplayer)item.getKey(), zegoMediaplayerState, errorcode);
                    }
                });
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerNetWorkEventCallback(int event, int idx) {
        final ZegoMediaplayerNetworkEvent zegoMediaplayerNetworkEvent = ZegoMediaplayerNetworkEvent.values()[event];
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            for (final Map.Entry<ZegoMediaplayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaplayerIdx != idx) continue;
                if (item.getValue().eventHandler == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((IdxAndHandler)item.getValue()).eventHandler.onMediaPlayerNetworkEvent((ZegoMediaplayer)item.getKey(), zegoMediaplayerNetworkEvent);
                    }
                });
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerPlayingProgressCallback(int idx, final long millisecond) {
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            for (final Map.Entry<ZegoMediaplayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaplayerIdx != idx) continue;
                if (item.getValue().eventHandler == null) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((IdxAndHandler)item.getValue()).eventHandler.onMediaPlayerPlayingProgress((ZegoMediaplayer)item.getKey(), millisecond);
                    }
                });
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    static void setVideoHandler(ZegoMediaplayer mediaplayer, ZegoVideoFrameFormat frameFormat, IZegoMediaplayerVideoHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            idxAndHandler.videoHandler = handler;
            if (handler == null) {
                ZegoMediaplayerJni.enableVideoDataJni(frameFormat.value(), false, idxAndHandler.kMediaplayerIdx);
            } else {
                ZegoMediaplayerJni.enableVideoDataJni(frameFormat.value(), true, idxAndHandler.kMediaplayerIdx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerVideoHandlerCallback(int idx, final ByteBuffer[] buffer, final int[] datalength, int[] strides, int format, int width, int height) {
        final ZegoVideoFrameParam videoFrameParam = new ZegoVideoFrameParam();
        videoFrameParam.height = height;
        videoFrameParam.strides = strides;
        videoFrameParam.width = width;
        videoFrameParam.format = ZegoVideoFrameFormat.values()[format];
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            for (final Map.Entry<ZegoMediaplayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaplayerIdx != idx) continue;
                if (item.getValue().videoHandler == null) {
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((IdxAndHandler)item.getValue()).videoHandler.onVideoFrame((ZegoMediaplayer)item.getKey(), buffer, datalength, videoFrameParam);
                    }
                });
            }
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    static void setAudioHandler(ZegoMediaplayer mediaplayer, IZegoMediaplayerAudioHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            idxAndHandler.audioHandler = handler;
            if (handler == null) {
                ZegoMediaplayerJni.enableAudioDataJni(false, idxAndHandler.kMediaplayerIdx);
            } else {
                ZegoMediaplayerJni.enableAudioDataJni(true, idxAndHandler.kMediaplayerIdx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onMediaPlayerAudioHandlerCallback(int idx, final ByteBuffer buffer, final int bufferLength, int channels, int samplesRate) {
        final ZegoAudioFrameParam audioFrame = new ZegoAudioFrameParam();
        audioFrame.channels = channels;
        audioFrame.sampleRate = samplesRate;
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            for (final Map.Entry<ZegoMediaplayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaplayerIdx != idx) continue;
                if (item.getValue().audioHandler == null) {
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((IdxAndHandler)item.getValue()).audioHandler.onAudioFrame((ZegoMediaplayer)item.getKey(), buffer, bufferLength, audioFrame);
                    }
                });
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    static void loadResource(ZegoMediaplayer mediaplayer, String path, ZegoMediaplayerLoadResourceCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.loadResourceJni(idxAndHandler.kMediaplayerIdx, path);
            idxAndHandler.loadResourceCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onLoadResourceCallback(int idx, final int errorcode) {
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            for (final Map.Entry<ZegoMediaplayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaplayerIdx != idx) continue;
                if (item.getValue().loadResourceCallback == null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ((IdxAndHandler)item.getValue()).loadResourceCallback.onLoadResourceCallback(errorcode);
                    }
                });
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static void start(ZegoMediaplayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.startJni(idxAndHandler.kMediaplayerIdx);
        }
    }

    static void stop(ZegoMediaplayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.stopJni(idxAndHandler.kMediaplayerIdx);
        }
    }

    static void pause(ZegoMediaplayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.pauseJni(idxAndHandler.kMediaplayerIdx);
        }
    }

    static void resume(ZegoMediaplayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.resumeJni(idxAndHandler.kMediaplayerIdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void seekTo(ZegoMediaplayer mediaplayer, long millisecond, ZegoMediaplayerSeekToCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler == null) return;
        int seq = ZegoMediaplayerJni.seekToJni(idxAndHandler.kMediaplayerIdx, millisecond);
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            idxAndHandler.seekToTimeCallbackHashMap.put(seq, callback);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void onSeekToTimeCallback(final int seq, int idx, final int errorcode) {
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            for (final Map.Entry<ZegoMediaplayer, IdxAndHandler> item : mediaplayerToIdxAndEventhandler.entrySet()) {
                if (item.getValue().kMediaplayerIdx != idx) continue;
                final ZegoMediaplayerSeekToCallback seekToTimeCallback = item.getValue().seekToTimeCallbackHashMap.get(seq);
                if (seekToTimeCallback == null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                mUIHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        seekToTimeCallback.onSeekToTimeCallback(errorcode);
                        ((IdxAndHandler)item.getValue()).seekToTimeCallbackHashMap.remove(seq);
                    }
                });
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static void enableRepeat(ZegoMediaplayer mediaplayer, boolean enable) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.enableRepeatJni(idxAndHandler.kMediaplayerIdx, enable);
        }
    }

    public static void enableAux(ZegoMediaplayer mediaplayer, boolean enable) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.enableAuxJni(idxAndHandler.kMediaplayerIdx, enable);
        }
    }

    public static void muteLocal(ZegoMediaplayer mediaplayer, boolean mute) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.muteLocalJni(idxAndHandler.kMediaplayerIdx, mute);
        }
    }

    static void setPlayerCanvas(ZegoMediaplayer mediaplayer, ZegoCanvas canvas) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            if (canvas != null) {
                ZegoMediaplayerJni.setPlayerCanvasJni(idxAndHandler.kMediaplayerIdx, canvas.view, canvas.viewMode.value(), canvas.backgroundColor);
            } else {
                ZegoMediaplayerJni.setPlayerCanvasJni(idxAndHandler.kMediaplayerIdx, null, 0, 0);
            }
        }
    }

    static void setVolume(ZegoMediaplayer mediaplayer, int volume) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.setVolumeJni(idxAndHandler.kMediaplayerIdx, volume);
        }
    }

    static int getVolume(ZegoMediaplayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            return ZegoMediaplayerJni.getVolumeJni(idxAndHandler.kMediaplayerIdx);
        }
        return -1;
    }

    static void setProgressInterval(ZegoMediaplayer mediaplayer, long millisecond) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            ZegoMediaplayerJni.setProgressIntervalJni(idxAndHandler.kMediaplayerIdx, millisecond);
        }
    }

    static long getTotalDuration(ZegoMediaplayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            return ZegoMediaplayerJni.getTotalDurationJni(idxAndHandler.kMediaplayerIdx);
        }
        return -1L;
    }

    static long getCurrentProgress(ZegoMediaplayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            return ZegoMediaplayerJni.getCurrentProgressJni(idxAndHandler.kMediaplayerIdx);
        }
        return -1L;
    }

    public static ZegoMediaplayer createMediaplayer() {
        int index = ZegoMediaplayerJni.createMediaplayerJni();
        if (index >= 0) {
            ZegoMediaplayer zegoMediaplayer = ZegoMediaplayer.createMediaplayer();
            IdxAndHandler idxAndHandler = new IdxAndHandler(index);
            idxAndHandler.seekToTimeCallbackHashMap = new HashMap();
            mediaplayerToIdxAndEventhandler.put(zegoMediaplayer, idxAndHandler);
            return zegoMediaplayer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void destroyMediaplayer(ZegoMediaplayer mediaplayer) {
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            Iterator<Map.Entry<ZegoMediaplayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ZegoMediaplayer, IdxAndHandler> item = it.next();
                if (item.getKey() != mediaplayer) continue;
                item.getValue().videoHandler = null;
                item.getValue().audioHandler = null;
                item.getValue().eventHandler = null;
                item.getValue().loadResourceCallback = null;
                Iterator<Map.Entry<Integer, ZegoMediaplayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                while (itSeekToTimeCallbackHashMap.hasNext()) {
                    itSeekToTimeCallbackHashMap.remove();
                }
                item.getValue().seekToTimeCallbackHashMap = null;
                int idx = item.getValue().kMediaplayerIdx;
                ZegoMediaplayerJni.destroyMediaplayerJni(idx);
                it.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAllMediaplayer() {
        Class<ZegoMediaplayerJni> clazz = ZegoMediaplayerJni.class;
        synchronized (ZegoMediaplayerJni.class) {
            Iterator<Map.Entry<ZegoMediaplayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ZegoMediaplayer, IdxAndHandler> item = it.next();
                item.getValue().videoHandler = null;
                item.getValue().audioHandler = null;
                item.getValue().eventHandler = null;
                item.getValue().loadResourceCallback = null;
                Iterator<Map.Entry<Integer, ZegoMediaplayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
                while (itSeekToTimeCallbackHashMap.hasNext()) {
                    itSeekToTimeCallbackHashMap.remove();
                }
                item.getValue().seekToTimeCallbackHashMap = null;
                int idx = item.getValue().kMediaplayerIdx;
                ZegoMediaplayerJni.destroyMediaplayerJni(idx);
                it.remove();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static ZegoMediaplayerState getCurrentState(ZegoMediaplayer mediaplayer) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(mediaplayer);
        if (idxAndHandler != null) {
            int state = ZegoMediaplayerJni.getCurrentStateJni(idxAndHandler.kMediaplayerIdx);
            ZegoMediaplayerState zegoMediaplayerState = state == ZegoMediaplayerState.NO_PLAY.value() ? ZegoMediaplayerState.NO_PLAY : (state == ZegoMediaplayerState.PLAYING.value() ? ZegoMediaplayerState.PLAYING : (state == ZegoMediaplayerState.PAUSING.value() ? ZegoMediaplayerState.PAUSING : (state == ZegoMediaplayerState.PLAY_ENDED.value() ? ZegoMediaplayerState.PLAY_ENDED : ZegoMediaplayerState.NO_PLAY)));
            return zegoMediaplayerState;
        }
        return ZegoMediaplayerState.NO_PLAY;
    }

    static native int getCurrentStateJni(int var0);

    static native int destroyMediaplayerJni(int var0);

    static native int createMediaplayerJni();

    static native int startJni(int var0);

    static native int stopJni(int var0);

    static native int pauseJni(int var0);

    static native int resumeJni(int var0);

    static native int enableRepeatJni(int var0, boolean var1);

    static native int enableAuxJni(int var0, boolean var1);

    static native int muteLocalJni(int var0, boolean var1);

    static native int setPlayerCanvasJni(int var0, Object var1, int var2, int var3);

    static native int setVolumeJni(int var0, int var1);

    static native int setProgressIntervalJni(int var0, long var1);

    static native long getTotalDurationJni(int var0);

    static native long getCurrentProgressJni(int var0);

    static native int seekToJni(int var0, long var1);

    static native int loadResourceJni(int var0, String var1);

    static native int enableAudioDataJni(boolean var0, int var1);

    static native int enableVideoDataJni(int var0, boolean var1, int var2);

    static native int getVolumeJni(int var0);

    static class IdxAndHandler {
        int kMediaplayerIdx;
        HashMap<Integer, ZegoMediaplayerSeekToCallback> seekToTimeCallbackHashMap;
        ZegoMediaplayerLoadResourceCallback loadResourceCallback;
        IZegoMediaplayerEventHandler eventHandler;
        IZegoMediaplayerAudioHandler audioHandler;
        IZegoMediaplayerVideoHandler videoHandler;

        IdxAndHandler(int idx) {
            this.kMediaplayerIdx = idx;
        }
    }
}

