/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import im.zego.zegoexpress.ZegoExpressEngine;
import im.zego.zegoexpress.callback.IZegoEventHandler;
import im.zego.zegoexpress.callback.IZegoExternalVideoCapturer;
import im.zego.zegoexpress.callback.IZegoExternalVideoRenderer;
import im.zego.zegoexpress.callback.IZegoIMSendBroadcastMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendCustomCommandCallback;
import im.zego.zegoexpress.callback.IZegoMixerStartCallback;
import im.zego.zegoexpress.callback.IZegoMixerStopCallback;
import im.zego.zegoexpress.callback.IZegoPublisherSetStreamExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoPublisherUpdateCDNURLCallback;
import im.zego.zegoexpress.callback.ZegoMixerStartResult;
import im.zego.zegoexpress.constants.ZegoAECMode;
import im.zego.zegoexpress.constants.ZegoCapturePipelineScaleMode;
import im.zego.zegoexpress.constants.ZegoDebugLayer;
import im.zego.zegoexpress.constants.ZegoDebugLevel;
import im.zego.zegoexpress.constants.ZegoLanguage;
import im.zego.zegoexpress.constants.ZegoOrientation;
import im.zego.zegoexpress.constants.ZegoPlayerFirstFrameEvent;
import im.zego.zegoexpress.constants.ZegoPlayerMediaEvent;
import im.zego.zegoexpress.constants.ZegoPlayerState;
import im.zego.zegoexpress.constants.ZegoPublisherFirstFrameEvent;
import im.zego.zegoexpress.constants.ZegoPublisherState;
import im.zego.zegoexpress.constants.ZegoRemoteDeviceState;
import im.zego.zegoexpress.constants.ZegoRoomState;
import im.zego.zegoexpress.constants.ZegoScenario;
import im.zego.zegoexpress.constants.ZegoUpdateType;
import im.zego.zegoexpress.constants.ZegoVideoFlipMode;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.constants.ZegoVideoMirrorMode;
import im.zego.zegoexpress.constants.ZegoViewMode;
import im.zego.zegoexpress.entity.ZegoAudioConfig;
import im.zego.zegoexpress.entity.ZegoBeautifyOption;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoEngineConfig;
import im.zego.zegoexpress.entity.ZegoMessageInfo;
import im.zego.zegoexpress.entity.ZegoMixerTask;
import im.zego.zegoexpress.entity.ZegoPlayStreamQuality;
import im.zego.zegoexpress.entity.ZegoPublishStreamQuality;
import im.zego.zegoexpress.entity.ZegoReverbParam;
import im.zego.zegoexpress.entity.ZegoRoomConfig;
import im.zego.zegoexpress.entity.ZegoStream;
import im.zego.zegoexpress.entity.ZegoStreamRelayCDNInfo;
import im.zego.zegoexpress.entity.ZegoUser;
import im.zego.zegoexpress.entity.ZegoVideoConfig;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameSender;
import im.zego.zegoexpress.entity.ZegoWatermark;
import im.zego.zegoexpress.module.mediaplayer.ZegoMediaplayer;
import im.zego.zegoexpress.module.mediaplayer.ZegoMediaplayerJni;
import im.zego.zegoexpress.utils.ZegoLibraryLoadUtil;
import im.zego.zegoexpress.utils.ZegoLogUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

final class ZegoExpressEngineJni {
    private static Handler mUIHandler;
    private static volatile boolean hasSoLoaded;
    private static ZegoExpressEngine engine;
    private static Application context;
    private static boolean mIsTestEnv;
    private static ZegoLanguage language;
    private static ArrayList<IZegoEventHandler> sEventHandlerList;
    private static HashMap<Integer, IZegoPublisherUpdateCDNURLCallback> sPublisherUpdateCDNURLHandler;
    private static HashMap<Integer, IZegoPublisherSetStreamExtraInfoCallback> sPublisherUpdateStreamExtraInfoHandler;
    private static HashMap<Integer, IZegoMixerStartCallback> sMixerStartResultHandler;
    private static HashMap<Integer, IZegoMixerStopCallback> sMixerStopResultHandler;
    private static HashMap<Integer, IZegoIMSendBroadcastMessageCallback> sIMSendBoradcastMssageHandler;
    private static HashMap<Integer, IZegoIMSendCustomCommandCallback> sIMSendCustomCommandHandler;
    private static boolean isNoErrorCallback;
    private static final int MAX_EVENT_HANDLE_COUNT = 16;
    private static final int ZEGO_EXPRESS_MODULE_JNI = 12;
    private static final int RESERVE_SEGMENT = 1000000;
    private static final int ERRCODE_OFFSET = 1000;
    private static final int ZEGO_ERRCODE_SUCCESS = 0;
    private static final int ZEGO_ERRCODE_COMMON_ENGINE_NOT_CREATED = 1000001;
    private static final int ZEGO_ERRCODE_ENGINE_APPID_ZERO = 1001000;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_LENGTH = 1001001;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_CHARACTER = 1001002;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_NULL = 1001003;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_NULL = 1001027;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_COUNT_EXCEED = 1001028;
    private static IZegoExternalVideoRenderer mExternalRenderer;
    private static IZegoExternalVideoCapturer mExternalCapturer;
    private static ZegoVideoFrameSender mVideoFrameSender;
    private static ZegoEngineConfig engineConfig;

    ZegoExpressEngineJni() {
    }

    static boolean ensureSoLoaded(Context appContext, String customizeSoPath) {
        if (!hasSoLoaded && !TextUtils.isEmpty((CharSequence)customizeSoPath)) {
            try {
                hasSoLoaded = ZegoLibraryLoadUtil.loadSpecialLibrary(customizeSoPath, appContext);
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)"ZEGO", (String)String.format("Load library %s failed", customizeSoPath), (Throwable)e);
                return false;
            }
            catch (Exception e) {
                Log.e((String)"ZEGO", (String)String.format("Load library %s failed", customizeSoPath), (Throwable)e);
                return false;
            }
        }
        if (!hasSoLoaded) {
            try {
                hasSoLoaded = ZegoLibraryLoadUtil.loadSoFile("libZegoExpressSDK.so", appContext);
                return hasSoLoaded;
            }
            catch (UnsatisfiedLinkError e) {
                Log.e((String)"ZEGO", (String)"Load library libZegoExpressSDK.so failed", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static void setEngineConfig(ZegoEngineConfig engineConfig) {
        ZegoExpressEngineJni.engineConfig = engineConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZegoExpressEngine createEngine(long appID, String appSign, boolean isTestEnvironment, ZegoScenario scenario, Application application, IZegoEventHandler handler) {
        int engineConfig_zegoExternalVideoCaptureType;
        boolean engineConfig_enableExternalVideoCapture;
        int engineConfig_zegoExternalVideoRenderType;
        boolean engineConfig_isInternalRender;
        int engineConfig_zegoExternalVideoRenderSeries;
        boolean engineConfig_enableExternalVideoRender;
        if (engine != null) {
            return engine;
        }
        if (application == null) {
            switch (language) {
                case ENGLISH: {
                    throw new RuntimeException("Input application parameter abnormal");
                }
                case CHINESE: {
                    throw new RuntimeException("\u8f93\u5165application\u53c2\u6570\u5f02\u5e38");
                }
            }
        }
        if (engineConfig == null) {
            engineConfig = new ZegoEngineConfig();
        }
        String advanceConfig = "";
        if (ZegoExpressEngineJni.engineConfig.advancedConfig != null) {
            for (String key : ZegoExpressEngineJni.engineConfig.advancedConfig.keySet()) {
                advanceConfig = advanceConfig + key + "=" + ZegoExpressEngineJni.engineConfig.advancedConfig.get(key) + ";";
            }
        }
        if (ZegoExpressEngineJni.engineConfig.externalVideoRenderConfig != null) {
            engineConfig_enableExternalVideoRender = true;
            engineConfig_zegoExternalVideoRenderSeries = ZegoExpressEngineJni.engineConfig.externalVideoRenderConfig.frameFormatSeries.value();
            engineConfig_isInternalRender = ZegoExpressEngineJni.engineConfig.externalVideoRenderConfig.enableInternalRender;
            engineConfig_zegoExternalVideoRenderType = ZegoExpressEngineJni.engineConfig.externalVideoRenderConfig.bufferType.value();
        } else {
            engineConfig_enableExternalVideoRender = false;
            engineConfig_isInternalRender = false;
            engineConfig_zegoExternalVideoRenderSeries = -1;
            engineConfig_zegoExternalVideoRenderType = -1;
        }
        if (ZegoExpressEngineJni.engineConfig.externalVideoCaptureConfig != null) {
            engineConfig_enableExternalVideoCapture = true;
            engineConfig_zegoExternalVideoCaptureType = ZegoExpressEngineJni.engineConfig.externalVideoCaptureConfig.bufferType.value();
        } else {
            engineConfig_enableExternalVideoCapture = false;
            engineConfig_zegoExternalVideoCaptureType = -1;
        }
        try {
            if (ZegoExpressEngineJni.engineConfig.logConfig.logPath.equals("")) {
                ZegoExpressEngineJni.engineConfig.logConfig.logPath = ZegoLogUtil.getLogPath((Context)application);
            }
        }
        catch (Exception ex) {
            switch (language) {
                case ENGLISH: {
                    throw new RuntimeException("Input application parameter abnormal");
                }
                case CHINESE: {
                    throw new RuntimeException("\u8f93\u5165application\u53c2\u6570\u5f02\u5e38");
                }
            }
        }
        ZegoExpressEngineJni.setEngineInitConfigToJni(engineConfig, engineConfig_enableExternalVideoRender, engineConfig_zegoExternalVideoRenderSeries, engineConfig_isInternalRender, engineConfig_zegoExternalVideoRenderType, engineConfig_enableExternalVideoCapture, engineConfig_zegoExternalVideoCaptureType, ZegoExpressEngineJni.engineConfig.logConfig.logPath, ZegoExpressEngineJni.engineConfig.logConfig.logSize, advanceConfig);
        int errorCode = ZegoExpressEngineJni.engineInitJni(appID, appSign, isTestEnvironment, scenario.value(), (Context)application);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 0, "createEngine", errorCode, new Object[0]);
        if (errorCode != 0) {
            switch (language) {
                default: {
                    throw new RuntimeException("Create engine failed, errorCode = " + errorCode);
                }
                case CHINESE: 
            }
            throw new RuntimeException("\u521b\u5efa\u5f15\u64ce\u5931\u8d25, errorCode = " + errorCode);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            mUIHandler = new Handler(Looper.getMainLooper());
            context = application;
            mIsTestEnv = isTestEnvironment;
            engine = new ZegoExpressEngine();
            if (handler != null) {
                engine.addEventHandler(handler);
            }
            // ** MonitorExit[var15_17] (shouldn't be in output)
            return engine;
        }
    }

    public static ZegoExpressEngine getEngine() {
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyEngine() {
        int errorCode = ZegoExpressEngineJni.engineUninitJni();
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (sEventHandlerList != null) {
                sEventHandlerList.clear();
            }
            context = null;
            engine = null;
            mIsTestEnv = true;
            mUIHandler = null;
            language = ZegoLanguage.ENGLISH;
            isNoErrorCallback = false;
            ZegoMediaplayerJni.destroyAllMediaplayer();
            ZegoExpressEngineJni.setExternalVideoCapturer(null);
            ZegoExpressEngineJni.setExternalVideoRenderer(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addEventHandler(IZegoEventHandler eventHandler) {
        int errorCode = 0;
        boolean isExist = false;
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (engine == null) {
                errorCode = 1000001;
            } else if (eventHandler != null) {
                for (int i = 0; i < sEventHandlerList.size(); ++i) {
                    if (sEventHandlerList.get(i) != eventHandler) continue;
                    isExist = true;
                }
                if (!isExist) {
                    if (sEventHandlerList.size() >= 16) {
                        errorCode = 1001028;
                    } else {
                        sEventHandlerList.add(eventHandler);
                    }
                } else {
                    errorCode = 0;
                }
            } else {
                errorCode = 1001027;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 0, "addEventHandler", errorCode, new Object[0]);
            ZegoExpressEngineJni.logInfo(ZegoLogUtil.getFileName(), ZegoLogUtil.getMethodName(), ZegoLogUtil.getLineNumber(), ZegoDebugLevel.INFO, ZegoDebugLayer.DEBUG_LAYER_JNI, 1, "addEventHandler", new Object[0]);
            return errorCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void removeEventHandler(IZegoEventHandler eventHandler) {
        if (eventHandler == null) return;
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (sEventHandlerList == null) return;
            sEventHandlerList.remove(eventHandler);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String getVersion() {
        return ZegoExpressEngineJni.getVersionJni();
    }

    public static void setDebugVerbose(boolean enable, ZegoLanguage language) {
        ZegoExpressEngineJni.language = language;
        ZegoExpressEngineJni.setDebugVerboseJni(enable, language.value());
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 1, "setDebugVerbose", 0, new Object[0]);
    }

    public static void uploadLog() {
        ZegoExpressEngineJni.uploadLogJni();
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 1, "uploadLog", 0, new Object[0]);
    }

    public static int loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config) {
        int maxMemberCount = 0;
        int userStateNotify = 0;
        if (config != null) {
            maxMemberCount = config.maxMemberCount;
            userStateNotify = config.isUserStateNotify ? 1 : 0;
        }
        String userID = "";
        String userName = "";
        if (user != null) {
            userID = user.userID;
            userName = user.userName;
        }
        if (roomID == null) {
            roomID = "";
        }
        ZegoExpressEngineJni.logInfo(ZegoLogUtil.getFileName(), ZegoLogUtil.getMethodName(), ZegoLogUtil.getLineNumber(), ZegoDebugLevel.INFO, ZegoDebugLayer.DEBUG_LAYER_JNI, 2, "%s, %s, %s, %d, %d", roomID, userID, userName, maxMemberCount, userStateNotify);
        int errorCode = ZegoExpressEngineJni.loginRoomJni(user, roomID, config);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "loginRoom", errorCode, new Object[0]);
        return errorCode;
    }

    public static int loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config, String token) {
        int errorCode = ZegoExpressEngineJni.loginRoomJni(user, roomID, config, token);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "loginRoom", errorCode, new Object[0]);
        return errorCode;
    }

    public static void logoutRoom(String roomID) {
        int errorCode = ZegoExpressEngineJni.logoutRoomJni(roomID);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 2, "logoutRoom", errorCode, new Object[0]);
    }

    public static void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode) {
        int errorCode = mirrorMode == null ? ZegoExpressEngineJni.ZegoVideoMirrorModeJni(ZegoVideoMirrorMode.ONLY_PREVIEW_MIRROR.value()) : ZegoExpressEngineJni.ZegoVideoMirrorModeJni(mirrorMode.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setVideoMirrorMode", errorCode, new Object[0]);
    }

    public static void setAppOrientation(ZegoOrientation orientation) {
        int errorCode = orientation == null ? ZegoExpressEngineJni.setAppOrientationJni(ZegoOrientation.ORIENTATION_0.value()) : ZegoExpressEngineJni.setAppOrientationJni(orientation.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAppOrientation", errorCode, new Object[0]);
    }

    public static void startPreview(ZegoCanvas canvas) {
        int errorCode = canvas == null ? ZegoExpressEngineJni.startPreviewJni(null, ZegoViewMode.ASPECT_FILL.value(), 0) : (canvas.viewMode == null ? ZegoExpressEngineJni.startPreviewJni(canvas.view, ZegoViewMode.ASPECT_FILL.value(), canvas.backgroundColor) : ZegoExpressEngineJni.startPreviewJni(canvas.view, canvas.viewMode.value(), canvas.backgroundColor));
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startPreview", errorCode, new Object[0]);
    }

    public static void stopPreview() {
        int errorCode = ZegoExpressEngineJni.stopPreviewJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopPreview", errorCode, new Object[0]);
    }

    public static void setVideoConfig(ZegoVideoConfig videoConfig) {
        int errorCode = ZegoExpressEngineJni.setVideoConfigJni(videoConfig);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setVideoConfig", errorCode, new Object[0]);
    }

    public static int startPublishing(String streamID) {
        int errorCode = ZegoExpressEngineJni.startPublishingJni(streamID);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startPublish", errorCode, new Object[0]);
        return errorCode;
    }

    public static void stopPublishing() {
        int errorCode = ZegoExpressEngineJni.stopPublishingJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopPublishJni", errorCode, new Object[0]);
    }

    public static void mutePublishStreamAudio(boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePublishStreamAudioJni(mute);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "mutePublishStreamAudio", errorCode, new Object[0]);
    }

    public static void mutePublishStreamVideo(boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePublishStreamVideoJni(mute);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "mutePublishStreamVideo", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStreamExtraInfo(String extraInfo, IZegoPublisherSetStreamExtraInfoCallback handler) {
        int seq = ZegoExpressEngineJni.setStreamExtraInfoJni(extraInfo);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateStreamExtraInfoHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void setCaptureVolume(int volume) {
        int errorCode = ZegoExpressEngineJni.setCaptureVolumeJni(volume);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setCaptureVolume", errorCode, new Object[0]);
    }

    public static void setAudioConfig(ZegoAudioConfig config) {
        int errorCode = ZegoExpressEngineJni.setAudioConfigJni(config);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAudioConfig", errorCode, new Object[0]);
    }

    public static void enableTrafficControl(boolean enable, int controlTypeBitMask) {
        int errorCode = ZegoExpressEngineJni.enableTrafficControlJni(enable, controlTypeBitMask);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableTrafficControl", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPublishCDNURL(String streamID, String targetURL, IZegoPublisherUpdateCDNURLCallback handler) {
        int seq = ZegoExpressEngineJni.addPublishCDNURLJni(streamID, targetURL);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePublishCDNURL(String streamID, String targetURL, IZegoPublisherUpdateCDNURLCallback handler) {
        int seq = ZegoExpressEngineJni.removePublishCDNURLJni(streamID, targetURL);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public static void setCapturePipelineScaleMode(ZegoCapturePipelineScaleMode mode) {
        int errorCode = ZegoExpressEngineJni.setCapturePipelineScaleModeJni(mode.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setCapturePipelineScaleMode", errorCode, new Object[0]);
    }

    public static void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible) {
        int errorCode = ZegoExpressEngineJni.setPublishWatermarkJni(watermark, isPreviewVisible);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setPublishWatermark", errorCode, new Object[0]);
    }

    public static void enableHardwareEncoder(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableHardwareEncoderJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableHardwareEncoder", errorCode, new Object[0]);
    }

    public static void enableDTX(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableDTXJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableDTX", errorCode, new Object[0]);
    }

    public static void enableVAD(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableVADJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableVAD", errorCode, new Object[0]);
    }

    public static int startPlayingStream(String streamID, ZegoCanvas canvas) {
        int errorCode = canvas == null ? ZegoExpressEngineJni.startPlayingStreamJni(streamID, null, 0, 0) : ZegoExpressEngineJni.startPlayingStreamJni(streamID, canvas.view, canvas.viewMode == null ? ZegoViewMode.ASPECT_FIT.value() : canvas.viewMode.value(), canvas.backgroundColor);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "startPlayingStream", errorCode, new Object[0]);
        return errorCode;
    }

    public static void stopPlayingStream(String streamID) {
        int errorCode = ZegoExpressEngineJni.stopPlayingStreamJni(streamID);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "stopPlayingStream", errorCode, new Object[0]);
    }

    public static void setPlayVolume(String streamID, int volume) {
        int errorCode = ZegoExpressEngineJni.setPlayVolumeJni(streamID, volume);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "setPlayVolume", errorCode, new Object[0]);
    }

    public static void mutePlayStreamAudio(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePlayStreamAudioJni(streamID, mute);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "mutePlayStreamAudio", errorCode, new Object[0]);
    }

    public static void mutePlayStreamVideo(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePlayStreamVideoJni(streamID, mute);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "mutePlayStreamVideo", errorCode, new Object[0]);
    }

    public static void enableHardwareDecoder(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableHardwareDecoderJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 4, "enableHardwareDecoder", errorCode, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startMixerTask(ZegoMixerTask task, IZegoMixerStartCallback handler) {
        int seq = ZegoExpressEngineJni.startMixerJni(task);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sMixerStartResultHandler.put(seq, handler);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 5, "startMixerTask", 0, new Object[0]);
            return;
        }
    }

    public static void stopMixerTask(String taskID) {
        int errorCode = ZegoExpressEngineJni.stopMixerJni(taskID);
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 5, "stopMixerTask", errorCode, new Object[0]);
    }

    public static void muteMicrophone(boolean mute) {
        int errorCode = ZegoExpressEngineJni.muteMicrophoneJni(mute);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "muteMicrophone", errorCode, new Object[0]);
    }

    public static void muteAudioOutput(boolean enable) {
        int errorCode = ZegoExpressEngineJni.muteAudioOutputJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "muteAudioOutput", errorCode, new Object[0]);
    }

    public static void enableCamera(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableCameraJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCamera", errorCode, new Object[0]);
    }

    public static void useFrontCamera(boolean enable) {
        int errorCode = ZegoExpressEngineJni.useFrontCameraJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "useFrontCamera", errorCode, new Object[0]);
    }

    public static void startSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJni.startSoundLevelMonitorJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startSoundLevelMonitor", errorCode, new Object[0]);
    }

    public static void stopSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJni.stopSoundLevelMonitorJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopSoundLevelMonitor", errorCode, new Object[0]);
    }

    public static void startAudioSpectrumMonitor() {
        int errorCode = ZegoExpressEngineJni.startFrequencySpectrumMonitorJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "startFrequencySpectrumMonitor", errorCode, new Object[0]);
    }

    public static void stopAudioSpectrumMonitor() {
        int errorCode = ZegoExpressEngineJni.stopFrequencySpectrumMonitorJni();
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "stopFrequencySpectrumMonitor", errorCode, new Object[0]);
    }

    public static void enableAudioCaptureDevice(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableCaptureDeviceJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCaptureDevice", errorCode, new Object[0]);
    }

    public static void setBuildInSpeakerOn(boolean enable) {
        int errorCode = ZegoExpressEngineJni.setBuildInSpeakerOnJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setBuildInSpeakerOn", errorCode, new Object[0]);
    }

    public static void enableAEC(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableAECJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableAEC", errorCode, new Object[0]);
    }

    public static void setAECMode(ZegoAECMode mode) {
        int errorCode = ZegoExpressEngineJni.setAECModeJni(mode.value());
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setAECMode", errorCode, new Object[0]);
    }

    public static void enableCheckPoc(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableCheckPocJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableCheckPoc", errorCode, new Object[0]);
    }

    public static void enableAGC(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableAGCJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableAGC", errorCode, new Object[0]);
    }

    public static void enableANS(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableANSJni(enable);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableANS", errorCode, new Object[0]);
    }

    public static void enableBeautify(int feature) {
        int errorCode = ZegoExpressEngineJni.enableBeautifyJni(feature);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "enableBeautify", errorCode, new Object[0]);
    }

    public static void setBeautifyOption(ZegoBeautifyOption option) {
        int errorCode = ZegoExpressEngineJni.setBeautifyOptionJni(option);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "setBeautifyOption", errorCode, new Object[0]);
    }

    public static void sendSEI(ByteBuffer data, int dataLength) {
        int errorCode = ZegoExpressEngineJni.sendSEIJni(data, dataLength);
        ZegoExpressEngineJni.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 3, "sendSEI", errorCode, new Object[0]);
    }

    public static ZegoMediaplayer createMediaplayer() {
        return ZegoMediaplayerJni.createMediaplayer();
    }

    public static void setExternalVideoRenderer(IZegoExternalVideoRenderer renderer) {
        mExternalRenderer = renderer;
    }

    public static void setExternalVideoCapturer(IZegoExternalVideoCapturer capturer) {
        mExternalCapturer = capturer;
        if (capturer == null) {
            ZegoExpressEngineJni.onExternalVideoCaptureWillStop();
        }
    }

    static void onExternalVideoCaptureWillStart() {
        mVideoFrameSender = new ZegoVideoFrameSender();
        if (mExternalCapturer != null) {
            mExternalCapturer.willStart(mVideoFrameSender);
        }
    }

    public static void onExternalVideoCaptureWillStop() {
        if (mVideoFrameSender != null && mExternalCapturer != null) {
            mExternalCapturer.willStop();
            mVideoFrameSender = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBroadcastMessage(String message, String roomID, IZegoIMSendBroadcastMessageCallback callback) {
        int seq = ZegoExpressEngineJni.sendBroadcastMessageJni(message, roomID);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sIMSendBoradcastMssageHandler.put(seq, callback);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 9, "sendBroadcastMessage", 0, new Object[0]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendCustomCommand(String command, ArrayList<ZegoUser> toUserList, String roomID, IZegoIMSendCustomCommandCallback callback) {
        int size = toUserList.size();
        ZegoUser[] userList = toUserList.toArray(new ZegoUser[size]);
        int seq = ZegoExpressEngineJni.sendCustomerMessageJni(command, userList, roomID);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            sIMSendCustomCommandHandler.put(seq, callback);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 9, "sendCustomCommand", 0, new Object[0]);
            return;
        }
    }

    private static native int engineInitJni(long var0, String var2, boolean var3, int var4, Context var5);

    private static native void setEngineInitConfigToJni(ZegoEngineConfig var0, boolean var1, int var2, boolean var3, int var4, boolean var5, int var6, String var7, int var8, String var9);

    private static native int engineUninitJni();

    private static native String getVersionJni();

    private static native void setDebugVerboseJni(boolean var0, int var1);

    private static native void uploadLogJni();

    private static native int loginRoomJni(ZegoUser var0, String var1, ZegoRoomConfig var2);

    private static native int loginRoomJni(ZegoUser var0, String var1, ZegoRoomConfig var2, String var3);

    public static native int logoutRoomJni(String var0);

    public static native int ZegoVideoMirrorModeJni(int var0);

    public static native int setCapturePipelineScaleModeJni(int var0);

    public static native int enableCheckPocJni(boolean var0);

    public static native int setAppOrientationJni(int var0);

    public static native int startPreviewJni(Object var0, int var1, int var2);

    public static native int stopPreviewJni();

    public static native int setVideoConfigJni(ZegoVideoConfig var0);

    public static native int startPublishingJni(String var0);

    public static native int stopPublishingJni();

    public static native int mutePublishStreamAudioJni(boolean var0);

    public static native int mutePublishStreamVideoJni(boolean var0);

    public static native int setStreamExtraInfoJni(String var0);

    public static native int setCaptureVolumeJni(int var0);

    public static native int enableTrafficControlJni(boolean var0, int var1);

    public static native int addPublishCDNURLJni(String var0, String var1);

    public static native int removePublishCDNURLJni(String var0, String var1);

    public static native int setPublishWatermarkJni(ZegoWatermark var0, boolean var1);

    public static native int enableHardwareEncoderJni(boolean var0);

    public static native int enableDTXJni(boolean var0);

    public static native int enableVADJni(boolean var0);

    static native int sendSEIJni(ByteBuffer var0, int var1);

    public static native int startPlayingStreamJni(String var0, Object var1, int var2, int var3);

    public static native int stopPlayingStreamJni(String var0);

    public static native int setPlayVolumeJni(String var0, int var1);

    public static native int mutePlayStreamAudioJni(String var0, boolean var1);

    public static native int mutePlayStreamVideoJni(String var0, boolean var1);

    public static native int enableHardwareDecoderJni(boolean var0);

    public static native int startMixerJni(ZegoMixerTask var0);

    public static native int stopMixerJni(String var0);

    public static native int muteMicrophoneJni(boolean var0);

    public static native int muteAudioOutputJni(boolean var0);

    public static native int enableCameraJni(boolean var0);

    public static native int useFrontCameraJni(boolean var0);

    public static native int startSoundLevelMonitorJni();

    public static native int stopSoundLevelMonitorJni();

    public static native int startFrequencySpectrumMonitorJni();

    public static native int stopFrequencySpectrumMonitorJni();

    public static native int enableCaptureDeviceJni(boolean var0);

    public static native int setBuildInSpeakerOnJni(boolean var0);

    public static native int enableAECJni(boolean var0);

    public static native int setAECModeJni(int var0);

    public static native int enableAGCJni(boolean var0);

    public static native int enableANSJni(boolean var0);

    public static native int enableVirtualStereoJni(boolean var0, int var1);

    public static native int enableReverbJni(boolean var0, int var1);

    public static native int setReverbParamsJni(ZegoReverbParam var0);

    public static native int enableBeautifyJni(int var0);

    public static native int setBeautifyOptionJni(ZegoBeautifyOption var0);

    public static native int setWatermarkImagePathJni(String var0);

    public static native int setPreviewWatermarkPositionJni(int var0, int var1, int var2, int var3);

    public static native int setPublishWatermarkPositionJni(int var0, int var1, int var2, int var3);

    public static native int sendBroadcastMessageJni(String var0, String var1);

    public static native int sendCustomerMessageJni(String var0, ZegoUser[] var1, String var2);

    public static void printDebugInfo(ZegoDebugLevel level, int module, String funcName, int errorCode, Object ... args) {
        String enInfo = "";
        String cnInfo = "";
        String msg = "";
        switch (errorCode) {
            case 1000001: {
                enInfo = "Engine not create, engine need to be created before calling non-static function";
                cnInfo = "\u672a\u521d\u59cb\u5316\u5f15\u64ce\uff0c\u5728\u8c03\u7528\u975e\u9759\u6001\u65b9\u6cd5\u524d\u9700\u8981\u5148\u521d\u59cb\u5316\u5f15\u64ce";
                break;
            }
            case 1001000: {
                enInfo = "App ID cannot be 0, please check if app ID is correct";
                cnInfo = "app ID\u4e0d\u80fd\u4e3a0\uff0c\u8bf7\u68c0\u67e5app ID\u662f\u5426\u6b63\u786e";
                break;
            }
            case 1001001: {
                enInfo = "The length of input appsign must be 64 bytes";
                cnInfo = "AppSign\u957f\u5ea6\u5fc5\u987b\u4e3a64\u5b57\u8282";
                break;
            }
            case 1001002: {
                enInfo = "The input appsign contains illegal characters, Only '0'-'9','a'-'f','A'-'F' are valid";
                cnInfo = "\u8f93\u5165AppSign\u5305\u542b\u975e\u6cd5\u5b57\u7b26, \u4ec5\u652f\u6301'0'-'9','a'-'f','A'-'F'";
                break;
            }
            case 1001003: {
                enInfo = "Input appsign is empty";
                cnInfo = "\u8f93\u5165AppSign\u4e3a\u7a7a";
                break;
            }
            default: {
                ZegoExpressEngineJni.printDebugInfoJni(level.value(), module, funcName, errorCode, args);
                return;
            }
        }
        switch (language) {
            case ENGLISH: {
                msg = " Kind reminder\uff1aFailed to call function: " + funcName + "\n\rError Code:" + errorCode + "\n\rError Info\uff1a" + enInfo + "\n\r\n\rYou can see in the debug console for more details.";
                break;
            }
            case CHINESE: {
                msg = " \u6e29\u99a8\u63d0\u9192\uff1a\u8c03\u7528" + funcName + "\u63a5\u53e3\u5931\u8d25\u3002\n\r\u9519\u8bef\u7801:" + errorCode + "\n\r\u9519\u8bef\u4fe1\u606f\uff1a" + cnInfo + "\n\r\n\r\u53ef\u4ee5\u5728\u8c03\u8bd5\u4fe1\u606f\u63a7\u5236\u53f0\u4e2d\u67e5\u770b\u66f4\u591a\u4fe1\u606f\u3002";
            }
        }
        if (!msg.equals("")) {
            Log.e((String)("[ZEGO][ERROR][COMMON]" + funcName), (String)msg);
            ZegoExpressEngineJni.showToastMsg(msg);
        }
    }

    public static void logInfo(String fileName, String funcName, int line, ZegoDebugLevel level, ZegoDebugLayer layer, int module, String format, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            return;
        }
        ZegoExpressEngineJni.logInfoJni(fileName, funcName, line, level.value(), layer.value(), module, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRoomStreamUpdate(final String roomID, final int updateType, ZegoStream[] streamList) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 2, "onRoomStreamUpdate", 0, new Object[0]);
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<ZegoStream>();
        for (int i = 0; i < streamList.length; ++i) {
            streamArrayList.add(streamList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onRoomStreamUpdate(roomID, ZegoUpdateType.values()[updateType], streamArrayList);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRoomStateUpdate(final String roomID, final int state, final int errorCode) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onRoomStateUpdate(roomID, ZegoRoomState.values()[state], errorCode);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onStreamExtraInfoUpdate(ZegoStream[] streamList, int streamInfoCount, String roomID) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 2, "onStreamExtraInfoUpdate", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRoomUserUpdate(final String roomID, final int updateType, ZegoUser[] userList) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 2, "onRoomUserUpdate", 0, new Object[0]);
        final ArrayList<ZegoUser> userArrayList = new ArrayList<ZegoUser>();
        for (int i = 0; i < userList.length; ++i) {
            userArrayList.add(userList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onRoomUserUpdate(roomID, ZegoUpdateType.values()[updateType], userArrayList);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherStateUpdate(final String streamID, final int state, final int errorCode) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 3, "onPublisherStateUpdate", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPublisherStateUpdate(streamID, ZegoPublisherState.values()[state], errorCode);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherUpdateCDNURLResult(final String streamID, final int errorCode, final int seq) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoPublisherUpdateCDNURLCallback handler = (IZegoPublisherUpdateCDNURLCallback)sPublisherUpdateCDNURLHandler.get(seq);
                        if (handler != null) {
                            handler.onPublisherUpdateCDNURLResult(streamID, errorCode);
                            sPublisherUpdateCDNURLHandler.remove(seq);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerRecvSEI(final String streamID, final ByteBuffer data, final int dataLength) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPlayerRecvSEI(streamID, data, dataLength);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherUpdateStreamExtraInfoResult(final int errorCode, final int seq) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoPublisherSetStreamExtraInfoCallback handler = (IZegoPublisherSetStreamExtraInfoCallback)sPublisherUpdateStreamExtraInfoHandler.get(seq);
                        if (handler != null) {
                            handler.onPublisherSetStreamExtraInfoResult(errorCode);
                            sPublisherUpdateStreamExtraInfoHandler.remove(seq);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherQualityUpdate(final String streamID, final ZegoPublishStreamQuality quality) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPublisherQualityUpdate(streamID, quality);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherMediaEvent(int media_event, int reason, String streamID) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 3, "onPublisherMediaEvent", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherRecvAudioFirstFrame() {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 3, "onPublisherRecvAudioFirstFrame", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPublisherRecvFirstFrameEvent(ZegoPublisherFirstFrameEvent.AUDIO_CAPTURED);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherRecvVideoFirstFrame() {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 3, "onPublisherRecvVideoFirstFrame", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPublisherRecvFirstFrameEvent(ZegoPublisherFirstFrameEvent.VIDEO_CAPTURED);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherVideoSizeChanged(final int width, final int height) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 3, "onPublisherVideoSizeChanged", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPublisherVideoSizeChanged(width, height);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPublisherRelayCDNStateUpdate(final String streamID, ZegoStreamRelayCDNInfo[] infoList) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; ++i) {
            infoArrayList.add(infoList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPublisherRelayCDNStateUpdate(streamID, infoArrayList);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerStateUpdate(final String streamID, final int state, final int errorCode) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 4, "onPlayerStateUpdate", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPlayerStateUpdate(streamID, ZegoPlayerState.values()[state], errorCode);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerQualityUpdate(final String streamID, final ZegoPlayStreamQuality quality) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPlayerQualityUpdate(streamID, quality);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerMediaEvent(final String streamID, final int mediaEvent) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 4, "onPlayerMediaEvent", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPlayerMediaEvent(streamID, ZegoPlayerMediaEvent.values()[mediaEvent]);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerRecvAudioFirstFrame(final String streamID) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 4, "onPlayerRecvAudioFirstFrame", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPlayerRecvFirstFrameEvent(streamID, ZegoPlayerFirstFrameEvent.AUDIO_RCV);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerRecvVideoFirstFrame(final String streamID) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 4, "onPlayerRecvVideoFirstFrame", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPlayerRecvFirstFrameEvent(streamID, ZegoPlayerFirstFrameEvent.VIDEO_RCV);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerRenderVideoFirstFrame(final String streamID) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 4, "onPlayerRenderVideoFirstFrame", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPlayerRecvFirstFrameEvent(streamID, ZegoPlayerFirstFrameEvent.VIDEO_RENDER);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerVideoSizeChanged(final String streamID, final int width, final int height) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 4, "onPlayerVideoSizeChanged", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onPlayerVideoSizeChanged(streamID, width, height);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRoomStreamExtraInfoUpdate(final String roomID, ZegoStream[] streamList) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 2, "onRoomStreamExtraInfoUpdate", 0, new Object[0]);
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<ZegoStream>();
        for (int i = 0; i < streamList.length; ++i) {
            streamArrayList.add(streamList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onRoomStreamExtraInfoUpdate(roomID, streamArrayList);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMRecvBroadcastMessage(final String roomID, ZegoMessageInfo[] messageList) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 9, "onIMRecvBroadcastMessage", 0, new Object[0]);
        final ArrayList<ZegoMessageInfo> messageArrayList = new ArrayList<ZegoMessageInfo>();
        for (int i = 0; i < messageList.length; ++i) {
            messageArrayList.add(messageList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onIMRecvBroadcastMessage(roomID, messageArrayList);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMRecvCustomCommand(final String roomID, final ZegoUser fromUser, final String command) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 9, "onIMRecvCustomCommand", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onIMRecvCustomCommand(roomID, fromUser, command);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMSendBroadcastMessageResult(String roomID, final int errorCode, final int seq) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoIMSendBroadcastMessageCallback callback = (IZegoIMSendBroadcastMessageCallback)sIMSendBoradcastMssageHandler.get(seq);
                        if (callback != null) {
                            callback.onIMSendBroadcastMessageResult(errorCode);
                        }
                        sIMSendBoradcastMssageHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onIMSendCustomCommandResult(String roomID, final int errorCode, final int seq) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoIMSendCustomCommandCallback callback = (IZegoIMSendCustomCommandCallback)sIMSendCustomCommandHandler.get(seq);
                        if (callback != null) {
                            callback.onIMSendCustomCommandResult(errorCode);
                        }
                        sIMSendCustomCommandHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRemoteCameraStateUpdate(final String streamID, final int state) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onRemoteCameraStateUpdate(streamID, ZegoRemoteDeviceState.values()[state]);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onRemoteMICStateUpdate(final String streamID, final int state) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onRemoteMicStateUpdate(streamID, ZegoRemoteDeviceState.values()[state]);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onDeviceError(final int errorCode, final String deviceName) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 6, "onDeviceError", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onDeviceError(errorCode, deviceName);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerSoundLevelUpdate(final HashMap<String, Double> soundLevelHashMap) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 6, "onPlayerSoundLevelUpdate", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onRemoteSoundLevelUpdate(soundLevelHashMap);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onCapturedSoundLevelUpdate(final double soundLevel) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 6, "onCapturedSoundLevelUpdate", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onCapturedSoundLevelUpdate(soundLevel);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onCapturedFrequencySpectrumUpdate(final double[] frequencySpectrum) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 6, "onCapturedFrequencySpectrumUpdate", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onCapturedAudioSpectrumUpdate(frequencySpectrum);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onPlayerFrequencySpectrumUpdate(final HashMap<String, double[]> frequencySpectrums) {
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, 6, "onPlayerFrequencySpectrumUpdate", 0, new Object[0]);
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onRemoteAudioSpectrumUpdate(frequencySpectrums);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMixerStartResult(final String taskID, final int seq, final int errorCode) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        ZegoMixerStartResult result = new ZegoMixerStartResult();
                        result.errorCode = errorCode;
                        IZegoMixerStartCallback callback = (IZegoMixerStartCallback)sMixerStartResultHandler.get(seq);
                        if (callback != null) {
                            callback.onMixerStartResult(taskID, result);
                        }
                        sMixerStartResultHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMixerStopResult(final String taskID, final int seq, final int errorCode) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoMixerStopCallback callback = (IZegoMixerStopCallback)sMixerStopResultHandler.get(seq);
                        if (callback != null) {
                            callback.onMixerStopResult(taskID, errorCode);
                        }
                        sMixerStopResultHandler.remove(seq);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMixerRelayCDNStateUpdate(ZegoStreamRelayCDNInfo[] infoList, final String taskID) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; ++i) {
            infoArrayList.add(infoList[i]);
        }
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onMixerRelayCDNStateUpdate(infoArrayList, taskID);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public static void onExternalVideoRenderCapturedFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, int rotation, int videoFlipMode) {
        if (mExternalRenderer != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            zegoVideoFrameParam.strides = strides;
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            zegoVideoFrameParam.rotation = rotation;
            mExternalRenderer.onCapturedVideoFrameRawData(buffers, dataLen, zegoVideoFrameParam, ZegoVideoFlipMode.values()[videoFlipMode]);
        }
    }

    public static void onExternalVideoRenderRemoteFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, String streamID) {
        if (mExternalRenderer != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            zegoVideoFrameParam.strides = strides;
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            mExternalRenderer.onRemoteVideoFrameRawData(buffers, dataLen, zegoVideoFrameParam, streamID);
        }
    }

    public static void showToastMsg(String msg) {
        if (!mIsTestEnv) {
            return;
        }
        if (context != null) {
            try {
                Toast.makeText((Context)context, (CharSequence)msg, (int)1).show();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onDebugError(final int errorCode, final String funcName, final String info) {
        Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            mUIHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ZegoExpressEngineJni> clazz = ZegoExpressEngineJni.class;
                    synchronized (ZegoExpressEngineJni.class) {
                        String msg;
                        if (errorCode == 0) {
                            if (!isNoErrorCallback) {
                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                return;
                            }
                            msg = "\u8c03\u7528" + funcName + "\u63a5\u53e3\u6210\u529f";
                            ZegoExpressEngineJni.showToastMsg(msg);
                        } else {
                            switch (language) {
                                default: {
                                    msg = " Kind reminder\uff1aFailed to call function: " + funcName + "\n\rError Code:" + errorCode + "\n\rError Info\uff1a" + info + "\n\r\n\rYou can see in the debug console for more details.";
                                    break;
                                }
                                case CHINESE: {
                                    msg = " \u6e29\u99a8\u63d0\u9192\uff1a\u8c03\u7528" + funcName + "\u63a5\u53e3\u5931\u8d25\u3002\n\r\u9519\u8bef\u7801:" + errorCode + "\n\r\u9519\u8bef\u4fe1\u606f\uff1a" + info + "\n\r\n\r\u53ef\u4ee5\u5728\u8c03\u8bd5\u4fe1\u606f\u63a7\u5236\u53f0\u4e2d\u67e5\u770b\u66f4\u591a\u4fe1\u606f\u3002";
                                }
                            }
                            ZegoExpressEngineJni.showToastMsg(msg);
                        }
                        if (sEventHandlerList == null) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        for (int i = 0; i < sEventHandlerList.size(); ++i) {
                            ((IZegoEventHandler)sEventHandlerList.get(i)).onDebugError(errorCode, funcName, info);
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void enableNoErrorCallback(boolean enable) {
        isNoErrorCallback = enable;
    }

    public static native void printDebugInfoJni(int var0, int var1, String var2, int var3, Object ... var4);

    public static native void logInfoJni(String var0, String var1, int var2, int var3, int var4, int var5, String var6, Object ... var7);

    public static native int setTestCase(int var0, int var1, String var2, boolean var3);

    public static native int triggerCallback();

    public static native int setAudioConfigJni(ZegoAudioConfig var0);

    static {
        engine = null;
        mIsTestEnv = true;
        language = ZegoLanguage.ENGLISH;
        sEventHandlerList = new ArrayList();
        sPublisherUpdateCDNURLHandler = new HashMap();
        sPublisherUpdateStreamExtraInfoHandler = new HashMap();
        sMixerStartResultHandler = new HashMap();
        sMixerStopResultHandler = new HashMap();
        sIMSendBoradcastMssageHandler = new HashMap();
        sIMSendCustomCommandHandler = new HashMap();
        isNoErrorCallback = false;
        try {
            System.loadLibrary("ZegoExpressEngine");
            hasSoLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            hasSoLoaded = false;
        }
    }

    public static final class ZegoInnerModule {
        public static final int MODULE_COMMON = 0;
        public static final int MODULE_ENGINE = 1;
        public static final int MODULE_ROOM = 2;
        public static final int MODULE_PUBLISHER = 3;
        public static final int MODULE_PLAYER = 4;
        public static final int MODULE_MIXER = 5;
        public static final int MODULE_DEVICE = 6;
        public static final int MODULE_PREPROCESS = 7;
        public static final int MODULE_MEDIAPLAYER = 8;
        public static final int MODULE_IM = 9;
        public static final int MODULE_RECODER = 10;
        public static final int MODULE_EXTERNAL_IO = 11;
    }
}

