package im.zego.zegoexpress.module.mediaplayer;

import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.module.mediaplayer.callback.IZegoMediaplayerAudioHandler;
import im.zego.zegoexpress.module.mediaplayer.callback.IZegoMediaplayerEventHandler;
import im.zego.zegoexpress.module.mediaplayer.callback.IZegoMediaplayerVideoHandler;
import im.zego.zegoexpress.module.mediaplayer.callback.ZegoMediaplayerLoadResourceCallback;
import im.zego.zegoexpress.module.mediaplayer.callback.ZegoMediaplayerSeekToCallback;
import im.zego.zegoexpress.module.mediaplayer.entity.ZegoMediaplayerState;

public final class ZegoMediaplayer {

    private ZegoMediaplayer(){}

    static ZegoMediaplayer createMediaplayer(){
        return new ZegoMediaplayer();
    }

    public void destroyMediaplayer(){
        ZegoMediaplayerJni.destroyMediaplayer(this);
    }

    // 设置事件回调handler
    public void setEventHandler(IZegoMediaplayerEventHandler handler){
        ZegoMediaplayerJni.setEventHandler(this, handler);
    }

    // 设置视频回调handler
    public void setVideoHandler(IZegoMediaplayerVideoHandler handler, ZegoVideoFrameFormat frameFormat){
        ZegoMediaplayerJni.setVideoHandler(this, frameFormat, handler);
    }

    // 设置音频回调handler
    public void setAudioHandler(IZegoMediaplayerAudioHandler handler){
        ZegoMediaplayerJni.setAudioHandler(this, handler);
    }

    // 加载资源
    public void loadResource(String path, ZegoMediaplayerLoadResourceCallback callback){
        ZegoMediaplayerJni.loadResource(this, path, callback);
    }

    // 开始播放（播放前需要先加载资源）
    public void start(){
        ZegoMediaplayerJni.start(this);
    }

    // 停止播放
    public void stop(){
        ZegoMediaplayerJni.stop(this);
    }

    // 暂停播放
    public void pause(){
        ZegoMediaplayerJni.pause(this);
    }

    // 恢复播放
    public void resume(){
        ZegoMediaplayerJni.resume(this);
    }

    // 设置指定播放进度
    public void seekTo(long millisecond, ZegoMediaplayerSeekToCallback callback ){
        ZegoMediaplayerJni.seekTo(this, millisecond, callback);
    }

    // 设置是否重复播放
    public void enableRepeat(boolean enable){
        ZegoMediaplayerJni.enableRepeat(this, enable);
    }

    // 设置是否将声音混入正在推的流中
    public void enableAux(boolean enable){
        ZegoMediaplayerJni.enableAux(this, enable);
    }

    // 是否本地静默播放（若开启了混音入流则推的流中仍然有声音）
    public void muteLocal(boolean mute){
        ZegoMediaplayerJni.muteLocal(this, mute);
    }

    // 设置播放器视图
    public void setPlayerCanvas(ZegoCanvas canvas){
        ZegoMediaplayerJni.setPlayerCanvas(this, canvas);
    }

    // 设置当前音量，0~100
    public void setVolume(int volume){
        ZegoMediaplayerJni.setVolume(this, volume);
    }

    // 获取当前音量，0~100
    public int getVolume(){
        return ZegoMediaplayerJni.getVolume(this);
    }

    // 设置播放进度回调间隔
    public void setProgressInterval(long millisecond){
        ZegoMediaplayerJni.setProgressInterval(this, millisecond);
    }

    public long getTotalDuration() {
        return ZegoMediaplayerJni.getTotalDuration(this);
    }

    public long getCurrentProgress() {
        return ZegoMediaplayerJni.getCurrentProgress(this);
    }

    // 获取当前播放器状态
    public ZegoMediaplayerState getCurrentState(){
        return ZegoMediaplayerJni.getCurrentState(this);
    }

}
