package im.zego.zegoexpress.entity;

import android.graphics.SurfaceTexture;

import java.nio.ByteBuffer;

import im.zego.zegoexpress.constants.ZegoViewMode;

public class ZegoVideoFrameSender {

    public ZegoVideoFrameSender(){}



    public void setFillMode(ZegoViewMode mode){
        this.setFillModeeJni(mode.value());
    }

    native private int setFillModeeJni(int mode);



    public void sendRawData(ByteBuffer data, int dataLen, ZegoVideoFrameParam param, long millisecond){
        this.sendRawDataJni(data, dataLen, param.format.value(), param.strides, param.width, param.height, param.rotation, millisecond);
    }

    private native int sendRawDataJni(ByteBuffer data, int dataLen, int format, int[] strides, int width, int height, int rotation, long referenceTime);



    public void sendTextureData(int textureID, int width, int height, double referenceTimeMillisecond){
        this.sendTextureDataJni(textureID, width, height, referenceTimeMillisecond);
    }

    native private int sendTextureDataJni(int textureID, int width, int height, double referenceTimeMillisecond);



    public SurfaceTexture getSurfaceTexture(){
       return this.getSurfaceTextureJni();
    }

    native private SurfaceTexture getSurfaceTextureJni();
    
}
