package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.ZegoResolution;
public class ZegoVideoConfig {
    /** 采集分辨率宽度
     */
    private int captureWidth;

    /** 采集分辨率高度
     */
    private int captureHeight;

    /** 编码分辨率宽度
     */
    private int encodeWidth;

    /** 编码分辨率高度
     */
    private int encodeHeight;

    /** 码率，单位为 bps
     */
    private int bitrate;

    /** 帧率
     */
    private int fps;

    /** 
     */
    public ZegoVideoConfig() {
        this(ZegoResolution.RESOLUTION_360x640);
    }

    /** 
     */
    public ZegoVideoConfig(ZegoResolution resolution) {
        switch (resolution) {
            case RESOLUTION_180x320:
                this.captureWidth = 180;
                this.captureHeight = 320;
                this.encodeWidth = 180;
                this.encodeHeight = 320;
                this.bitrate = 140000;
                this.fps = 15;
                break;
            case RESOLUTION_270x480:
                this.captureWidth = 270;
                this.captureHeight = 480;
                this.encodeWidth = 270;
                this.encodeHeight = 480;
                this.bitrate = 280000;
                this.fps = 15;
                break;
            case RESOLUTION_360x640:
                this.captureWidth = 360;
                this.captureHeight = 640;
                this.encodeWidth = 360;
                this.encodeHeight = 640;
                this.bitrate = 400000;
                this.fps = 15;
                break;
            case RESOLUTION_540x960:
                this.captureWidth = 540;
                this.captureHeight = 960;
                this.encodeWidth = 540;
                this.encodeHeight = 960;
                this.bitrate = 780000;
                this.fps = 15;
                break;
            case RESOLUTION_720x1280:
                this.captureWidth = 720;
                this.captureHeight = 1280;
                this.encodeWidth = 720;
                this.encodeHeight = 1480;
                this.bitrate = 1400000;
                this.fps = 15;
                break;
            case RESOLUTION_1080x1920:
                this.captureWidth = 1080;
                this.captureHeight = 1920;
                this.encodeWidth = 1080;
                this.encodeHeight = 1920;
                this.bitrate = 2600000;
                this.fps = 15;
                break;
        }
    }

    /** 
     */
    public void setCaptureResolution(int width, int height) {
        this.captureWidth = width;
        this.captureHeight = height;
    }

    /** 
     */
    public void setEncodeResolution(int width, int height) {
        this.encodeWidth = width;
        this.encodeHeight = height;
    }

    /** 
     */
    public void setVideoBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    /** 
     */
    public void setVideoFPS(int fps) {
        this.fps = fps;
    }

}
