package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.ZegoResolution;

public class ZegoMixerVideoConfig {
    /** 通过预设枚举值创建视频配置
     */
    public ZegoMixerVideoConfig(ZegoResolution resolution) {
        switch (resolution) {
            case RESOLUTION_180x320:
                this.resolutionWidth = 180;
                this.resolutionHeight = 320;
                this.bitrate = 140000;
                this.fps = 15;
                break;
            case RESOLUTION_270x480:
                this.resolutionWidth = 270;
                this.resolutionHeight = 480;
                this.bitrate = 280000;
                this.fps = 15;
                break;
            case RESOLUTION_360x640:
                this.resolutionWidth = 360;
                this.resolutionHeight = 640;
                this.bitrate = 400000;
                this.fps = 15;
                break;
            case RESOLUTION_540x960:
                this.resolutionWidth = 540;
                this.resolutionHeight = 960;
                this.bitrate = 780000;
                this.fps = 15;
                break;
            case RESOLUTION_720x1280:
                this.resolutionWidth = 720;
                this.resolutionHeight = 1280;
                this.bitrate = 1400000;
                this.fps = 15;
                break;
            case RESOLUTION_1080x1920:
                this.resolutionWidth = 1080;
                this.resolutionHeight = 1920;
                this.bitrate = 2600000;
                this.fps = 15;
                break;
        }
    }

    /** 创建默认混流视频配置，RESOLUTION_360x640
     */
    public ZegoMixerVideoConfig() {
        this(ZegoResolution.RESOLUTION_360x640);
    }

    /** 视频码率
     */
    public int bitrate;

    /** 视频帧率，开始混流任务后不能修改
     */
    public int fps;

    /** 视频分辨率宽
     */
    public int resolutionWidth;

    /** 视频分辨率高
     */
    public int resolutionHeight;

}
