package im.zego.zegoexpress.entity;

import java.util.ArrayList;
public class ZegoMixerTask {
    /** 通过 TaskID 构造一个混流任务对象
     */
    public ZegoMixerTask(String taskID) {
        this.taskID = taskID;
        inputList = new ArrayList<>();
        outputList = new ArrayList<>();
        audioConfig = new ZegoMixerAudioConfig();
        videoConfig = new ZegoMixerVideoConfig();
        backgroundImageURL = "";
    }

    /** 
     */
    private String taskID;

    /** 
     */
    private ZegoMixerAudioConfig audioConfig;

    /** 
     */
    private ZegoMixerVideoConfig videoConfig;

    /** 
     */
    private ArrayList<ZegoMixerInput> inputList;

    /** 
     */
    private ArrayList<ZegoMixerOutput> outputList;

    /** 
     */
    private ZegoWatermark watermark;

    /** 
     */
    private String backgroundImageURL;

    /** 获取混流任务ID
     */
    public String getTaskID() {
        return taskID;
    }

    /** 设置混流任务对象的输入流列表
     */
    public void setInputList(ArrayList<ZegoMixerInput> inputList) {
        this.inputList.addAll(inputList);
    }

    /** 设置混流任务对象的输出列表
     */
    public void setOutputList(ArrayList<ZegoMixerOutput> outputList) {
        this.outputList.addAll(outputList);
    }


    /** 设置混流任务对象的音频配置
     */
    public void setAudioConfig(ZegoMixerAudioConfig config) {
        this.audioConfig = config;
    }

    /** 设置混流任务对象的视频配置
     */
    public void setVideoConfig(ZegoMixerVideoConfig config) {
        this.videoConfig = config;
    }

    /** 设置混流任务对象的背景图片
     */
    public void setBackgroundImageURL(String backgroundImageURL) {
        this.backgroundImageURL = backgroundImageURL;
    }

    /** 设置混流任务对象的水印
     */
    public void setWatermark(ZegoWatermark watermark) {
        this.watermark = watermark;
    }

}
