package im.zego.zegoexpress.entity;

import java.util.HashMap;

public class ZegoEngineConfig {

    /**
     * Zego Express SDK 的so动态库路径, 有需要动态加载so的开发者使用, 默认为空字符串使用工程打包的so
     */
    public String soFullPath;

    /**
     * 以默认的方式创建初始化配置的对象
     *
     * @see im.zego.zegoexpress.ZegoExpressEngine#setEngineConfig(ZegoEngineConfig)
     */
    public ZegoEngineConfig() {
        logConfig = new ZegoLogConfig();
        soFullPath = "";
    }

    /**
     * 设置 ZEGO Express Engine 日志相关配置
     */
    public ZegoLogConfig logConfig = null;

    /**
     * 设置外部渲染配置，不设或传空则不开启外部渲染，默认不开启
     */
    public ZegoExternalVideoRenderConfig externalVideoRenderConfig = null;

    /**
     * 设置外部采集配置，不设或传空则不开启外部采集，默认不开启
     */
    public ZegoExternalVideoCaptureConfig externalVideoCaptureConfig = null;

    /**
     * 高级功能设置, 没有特殊需求的开发者无须关注
     */
    public HashMap<String, String> advancedConfig = null;

}
