package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.ZegoViewMode;
public class ZegoCanvas {
    /** View 对象
     */
    public Object view;

    /** 视图模式，默认为 ASPECT_FIT
     */
    public ZegoViewMode viewMode;

    /** 背景颜色，格式为 0xRRGGBB，默认为黑色即 0x000000
     */
    public int backgroundColor;

    /** 创建视图，viewMode 默认为 ZegoViewMode.ASPECT_FIT，背景色默认为黑色
     */
    public ZegoCanvas(Object view) {
        this.view = view;
        this.viewMode = ZegoViewMode.ASPECT_FIT;
        this.backgroundColor = 0x000000;
    }

}
