package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.ZegoAudioConfigPreset;
public class ZegoAudioConfig {
    /** 码率
     */
    public int bitrate;

    /** 声道数
     */
    public int channels;

    /** 编码 ID
     */
    public int codecID;

    /** 创建默认音频配置(ZegoAudioConfigPreset.LOW_LATENCY_STANDARD_QUALITY)
     */
            public ZegoAudioConfig() {
            this(ZegoAudioConfigPreset.LOW_LATENCY_STANDARD_QUALITY);
        }

    /** 通过预设枚举值创建音频配置
     */
            public ZegoAudioConfig(ZegoAudioConfigPreset presetType){
            switch (presetType) {
                case LOW_LATENCY_BASIC_QUALITY:
                    bitrate = 16 * 1000;
                    channels = 1;
                    codecID = 5;
                    break;
                case LOW_LATENCY_STANDARD_QUALITY:
                    bitrate = 48 * 1000;
                    channels = 1;
                    codecID = 5;
                    break;
                case LOW_LATENCY_STANDARD_QUALITY_STEREO:
                    bitrate = 56 * 1000;
                    channels = 2;
                    codecID = 5;
                    break;
                case LOW_LATENCY_HIGH_QUALITY:
                    bitrate = 128 * 1000;
                    channels = 1;
                    codecID = 5;
                    break;
                case LOW_LATENCY_HIGH_QUALITY_STEREO:
                    bitrate = 192 * 1000;
                    channels = 2;
                    codecID = 5;
                    break;
                case NORMAL_LATENCY_STANDARD_QUALITY:
                    bitrate = 48 * 1000;
                    channels = 1;
                    codecID = 0;
                    break;
                case NORMAL_LATENCY_STANDARD_QUALITY_STEREO:
                    bitrate = 56 * 1000;
                    channels = 2;
                    codecID = 0;
                    break;
                case NORMAL_LATENCY_HIGH_QUALITY:
                    bitrate = 128 * 1000;
                    channels = 1;
                    codecID = 1;
                    break;
                case NORMAL_LATENCY_HIGH_QUALITY_STEREO:
                    bitrate = 192 * 1000;
                    channels = 2;
                    codecID = 1;
                    break;
            }
        }

}
