package im.zego.zegoexpress.constants;

public enum ZegoVideoMirrorMode {
    /** 只有本地预览时才是镜像画面，默认采用此模式
     */
    ONLY_PREVIEW_MIRROR(0),
    /** 本地预览和拉流端看到的视频都是镜像画面
     */
    BOTH_MIRROR(1),
    /** 本地预览和拉流端看到的视频都不是镜像画面
     */
    NO_MIRROR(2),
    /** 只有拉流端看到的视频才是镜像画面
     */
    ONLY_PUBLISH_MIRROR(3);

    private int value;

    private ZegoVideoMirrorMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
