package im.zego.zegoexpress.constants;

public enum ZegoVideoFrameFormat {
    /** 未知格式，将取平台默认值
     */
    UNKNOWN(0),
    /** I420 (YUV420Planar) 格式
     */
    I420(1),
    /** NV12 (YUV420SemiPlanar) 格式
     */
    NV12(2),
    /** NV21 (YUV420SemiPlanar) 格式
     */
    NV21(3),
    /** BGRA32 格式
     */
    BGRA32(4),
    /** RGBA32 格式
     */
    RGBA32(5),
    /** ARGB32 格式
     */
    ARGB32(6),
    /** ABGR32 格式
     */
    ABGR32(7),
    /** I422 (YUV422Planar) 格式
     */
    I422(8);

    private int value;

    private ZegoVideoFrameFormat(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
