package im.zego.zegoexpress.constants;

public enum ZegoVideoBufferType {

    /**
     * 未知类型
     */
    UNKNOWN(0),
    /**
     * 内存类型，YUV格式
     */
    RAW_DATA(1),
    /**
     * OpenGL ES的2d贴图类型
     */
    GL_TEXTURE_2D(3),
    /**
     * SurfaceTexture 类型
     */
    SURFACE_TEXTURE(5);

    private int value;

    private ZegoVideoBufferType(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

}
