package im.zego.zegoexpress.constants;

public enum ZegoStreamRelayCDNState {
    /** 未转推状态，在转推前处于该状态。如果转推过程出现稳态的异常，例如 转推地址 不正确，都会进入未转推状态
     */
    STOP(0),
    /** 正在转推状态，进入该状态表明转推已成功
     */
    START(1),
    /** 正在请求转推状态，转推操作执行成功后会进入正在请求转推状态，通常通过该状态进行应用界面的展示。如果因为网络质量不佳产生的中断，SDK 会进行内部重试，也会回到正在转推状态
     */
    RETRY(2);

    private int value;

    private ZegoStreamRelayCDNState(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
