package im.zego.zegoexpress.constants;

public enum ZegoRoomState {
    /** 未连接状态，在登陆房间前和退出房间之后进入该状态。如果登陆房间的过程出现稳态异常，例如 AppID 和 AppSign 不正确，或者有相同用户名在其他地方登陆导致本端被 KickOut，都会进入该状态
     */
    DISCONNECTED(0),
    /** 正在请求连接状态，登陆房间动作执行成功后会进入此状态。通常通过该状态进行应用界面的展示。如果因为网络质量不佳产生的中断， SDK 会进行内部重试，也会回到正在请求连接状态
     */
    CONNECTING(1),
    /** 连接成功状态，进入该状态表示登陆房间已经成功，用户可以正常收到房间内的用户和流信息增删的回调通知
     */
    CONNECTED(2);

    private int value;

    private ZegoRoomState(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
