package im.zego.zegoexpress.constants;

public enum ZegoResolution {
    /** 设置分辨率为 180x320，默认采用 15 fps，码率 300000 bps
     */
    RESOLUTION_180x320(0),
    /** 设置分辨率为 270x480，默认采用 15 fps，码率 400000 bps
     */
    RESOLUTION_270x480(1),
    /** 设置分辨率为 360x640，默认采用 15 fps，码率 600000 bps
     */
    RESOLUTION_360x640(2),
    /** 设置分辨率为 540x960，默认采用 15 fps，码率 1200000 bps
     */
    RESOLUTION_540x960(3),
    /** 设置分辨率为 720x1280，默认采用 15 fps，码率 1500000 bps
     */
    RESOLUTION_720x1280(4),
    /** 设置分辨率为 1080x1920，默认采用 15 fps，码率 3000000 bps
     */
    RESOLUTION_1080x1920(5);

    private int value;

    private ZegoResolution(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
