package im.zego.zegoexpress.constants;

public enum ZegoRemoteDeviceState {
    /** 设备开启
     */
    OPEN(0),
    /** 设备关闭：一般性设备错误
     */
    GENERIC_ERROR(1),
    /** 设备关闭：无效的设备 ID 
     */
    INVALID_ID(2),
    /** 设备关闭：无权限
     */
    NO_AUTHORIZATION(3),
    /** 设备关闭：采集帧率为 0
     */
    ZERO_FPS(4),
    /** 设备关闭：设备被占用
     */
    IN_USE_BY_OTHER(5),
    /** 设备关闭：设备未插入或被拔出
     */
    UNPLUGGED(6),
    /** 设备关闭：由于系统原因需要重启后才能进行下一次修改，否则重新打开也不生效
     */
    REBOOT_REQUIRED(7),
    /** 设备关闭：系统媒体服务停止，如 iOS 平台下，当系统检测到当前压力巨大（如播放大量动画），则有可能会将媒体相关服务全部停用
     */
    SYSTEM_MEDIA_SERVICES_LOST(8),
    /** 设备关闭：禁用采集
     */
    DISABLE(9),
    /** 设备关闭：远端设备被静音
     */
    MUTE(10),
    /** 设备关闭：设备被中断，如电话事件打断等
     */
    INTERRUPTION(11),
    /** 设备关闭：用户app退到后台
     */
    IN_BACKGROUND(12),
    /** 设备关闭：当前前台同时存在多个 App，如 iPad 应用分屏下，系统会禁止所有应用使用摄像头
     */
    MULTI_FOREGROUND_APP(13),
    /** 设备关闭：系统处于高负载压力下，可能导致设备异常
     */
    BY_SYSTEM_PRESSURE(14);

    private int value;

    private ZegoRemoteDeviceState(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
