package im.zego.zegoexpress.constants;

public enum ZegoPublisherState {
    /** 未推流状态，在推流前处于该状态。如果推流过程出现稳态的异常，例如 AppID 和 AppSign 不正确，或者如果其他用户已经在推送流，推送相同流ID的流会失败，都会进入未推流状态
     */
    NO_PUBLISH(0),
    /** 正在请求推流状态，推流操作执行成功后会进入正在请求推流状态，通常通过该状态进行应用界面的展示。如果因为网络质量不佳产生的中断，SDK 会进行内部重试，也会回到正在请求推流状态
     */
    PUBLISH_REQUESTING(1),
    /** 正在推流状态，进入该状态表明推流已经成功，用户可以正常通信
     */
    PUBLISHING(2);

    private int value;

    private ZegoPublisherState(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
