package im.zego.zegoexpress.constants;

public enum ZegoPlayerState {
    /** 未拉流状态，在拉流前处于该状态。如果拉流过程出现稳态的异常，例如 AppID 和 AppSign 不正确，都会进入未拉流状态
     */
    NO_PLAY(0),
    /** 正在请求拉流状态，拉流操作执行成功后会进入正在请求拉流状态，通常通过该状态进行应用界面的展示。如果因为网络质量不佳产生的中断，SDK 会进行内部重试，也会回到正在请求拉流状态
     */
    PLAY_REQUESTING(1),
    /** 正在拉流状态，进入该状态表明拉流已经成功，用户可以正常通信
     */
    PLAYING(2);

    private int value;

    private ZegoPlayerState(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
