package im.zego.zegoexpress.constants;

public enum ZegoAudioConfigPreset {
    /** 低延迟-基础音质
     */
    LOW_LATENCY_BASIC_QUALITY(0),
    /** 低延迟-标准音质
     */
    LOW_LATENCY_STANDARD_QUALITY(1),
    /** 低延迟-标准音质-双声道
     */
    LOW_LATENCY_STANDARD_QUALITY_STEREO(2),
    /** 低延迟-高音质
     */
    LOW_LATENCY_HIGH_QUALITY(3),
    /** 低延迟-高音质-双声道
     */
    LOW_LATENCY_HIGH_QUALITY_STEREO(4),
    /** 普通延迟-标准音质
     */
    NORMAL_LATENCY_STANDARD_QUALITY(5),
    /** 普通延迟-标准音质-双声道
     */
    NORMAL_LATENCY_STANDARD_QUALITY_STEREO(6),
    /** 普通延迟-高音质
     */
    NORMAL_LATENCY_HIGH_QUALITY(7),
    /** 普通延迟-高音质-双声道
     */
    NORMAL_LATENCY_HIGH_QUALITY_STEREO(8);

    private int value;

    private ZegoAudioConfigPreset(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }
}
