package im.zego.zegoexpress.constants;

public enum ZegoAECMode {
    /** 激进的回声抵消，可能会影响音质稍微明显，但是回声会消除得很干净
     */
    AGGRESSIVE(0),
    /** 适度的回声抵消，就是可能会稍微影响一点点音质，但是残留的回声会更少
     */
    MEDIUM(1),
    /** 舒适的回声抵消，就是回声抵消基本不会影响声音的音质，可能有时会残留一点回声，但不会影响正常听音
     */
    SOFT(2);

    private int value;

    private ZegoAECMode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

}
