package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.ZegoVideoFlipMode;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;

import java.nio.ByteBuffer;

public interface IZegoExternalVideoRenderer {

    /**
     * 回调方法，SDK 抛本地预览视频帧裸数据出来, 不带 steamID, 开发者根据抛出的数据及数据类型进行渲染
     *
     * @param data 抛出本地渲染的视频帧数据
     * @param dataLength 对应buffer的长度
     * @param param {@link ZegoVideoFrameParam} 视频帧参数
     * @param flipMode 翻转模式
     */
    void onCapturedVideoFrameRawData(ByteBuffer[] data, int[] dataLength, ZegoVideoFrameParam param, ZegoVideoFlipMode flipMode);

    /**
     * 回调方法，SDK 抛远端拉流的视频帧裸数据出来，steamID 区分不同的流, 开发者根据抛出的数据及数据类型进行渲染
     *
     * @param data 抛出远端渲染的视频帧数据
     * @param param {@link ZegoVideoFrameParam} 视频帧参数
     * @param streamID 所拉的流的流id
     */
    void onRemoteVideoFrameRawData(ByteBuffer[] data, int[] dataLength, ZegoVideoFrameParam param, String streamID);

}
