package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.entity.ZegoVideoFrameSender;

public interface IZegoExternalVideoCapturer {

    /**
     * SDK 已准备好接收用户采集的视频帧数据
     *
     * @param sender 通过调用此对象的方法以向 SDK 发送视频帧数据
     */
    void willStart(ZegoVideoFrameSender sender);

    /**
     *  SDK 停止了接收用户采集的视频帧数据
     *  在此之后 willstart 回调中的 sender 对象不可用
     */
    void willStop();
}
