package im.zego.zegoexpress.callback;


import im.zego.zegoexpress.constants.ZegoPublisherFirstFrameEvent;
import im.zego.zegoexpress.constants.ZegoPlayerFirstFrameEvent;
import im.zego.zegoexpress.constants.ZegoPlayerMediaEvent;
import im.zego.zegoexpress.constants.ZegoPlayerState;
import im.zego.zegoexpress.constants.ZegoPublisherState;
import im.zego.zegoexpress.constants.ZegoRemoteDeviceState;
import im.zego.zegoexpress.constants.ZegoRoomState;
import im.zego.zegoexpress.constants.ZegoUpdateType;
import im.zego.zegoexpress.entity.ZegoPlayStreamQuality;
import im.zego.zegoexpress.entity.ZegoPublishStreamQuality;
import im.zego.zegoexpress.entity.ZegoStream;
import im.zego.zegoexpress.entity.ZegoUser;
import im.zego.zegoexpress.entity.ZegoStreamRelayCDNInfo;
import im.zego.zegoexpress.entity.ZegoMessageInfo;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;


public abstract class IZegoEventHandler {


    /**
     * 调试错误信息回调
     * 调用 SDK 接口出现异常时，会通过该回调提示详细的异常信息，该回调受 setDebugVerbose 接口控制。
     * @param errorCode 错误码，详情请参考常用错误码文档
     * @param funcName 接口名
     * @param info 错误的详细信息
     */
    public void onDebugError(int errorCode, String funcName, String info) {

    }


    /**
     * 房间状态变化通知
     * 当房间的连接状态发生变化时将触发此回调，并告知发生变化的原因
     * @param roomID 房间 ID
     * @param state 变化后的的房间状态
     * @param errorCode 错误码，详情请参考常用错误码文档
     */
    public void onRoomStateUpdate(String roomID, ZegoRoomState state, int errorCode) {

    }


    /**
     * 房间内用户进出通知
     * 当有用户进入/退出房间时将触发此回调，并告知当前房间内存在的用户的列表；注意，只有在登录房间时传的 ZegoRoomConfig 中的 isUserStatusNotify 参数为 true 时才会触发这个回调
     * @param roomID 房间 ID
     * @param updateType 更新类型（添加/删除）
     * @param userList 当前房间内的用户列表
     */
    public void onRoomUserUpdate(String roomID, ZegoUpdateType updateType, ArrayList<ZegoUser> userList) {

    }


    /**
     * 房间内流更新通知
     * 用户首次登录房间时会接收到房间内存在的所有流列表；后续当房间内新增/删除流时将触发此回调通知变更的流列表
     * @param roomID 房间ID
     * @param updateType 更新类型（添加/删除）
     * @param streamList 更新的流列表
     */
    public void onRoomStreamUpdate(String roomID, ZegoUpdateType updateType, ArrayList<ZegoStream> streamList) {

    }


    /**
     * 房间内流附加信息更新通知
     * 当房间内有其他推流的用户更新了流的附加信息时，本端会收到该回调
     * @param roomID 房间ID
     * @param streamList 流附加信息更新的流列表
     */
    public void onRoomStreamExtraInfoUpdate(String roomID, ArrayList<ZegoStream> streamList) {

    }


    /**
     * 推流状态回调
     * 在推流成功后，可以通过该回调接口获取推流状态变更的通知。
     * @param streamID 推流的流 ID
     * @param state 推流状态
     * @param errorCode 推流状态变更对应的错误码。请参考常见错误码文档
     */
    public void onPublisherStateUpdate(String streamID, ZegoPublisherState state, int errorCode) {

    }


    /**
     * 推流质量回调
     * 推流成功后每3秒会收到此回调，通过该回调可以获取推送的音视频流的采集帧率，码率，RTT，丢包率等质量数据，实时监控推送流的健康情况。
     * @param streamID 流 ID
     * @param quality 推流质量，包含了音视频帧率、码率、分辨率，RTT等值
     */
    public void onPublisherQualityUpdate(String streamID, ZegoPublishStreamQuality quality) {

    }


    /**
     * 推流端采集首帧回调
     * 
     * 调用推流接口成功后，SDK 采集到第一帧数据时会收到此回调，包含了音频/视频的采集首帧通知。
     * @param event 推流端采集到首帧时触发的事件，包含音频采集首帧和视频采集首帧事件
     */
    public void onPublisherRecvFirstFrameEvent(ZegoPublisherFirstFrameEvent event) {

    }


    /**
     * 采集视频大小变更回调
     * 推流成功后，在推流中途如果有改变视频采集分辨率发生变化将会收到此回调。
     * @param width 视频采集分辨率宽
     * @param height 视频采集分辨率高
     */
    public void onPublisherVideoSizeChanged(int width, int height) {

    }


    /**
     * 添加/删除转推 CDN 地址状态回调
     * 在 ZEGO 实时音视频云将音视频流转推到 CDN 后，如果 CDN 转推状态发生变化，例如出现转推停止或转推重试，将会收到此回调。
     * @param streamID 流 ID
     * @param streamInfoList 当前 CDN 正在转推的信息列表
     */
    public void onPublisherRelayCDNStateUpdate(String streamID, ArrayList<ZegoStreamRelayCDNInfo> streamInfoList) {

    }


    /**
     * 拉流状态变更回调
     * 在拉流成功后，可以通过该回调接口获取拉流状态变更的通知。
     * @param streamID 流 ID
     * @param state （ \link com::zego::zegoexpress::constants::ZegoPlayerState ZegoPlayerState \endlink ）拉流状态
     * @param errorCode 错误码
     */
    public void onPlayerStateUpdate(String streamID, ZegoPlayerState state, int errorCode) {

    }


    /**
     * 拉流质量回调
     * 拉流成功后每3秒会收到此回调，通过该回调可以获取拉取的音视频流的帧率，码率，RTT，丢包率等质量数据，实时监控拉取流的健康情况。
     * @param streamID 流 ID
     * @param quality （ \link com::zego::zegoexpress::entity::ZegoPlayStreamQuality ZegoPlayStreamQuality \endlink ）拉流质量，包含了音视频帧率、码率、分辨率，RTT等值
     */
    public void onPlayerQualityUpdate(String streamID, ZegoPlayStreamQuality quality) {

    }


    /**
     * 拉流媒体事件回调
     * 当拉流发生音视频卡顿以及恢复等事件发生时会触发此回调。
     * @param streamID 流 ID
     * @param event （ \link com::zego::zegoexpress::constants::ZegoPlayerMediaEvent ZegoPlayerMediaEvent \endlink ）拉流媒体事件枚举
     */
    public void onPlayerMediaEvent(String streamID, ZegoPlayerMediaEvent event) {

    }


    /**
     * 拉流首帧回调
     * 
     * 调用推流接口成功后，当拉取到音频首帧、视频首帧以及视频首帧被渲染都会触发此回调。
     * @param streamID 流 ID
     * @param event （ \link com::zego::zegoexpress::constants::ZegoPlayerFirstFrameEvent ZegoPlayerFirstFrameEvent \endlink ）拉流端接收到首帧时触发的事件，包含音频接收首帧和视频接收首帧和视频渲染首帧事件
     */
    public void onPlayerRecvFirstFrameEvent(String streamID, ZegoPlayerFirstFrameEvent event) {

    }


    /**
     * 拉流分辨率变更通知
     * 拉流成功后，在拉流中途如果有视频分辨率发生变化将会收到此回调，用户可根据流的最终分辨率调整显示。
     * @param streamID 流 ID
     * @param width 视频分辨率宽
     * @param height 视频分辨率高
     */
    public void onPlayerVideoSizeChanged(String streamID, int width, int height) {

    }


    /**
     * 收到远端流的 SEI 内容
     * 拉流成功后，当远端流调用 sendSEI 后，本端会收到此回调
     * @param streamID 流 ID
     * @param data SEI 内容
     * @param dataLength SEI 内容长度
     */
    public void onPlayerRecvSEI(String streamID, ByteBuffer data, int dataLength) {

    }


    /**
     * 混流转推 CDN 状态更新通知
     * 
     * @param infoList 当前 CDN 正在混流的信息列表
     * @param taskID 混流任务 ID
     */
    public void onMixerRelayCDNStateUpdate(ArrayList<ZegoStreamRelayCDNInfo> infoList, String taskID) {

    }


    /**
     * 本地采集音频声浪回调
     * 
     * @param soundLevel 本地采集的声浪值，取值范围为 0.0~100.0
     */
    public void onCapturedSoundLevelUpdate(double soundLevel) {

    }


    /**
     * 远端音频声浪回调
     * 
     * @param soundLevels 远端的声浪键值对，key 为流 ID，value 为对应的流的声浪值
     */
    public void onRemoteSoundLevelUpdate(HashMap<String, Double> soundLevels) {

    }


    /**
     * 本地采集音频频谱回调
     * 
     * @param audioSpectrum 本地采集的音频频谱值数组，频谱值范围为 [0-2^30]
     *  
     */
    public void onCapturedAudioSpectrumUpdate(double[] audioSpectrum) {

    }


    /**
     * 远端拉流音频频谱回调
     * 
     * @param audioSpectrums 远端音频频谱键值对，key 是流 ID，value 为对应的流的音频频谱值数组，频谱值范围为 [0-2^30]
     *  
     */
    public void onRemoteAudioSpectrumUpdate(HashMap<String, double[]> audioSpectrums) {

    }


    /**
     * 设备异常通知
     * 当本地设备读写出现异常时会触发此回调。
     * @param errorCode 错误码
     * @param deviceName 设备名称
     */
    public void onDeviceError(int errorCode, String deviceName) {

    }


    /**
     * 远端摄像头设备状态通知
     * 远端摄像头设备状态发生变更时，例如开关摄像头等，通过监听此回调，能够获取远端摄像头相关的事件，可以用于提示用户可能导致视频异常的情况。
     * @param streamID 流 ID
     * @param state （ \link com::zego::zegoexpress::constants::ZegoRemoteDeviceState ZegoRemoteDeviceState \endlink ）远端摄像头状态
     */
    public void onRemoteCameraStateUpdate(String streamID, ZegoRemoteDeviceState state) {

    }


    /**
     * 远端麦克风设备状态通知
     * 远端麦克风设备状态发生变更时，例如开关麦克风等，通过监听此回调，能够获取远端麦克风相关的事件，可以用于提示用户可能导致音频异常的情况。
     * @param streamID 流 ID
     * @param state （ \link com::zego::zegoexpress::constants::ZegoRemoteDeviceState ZegoRemoteDeviceState \endlink ）远端麦克风状态
     */
    public void onRemoteMicStateUpdate(String streamID, ZegoRemoteDeviceState state) {

    }


    /**
     * 接收房间广播消息通知
     * 
     * @param roomID 房间 ID
     * @param messageList 收到的消息列表
     */
    public void onIMRecvBroadcastMessage(String roomID, ArrayList<ZegoMessageInfo> messageList) {

    }


    /**
     * 接收自定义信令通知
     * 
     * @param roomID 房间 ID
     * @param fromUser 信令的发送人
     * @param command 信令内容
     */
    public void onIMRecvCustomCommand(String roomID, ZegoUser fromUser, String command) {

    }


}