package im.zego.zegoexpress;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;

import im.zego.zegoexpress.callback.IZegoEventHandler;
import im.zego.zegoexpress.callback.IZegoExternalVideoCapturer;
import im.zego.zegoexpress.callback.IZegoIMSendBroadcastMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendCustomCommandCallback;
import im.zego.zegoexpress.callback.IZegoMixerStartCallback;
import im.zego.zegoexpress.callback.IZegoMixerStopCallback;
import im.zego.zegoexpress.callback.IZegoPublisherSetStreamExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoPublisherUpdateCDNURLCallback;
import im.zego.zegoexpress.callback.ZegoMixerStartResult;
import im.zego.zegoexpress.constants.ZegoAECMode;
import im.zego.zegoexpress.constants.ZegoVideoFlipMode;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAudioConfig;
import im.zego.zegoexpress.constants.ZegoCapturePipelineScaleMode;
import im.zego.zegoexpress.constants.ZegoDebugLayer;
import im.zego.zegoexpress.constants.ZegoDebugLevel;
import im.zego.zegoexpress.constants.ZegoPublisherFirstFrameEvent;
import im.zego.zegoexpress.constants.ZegoLanguage;
import im.zego.zegoexpress.constants.ZegoOrientation;
import im.zego.zegoexpress.constants.ZegoPlayerFirstFrameEvent;
import im.zego.zegoexpress.constants.ZegoPlayerMediaEvent;
import im.zego.zegoexpress.constants.ZegoPlayerState;
import im.zego.zegoexpress.constants.ZegoPublisherState;
import im.zego.zegoexpress.constants.ZegoRemoteDeviceState;
import im.zego.zegoexpress.constants.ZegoRoomState;
import im.zego.zegoexpress.constants.ZegoScenario;
import im.zego.zegoexpress.constants.ZegoUpdateType;
import im.zego.zegoexpress.constants.ZegoVideoMirrorMode;
import im.zego.zegoexpress.constants.ZegoViewMode;
import im.zego.zegoexpress.callback.IZegoExternalVideoRenderer;
import im.zego.zegoexpress.entity.ZegoEngineConfig;
import im.zego.zegoexpress.entity.ZegoMessageInfo;
import im.zego.zegoexpress.entity.ZegoBeautifyOption;
import im.zego.zegoexpress.entity.ZegoMixerTask;
import im.zego.zegoexpress.entity.ZegoPlayStreamQuality;
import im.zego.zegoexpress.entity.ZegoPublishStreamQuality;
import im.zego.zegoexpress.entity.ZegoReverbParam;
import im.zego.zegoexpress.entity.ZegoRoomConfig;
import im.zego.zegoexpress.entity.ZegoStream;
import im.zego.zegoexpress.entity.ZegoStreamRelayCDNInfo;
import im.zego.zegoexpress.entity.ZegoUser;
import im.zego.zegoexpress.entity.ZegoVideoConfig;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameSender;
import im.zego.zegoexpress.entity.ZegoWatermark;

// CutPkg: module = Mediaplayer
import im.zego.zegoexpress.module.mediaplayer.ZegoMediaplayer;
import im.zego.zegoexpress.module.mediaplayer.ZegoMediaplayerJni;
// CutPkg: module = Mediaplayer


import im.zego.zegoexpress.utils.ZegoLibraryLoadUtil;
import im.zego.zegoexpress.utils.ZegoLogUtil;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

final class ZegoExpressEngineJni {
    private static Handler mUIHandler;
    static private volatile boolean hasSoLoaded;
    private static ZegoExpressEngine engine = null;
    private static Application context;
    private static boolean mIsTestEnv = true;
    private static ZegoLanguage language = ZegoLanguage.ENGLISH;
    private static ArrayList<IZegoEventHandler> sEventHandlerList = new ArrayList<>();
    private static HashMap<Integer, IZegoPublisherUpdateCDNURLCallback> sPublisherUpdateCDNURLHandler = new HashMap<>();
    private static HashMap<Integer, IZegoPublisherSetStreamExtraInfoCallback> sPublisherUpdateStreamExtraInfoHandler = new HashMap<>();

    private static HashMap<Integer, IZegoMixerStartCallback> sMixerStartResultHandler = new HashMap<>();
    private static HashMap<Integer, IZegoMixerStopCallback> sMixerStopResultHandler = new HashMap<>();
    private static HashMap<Integer, IZegoIMSendBroadcastMessageCallback> sIMSendBoradcastMssageHandler = new HashMap<>();
    private static HashMap<Integer, IZegoIMSendCustomCommandCallback> sIMSendCustomCommandHandler = new HashMap<>();
    private static boolean isNoErrorCallback = false;


    final public static class ZegoInnerModule {
        public static final int MODULE_COMMON = 0;
        public static final int MODULE_ENGINE = 1;
        public static final int MODULE_ROOM = 2;
        public static final int MODULE_PUBLISHER = 3;
        public static final int MODULE_PLAYER = 4;
        public static final int MODULE_MIXER = 5;
        public static final int MODULE_DEVICE = 6;
        public static final int MODULE_PREPROCESS = 7;
        public static final int MODULE_MEDIAPLAYER = 8;
        public static final int MODULE_IM = 9;
        public static final int MODULE_RECODER = 10;
        public static final int MODULE_EXTERNAL_IO = 11;
    }

    private static final int MAX_EVENT_HANDLE_COUNT = 16;
    private static final int ZEGO_EXPRESS_MODULE_JNI = 0xc;
    private static final int RESERVE_SEGMENT = 1000000;
    private static final int ERRCODE_OFFSET = 1000;
    private static final int ZEGO_ERRCODE_SUCCESS = 0x0;
    private static final int ZEGO_ERRCODE_COMMON_ENGINE_NOT_CREATED = RESERVE_SEGMENT + ZegoInnerModule.MODULE_COMMON * ERRCODE_OFFSET + 1;
    private static final int ZEGO_ERRCODE_ENGINE_APPID_ZERO = RESERVE_SEGMENT + ZegoInnerModule.MODULE_ENGINE * ERRCODE_OFFSET;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_LENGTH = RESERVE_SEGMENT + ZegoInnerModule.MODULE_ENGINE * ERRCODE_OFFSET + 1;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_CHARACTER = RESERVE_SEGMENT + ZegoInnerModule.MODULE_ENGINE * ERRCODE_OFFSET + 2;
    private static final int ZEGO_ERRCODE_ENGINE_APPSIGN_NULL = RESERVE_SEGMENT + ZegoInnerModule.MODULE_ENGINE * ERRCODE_OFFSET + 3;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_NULL = RESERVE_SEGMENT + ZegoInnerModule.MODULE_ENGINE * ERRCODE_OFFSET + 27;
    private static final int ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_COUNT_EXCEED = RESERVE_SEGMENT + ZegoInnerModule.MODULE_ENGINE * ERRCODE_OFFSET + 28;


    private static IZegoExternalVideoRenderer mExternalRenderer;

    private static IZegoExternalVideoCapturer mExternalCapturer;

    private static ZegoVideoFrameSender mVideoFrameSender;



    static {
        try {
            System.loadLibrary("ZegoExpressEngine");
            hasSoLoaded = true;
        } catch (UnsatisfiedLinkError e) {
            //Log.e("ZEGO", "load ZegoExpressSDK native library failed", e);
            hasSoLoaded = false;
        }
    }

    //TODO 该接口需要做单元测试
    static boolean ensureSoLoaded(Context appContext, String customizeSoPath) {
        if (!hasSoLoaded) {
            //优先加载外部指定的so
            if (!TextUtils.isEmpty(customizeSoPath)) {
                try {
                    hasSoLoaded = ZegoLibraryLoadUtil.loadSpecialLibrary(customizeSoPath, appContext);
                } catch (UnsatisfiedLinkError e) {
                    Log.e("ZEGO", String.format("Load library %s failed", customizeSoPath), e);
                    return false;
                } catch (Exception e) {
                    Log.e("ZEGO", String.format("Load library %s failed", customizeSoPath), e);
                    return false;
                }
            }
        }

        if (!hasSoLoaded) {
            //当加载外部指定so失败时，指定库文件重新加载
            try {
                hasSoLoaded = ZegoLibraryLoadUtil.loadSoFile("libZegoExpressSDK.so", appContext);
                return hasSoLoaded;
            } catch (UnsatisfiedLinkError e) {
                Log.e("ZEGO", "Load library libZegoExpressSDK.so failed", e);
                return false;
            }
        }
        return true;
    }



    private static ZegoEngineConfig engineConfig;

    public static void setEngineConfig(ZegoEngineConfig engineConfig) {
        ZegoExpressEngineJni.engineConfig = engineConfig;
    }



    public static ZegoExpressEngine createEngine(long appID, String appSign, boolean isTestEnvironment,
                                                 ZegoScenario scenario, Application application, IZegoEventHandler handler) {

        // 防止多次调用在Java层产生多份实例
        if (engine != null) {
            return engine;
        }

        // 防止 application 参数传空
        if (application == null) {
            switch (language) {
                case ENGLISH:
                    throw new RuntimeException("Input application parameter abnormal");
                case CHINESE:
                    throw new RuntimeException("输入application参数异常");
            }
        }

        // 如果外层未设置 engineConfig , 桥接层应new一份实例，传到jni
        if(ZegoExpressEngineJni.engineConfig == null){
            ZegoExpressEngineJni.engineConfig = new ZegoEngineConfig();
        }

        String advanceConfig = "";
        if(ZegoExpressEngineJni.engineConfig.advancedConfig != null){
            for(String key: ZegoExpressEngineJni.engineConfig.advancedConfig.keySet()){
                advanceConfig += key+ "=" +ZegoExpressEngineJni.engineConfig.advancedConfig.get(key) + ";" ;
            }
        }


        // 当App层设置了 externalVideoRenderConfig , 说明开启了外部渲染
        // 由于jni层处理字段为枚举类型的对象时不方便, 这里转为基础类型来向jni传参
        boolean engineConfig_enableExternalVideoRender;
        boolean engineConfig_isInternalRender;
        int engineConfig_zegoExternalVideoRenderSeries;
        int engineConfig_zegoExternalVideoRenderType;
        if(ZegoExpressEngineJni.engineConfig.externalVideoRenderConfig != null){
            engineConfig_enableExternalVideoRender = true;
            engineConfig_zegoExternalVideoRenderSeries = ZegoExpressEngineJni.engineConfig.externalVideoRenderConfig.frameFormatSeries.value();
            engineConfig_isInternalRender = ZegoExpressEngineJni.engineConfig.externalVideoRenderConfig.enableInternalRender;
            engineConfig_zegoExternalVideoRenderType = ZegoExpressEngineJni.engineConfig.externalVideoRenderConfig.bufferType.value();
        }else {
            engineConfig_enableExternalVideoRender = false;
            engineConfig_isInternalRender = false;
            engineConfig_zegoExternalVideoRenderSeries = -1;
            engineConfig_zegoExternalVideoRenderType = -1;
        }

        // 当App层设置了 videoCaptureConfig , 说明开启了外部采集
        // 由于jni层处理字段为枚举类型的对象时不方便, 这里转为基础类型来向jni传参
        boolean engineConfig_enableExternalVideoCapture;
        int engineConfig_zegoExternalVideoCaptureType;
        if(ZegoExpressEngineJni.engineConfig.externalVideoCaptureConfig != null){
            engineConfig_enableExternalVideoCapture = true;
            engineConfig_zegoExternalVideoCaptureType =  ZegoExpressEngineJni.engineConfig.externalVideoCaptureConfig.bufferType.value();
        }else {
            engineConfig_enableExternalVideoCapture = false;
            engineConfig_zegoExternalVideoCaptureType = -1;
        }

        try {
            if(ZegoExpressEngineJni.engineConfig.logConfig.logPath.equals("")){
                ZegoExpressEngineJni.engineConfig.logConfig.logPath = ZegoLogUtil.getLogPath(application);
            }
        } catch (Exception ex) {
            switch (language) {
                case ENGLISH:
                    throw new RuntimeException("Input application parameter abnormal");
                case CHINESE:
                    throw new RuntimeException("输入application参数异常");
            }
        }

        ZegoExpressEngineJni.setEngineInitConfigToJni(ZegoExpressEngineJni.engineConfig,
                engineConfig_enableExternalVideoRender, engineConfig_zegoExternalVideoRenderSeries,
                engineConfig_isInternalRender, engineConfig_zegoExternalVideoRenderType,
                engineConfig_enableExternalVideoCapture, engineConfig_zegoExternalVideoCaptureType,
                ZegoExpressEngineJni.engineConfig.logConfig.logPath, ZegoExpressEngineJni.engineConfig.logConfig.logSize,
                advanceConfig);



        int errorCode = ZegoExpressEngineJni.engineInitJni(appID, appSign, isTestEnvironment, scenario.value(), application);

        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_COMMON, "createEngine", errorCode);
        if (errorCode != 0) {
            switch (language) {
                case ENGLISH:
                default:
                    throw new RuntimeException("Create engine failed, errorCode = " + errorCode);
                case CHINESE:
                    throw new RuntimeException("创建引擎失败, errorCode = " + errorCode);
            }
        } else {
            synchronized (ZegoExpressEngineJni.class) {
                mUIHandler = new Handler(Looper.getMainLooper());
                context = application;
                mIsTestEnv = isTestEnvironment;
                engine = new ZegoExpressEngine();
                if (handler != null) {
                    engine.addEventHandler(handler);
                }
                return engine;
            }
        }

    }


    public static ZegoExpressEngine getEngine() {
        return engine;
    }


    public static void destroyEngine() {
        int errorCode = ZegoExpressEngineJni.engineUninitJni();

        synchronized (ZegoExpressEngineJni.class) {
            if (sEventHandlerList != null) {
                sEventHandlerList.clear();
            }
            context = null;
            engine = null;
            mIsTestEnv = true;
            mUIHandler = null;
            language = ZegoLanguage.ENGLISH;
            isNoErrorCallback = false;

            // CutPkg: start, module = Mediaplayer
            ZegoMediaplayerJni.destroyAllMediaplayer();
            // CutPkg: end, module = Mediaplayer

            setExternalVideoCapturer(null);
            setExternalVideoRenderer(null);

        }
    }

    public static int addEventHandler(IZegoEventHandler eventHandler) {
        int errorCode = ZEGO_ERRCODE_SUCCESS;
        boolean isExist = false;

        synchronized (ZegoExpressEngineJni.class) {
            if (engine == null) {
                errorCode = ZEGO_ERRCODE_COMMON_ENGINE_NOT_CREATED;
            } else {
                if (eventHandler != null) {
                    for (int i = 0; i < sEventHandlerList.size(); i++) {
                        if (sEventHandlerList.get(i) == eventHandler) {
                            isExist = true;
                        }
                    }
                    if (!isExist) {
                        if (sEventHandlerList.size() >= MAX_EVENT_HANDLE_COUNT) {
                            errorCode = ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_COUNT_EXCEED;
                        } else {
                            //判断如果重复注册相同的对象，则直接返回成功
                            sEventHandlerList.add(eventHandler);
                        }
                    } else {
                        errorCode = ZEGO_ERRCODE_SUCCESS;
                    }
                } else {
                    errorCode = ZEGO_ERRCODE_ENGINE_EVENT_HANDLER_NULL;
                }
            }
        }
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, ZegoInnerModule.MODULE_COMMON,
                "addEventHandler", errorCode);
        logInfo(ZegoLogUtil.getFileName(), ZegoLogUtil.getMethodName(), ZegoLogUtil.getLineNumber(), ZegoDebugLevel.INFO,
                ZegoDebugLayer.DEBUG_LAYER_JNI, ZegoInnerModule.MODULE_ENGINE, "addEventHandler");
        return errorCode;
    }

    public static void removeEventHandler(IZegoEventHandler eventHandler) {
        if (eventHandler != null) {
            synchronized (ZegoExpressEngineJni.class) {
                if (sEventHandlerList != null) {
                    sEventHandlerList.remove(eventHandler);
                }
            }
        }
    }

    public static String getVersion() {
        return getVersionJni();
    }

    public static void setDebugVerbose(boolean enable, ZegoLanguage language) {
        ZegoExpressEngineJni.language = language;
        ZegoExpressEngineJni.setDebugVerboseJni(enable, language.value());
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_ENGINE,
                "setDebugVerbose", ZEGO_ERRCODE_SUCCESS);
    }

    public static void uploadLog() {
        ZegoExpressEngineJni.uploadLogJni();
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_ENGINE,
                "uploadLog", ZEGO_ERRCODE_SUCCESS);
    }

    public static int loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config) {
        int maxMemberCount = 0;
        int userStateNotify = 0;
        if (config != null) {
            maxMemberCount = config.maxMemberCount;
            userStateNotify = config.isUserStateNotify? 1: 0;
        }
        String userID = "";
        String userName = "";
        if (user != null) {
            userID = user.userID;
            userName = user.userName;
        }
        if (roomID == null) {
            roomID = "";
        }

        logInfo(ZegoLogUtil.getFileName(), ZegoLogUtil.getMethodName(), ZegoLogUtil.getLineNumber(), ZegoDebugLevel.INFO,
                    ZegoDebugLayer.DEBUG_LAYER_JNI, ZegoInnerModule.MODULE_ROOM,
                    "%s, %s, %s, %d, %d", roomID, userID, userName, maxMemberCount, userStateNotify);
        int errorCode = loginRoomJni(user, roomID, config);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_ROOM, "loginRoom", errorCode);
        return errorCode;
    }

    public static int loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config, String token) {
        int errorCode = loginRoomJni(user, roomID, config, token);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_ROOM, "loginRoom", errorCode);
        return errorCode;
    }

    public static void logoutRoom(String roomID) {
        int errorCode = ZegoExpressEngineJni.logoutRoomJni(roomID);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_ROOM, "logoutRoom", errorCode);
    }

    public static void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode) {
        int errorCode;
        if (mirrorMode == null) {
            errorCode = ZegoExpressEngineJni.ZegoVideoMirrorModeJni(ZegoVideoMirrorMode.ONLY_PREVIEW_MIRROR.value());
        } else {
            errorCode = ZegoExpressEngineJni.ZegoVideoMirrorModeJni(mirrorMode.value());
        }

        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setVideoMirrorMode", errorCode);
    }

    public static void setAppOrientation(ZegoOrientation orientation) {
        int errorCode;
        if (orientation == null) {
            errorCode = ZegoExpressEngineJni.setAppOrientationJni(ZegoOrientation.ORIENTATION_0.value());
        } else {
            errorCode = ZegoExpressEngineJni.setAppOrientationJni(orientation.value());
        }
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setAppOrientation", errorCode);
    }

    public static void startPreview(ZegoCanvas canvas) {
        int errorCode;
        if (canvas == null)
        {
            errorCode = ZegoExpressEngineJni.startPreviewJni(null, ZegoViewMode.ASPECT_FILL.value(), 0);
        }
        else if (canvas.viewMode == null) {
            errorCode = ZegoExpressEngineJni.startPreviewJni(canvas.view, ZegoViewMode.ASPECT_FILL.value(), canvas.backgroundColor);
        }
        else {
            errorCode = ZegoExpressEngineJni.startPreviewJni(canvas.view, canvas.viewMode.value(),canvas.backgroundColor);
        }
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "startPreview", errorCode);
    }

    public static void stopPreview() {
        int errorCode = ZegoExpressEngineJni.stopPreviewJni();
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "stopPreview", errorCode);
    }

    public static void setVideoConfig(ZegoVideoConfig videoConfig) {
        int errorCode = ZegoExpressEngineJni.setVideoConfigJni(videoConfig);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setVideoConfig", errorCode);
    }

    public static int startPublishing(String streamID) {
        int errorCode = ZegoExpressEngineJni.startPublishingJni(streamID);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "startPublish", errorCode);
        return errorCode;
    }

    public static void stopPublishing() {
        int errorCode = ZegoExpressEngineJni.stopPublishingJni();
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "stopPublishJni", errorCode);
    }

    public static void mutePublishStreamAudio(boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePublishStreamAudioJni(mute);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "mutePublishStreamAudio", errorCode);
    }

    public static void mutePublishStreamVideo(boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePublishStreamVideoJni(mute);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "mutePublishStreamVideo", errorCode);
    }

    public static void setStreamExtraInfo(String extraInfo, IZegoPublisherSetStreamExtraInfoCallback handler) {
        int seq = ZegoExpressEngineJni.setStreamExtraInfoJni(extraInfo);
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateStreamExtraInfoHandler.put(new Integer(seq), handler);
        }
    }

    public static void setCaptureVolume(int volume) {
        int errorCode = ZegoExpressEngineJni.setCaptureVolumeJni(volume);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setCaptureVolume", errorCode);
    }

    public static void setAudioConfig(ZegoAudioConfig config) {
        int errorCode = ZegoExpressEngineJni.setAudioConfigJni(config);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setAudioConfig", errorCode);
    }


    public static void enableTrafficControl(boolean enable, int controlTypeBitMask) {
        int errorCode = ZegoExpressEngineJni.enableTrafficControlJni(enable, controlTypeBitMask);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableTrafficControl", errorCode);
    }

    public static void addPublishCDNURL(String streamID, String targetURL, IZegoPublisherUpdateCDNURLCallback handler) {
        int seq = ZegoExpressEngineJni.addPublishCDNURLJni(streamID, targetURL);
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
        }
    }

    public static void removePublishCDNURL(String streamID, String targetURL, IZegoPublisherUpdateCDNURLCallback handler) {
        int seq = ZegoExpressEngineJni.removePublishCDNURLJni(streamID, targetURL);
        synchronized (ZegoExpressEngineJni.class) {
            sPublisherUpdateCDNURLHandler.put(new Integer(seq), handler);
        }
    }

    public static void setCapturePipelineScaleMode(ZegoCapturePipelineScaleMode mode){
        int errorCode = ZegoExpressEngineJni.setCapturePipelineScaleModeJni(mode.value());
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setCapturePipelineScaleMode", errorCode);
    }

    public static void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible) {
        int errorCode = ZegoExpressEngineJni.setPublishWatermarkJni(watermark, isPreviewVisible);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setPublishWatermark", errorCode);
    }

    public static void enableHardwareEncoder(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableHardwareEncoderJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableHardwareEncoder", errorCode);
    }

    public static void enableDTX(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableDTXJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableDTX", errorCode);
    }

    public static void enableVAD(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableVADJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableVAD", errorCode);
    }

    public static int startPlayingStream(String streamID, ZegoCanvas canvas) {
        //todo 后面让c层修改, 如果重复传入不同的view，会有什么影响？应该要提示用户或者帮客户换View
        int errorCode;
        if (canvas == null) {
            errorCode = ZegoExpressEngineJni.startPlayingStreamJni(streamID, null, 0, 0);
        } else {
            errorCode = ZegoExpressEngineJni.startPlayingStreamJni(streamID, canvas.view, canvas.viewMode == null ? ZegoViewMode.ASPECT_FIT.value() : canvas.viewMode.value(), canvas.backgroundColor);
        }
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PLAYER, "startPlayingStream", errorCode);
        return errorCode;
    }

    public static void stopPlayingStream(String streamID) {
        int errorCode = ZegoExpressEngineJni.stopPlayingStreamJni(streamID);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PLAYER, "stopPlayingStream", errorCode);
    }

    public static void setPlayVolume(String streamID, int volume) {
        int errorCode = ZegoExpressEngineJni.setPlayVolumeJni(streamID, volume);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PLAYER, "setPlayVolume", errorCode);
    }

    public static void mutePlayStreamAudio(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePlayStreamAudioJni(streamID, mute);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PLAYER, "mutePlayStreamAudio", errorCode);
    }

    public static void mutePlayStreamVideo(String streamID, boolean mute) {
        int errorCode = ZegoExpressEngineJni.mutePlayStreamVideoJni(streamID, mute);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PLAYER, "mutePlayStreamVideo", errorCode);
    }

    public static void enableHardwareDecoder(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableHardwareDecoderJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PLAYER, "enableHardwareDecoder", errorCode);
    }

    public static void startMixerTask(ZegoMixerTask task, IZegoMixerStartCallback handler) {
        int seq = ZegoExpressEngineJni.startMixerJni(task);
        synchronized (ZegoExpressEngineJni.class) {
            sMixerStartResultHandler.put(seq, handler);
        }
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_MIXER, "startMixerTask", 0);
    }

    public static void stopMixerTask(String taskID) {
        int errorCode = ZegoExpressEngineJni.stopMixerJni(taskID);
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_MIXER, "stopMixerTask", errorCode);
    }

    public static void muteMicrophone(boolean mute) {
        int errorCode = ZegoExpressEngineJni.muteMicrophoneJni(mute);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "muteMicrophone", errorCode);
    }

    public static void muteAudioOutput(boolean enable) {
        int errorCode = ZegoExpressEngineJni.muteAudioOutputJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "muteAudioOutput", errorCode);
    }

    public static void enableCamera(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableCameraJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableCamera", errorCode);
    }

    public static void useFrontCamera(boolean enable) {
        int errorCode = ZegoExpressEngineJni.useFrontCameraJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "useFrontCamera", errorCode);
    }

    public static void startSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJni.startSoundLevelMonitorJni();
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "startSoundLevelMonitor", errorCode);
    }

    public static void stopSoundLevelMonitor() {
        int errorCode = ZegoExpressEngineJni.stopSoundLevelMonitorJni();
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "stopSoundLevelMonitor", errorCode);
    }

    public static void startAudioSpectrumMonitor() {
        int errorCode = ZegoExpressEngineJni.startFrequencySpectrumMonitorJni();
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "startFrequencySpectrumMonitor", errorCode);
    }

    public static void stopAudioSpectrumMonitor() {
        int errorCode = ZegoExpressEngineJni.stopFrequencySpectrumMonitorJni();
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "stopFrequencySpectrumMonitor", errorCode);
    }

    public static void enableAudioCaptureDevice(boolean enable) {
        //todo 名称修改为audio
        int errorCode = ZegoExpressEngineJni.enableCaptureDeviceJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableCaptureDevice", errorCode);
    }

    public static void setBuildInSpeakerOn(boolean enable) {
        int errorCode = ZegoExpressEngineJni.setBuildInSpeakerOnJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setBuildInSpeakerOn", errorCode);
    }

    public static void enableAEC(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableAECJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableAEC", errorCode);
    }

    public static void setAECMode(ZegoAECMode mode) {
        int errorCode = ZegoExpressEngineJni.setAECModeJni(mode.value());
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setAECMode", errorCode);
    }

    public static void enableCheckPoc(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableCheckPocJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableCheckPoc", errorCode);
    }

    public static void enableAGC(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableAGCJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableAGC", errorCode);
    }

    public static void enableANS(boolean enable) {
        int errorCode = ZegoExpressEngineJni.enableANSJni(enable);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableANS", errorCode);
    }

    public static void enableBeautify(int feature) {
        int errorCode = ZegoExpressEngineJni.enableBeautifyJni(feature);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "enableBeautify", errorCode);
    }

    public static void setBeautifyOption(ZegoBeautifyOption option) {
        int errorCode = ZegoExpressEngineJni.setBeautifyOptionJni(option);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "setBeautifyOption", errorCode);
    }

    public static void sendSEI(ByteBuffer data, int dataLength) {
        int errorCode = ZegoExpressEngineJni.sendSEIJni(data, dataLength);
        ZegoExpressEngineJni.printDebugInfo((errorCode == 0) ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR,
                ZegoInnerModule.MODULE_PUBLISHER, "sendSEI", errorCode);
    }

    // CutPkg: start, module = Mediaplayer
    public static ZegoMediaplayer createMediaplayer() {
        return ZegoMediaplayerJni.createMediaplayer();
    }
    // CutPkg: end, module = Mediaplayer

    public static void setExternalVideoRenderer(IZegoExternalVideoRenderer renderer) {
        mExternalRenderer = renderer;
    }

    public static void setExternalVideoCapturer(IZegoExternalVideoCapturer capturer) {
        mExternalCapturer = capturer;
        if(capturer != null){
        }else {
            onExternalVideoCaptureWillStop();
        }
    }

    static void onExternalVideoCaptureWillStart(){
        mVideoFrameSender = new ZegoVideoFrameSender();

        if(mExternalCapturer != null){
            // 经讨论，外部采集的通知不切线程
            mExternalCapturer.willStart(mVideoFrameSender);
        }else {
            //todo: 这里需要增加日志打印
        }
    }

    public static void onExternalVideoCaptureWillStop(){
        if(mVideoFrameSender != null && mExternalCapturer != null){
            // 经讨论，外部采集的通知不切线程
            mExternalCapturer.willStop();
            mVideoFrameSender = null;
        }else {
            //todo: 这里需要增加日志打印
        }
    }


    public static void sendBroadcastMessage(String message, String roomID, IZegoIMSendBroadcastMessageCallback callback) {
        int seq = ZegoExpressEngineJni.sendBroadcastMessageJni(message, roomID);
        synchronized (ZegoExpressEngineJni.class) {
            sIMSendBoradcastMssageHandler.put(seq, callback);
        }
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_IM, "sendBroadcastMessage", 0);
    }

    public static void sendCustomCommand(String command, ArrayList<ZegoUser> toUserList, String roomID, IZegoIMSendCustomCommandCallback callback) {

        int size = toUserList.size();
        ZegoUser[] userList = toUserList.toArray(new ZegoUser[size]);
        int seq = ZegoExpressEngineJni.sendCustomerMessageJni(command, userList, roomID);
        synchronized (ZegoExpressEngineJni.class) {
            sIMSendCustomCommandHandler.put(seq, callback);
        }
        ZegoExpressEngineJni.printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_IM, "sendCustomCommand", 0);
    }

    /* zego-express-engine-jni */
    private static native int engineInitJni(long appID, String appSign, boolean isTestEnvironment, int scenario, Context context);

    private native static void setEngineInitConfigToJni(ZegoEngineConfig engineConfig,
                                                        boolean engineConfig_enableExternalVideoRender,
                                                        int engineConfig_zegoExternalVideoRenderSeries,
                                                        boolean engineConfig_isInternalRender,
                                                        int engineConfig_zegoExternalVideoRenderType,
                                                        boolean engineConfig_enableExternalVideoCapture,
                                                        int engineConfig_zegoExternalVideoCaptureType,
                                                        String logPath, int logSize, String advanceConfig);

    private static native int engineUninitJni();

    private static native String getVersionJni();

    private static native void setDebugVerboseJni(boolean enable, int language);

    private static native void uploadLogJni();

    /* zego-express-room.h */
    private static native int loginRoomJni(ZegoUser user, String roomID, ZegoRoomConfig config);

    private static native int loginRoomJni(ZegoUser user, String roomID, ZegoRoomConfig config, String token);

    public static native int logoutRoomJni(String roomID);

    /* zego-express-publisher.h */

    public static native int ZegoVideoMirrorModeJni(int viewMode);

    public static native int setCapturePipelineScaleModeJni(int zegoCapturePipelineScaleMode);

    public static native int enableCheckPocJni(boolean enable);

    public static native int setAppOrientationJni(int orientation);

    public static native int startPreviewJni(Object view, int viewMode, int backgroundColor);

    public static native int stopPreviewJni();

//    public static native int setLatencyModeJni(int latencyMode);
//
//    public static native int setAudioBitrateJni(int bitrate);
//
//    public static native int setAudioChannelCountJni(int channelCount);

    public static native int setVideoConfigJni(ZegoVideoConfig videoConfig);

    public static native int startPublishingJni(String streamID);

    public static native int stopPublishingJni();

    public static native int mutePublishStreamAudioJni(boolean mute);

    public static native int mutePublishStreamVideoJni(boolean mute);

    public static native int setStreamExtraInfoJni(String extraInfo);

    public static native int setCaptureVolumeJni(int volume);

    public static native int enableTrafficControlJni(boolean enable, int controlTypeBitMask);

    public static native int addPublishCDNURLJni(String streamID, String targetURL);

    public static native int removePublishCDNURLJni(String streamID, String targetURL);

    public static native int setPublishWatermarkJni(ZegoWatermark watermark, boolean isPreviewVisible);

    public static native int enableHardwareEncoderJni(boolean enable);

    public static native int enableDTXJni(boolean enable);

    public static native int enableVADJni(boolean enable);

    native static int sendSEIJni(ByteBuffer data, int dataLength);

    /* zego-express-player.h */

    public static native int startPlayingStreamJni(String streamID, Object view, int viewMode, int bacgroundColor);

    public static native int stopPlayingStreamJni(String streamID);

    public static native int setPlayVolumeJni(String streamID, int volume);

    public static native int mutePlayStreamAudioJni(String streamID, boolean mute);

    public static native int mutePlayStreamVideoJni(String streamID, boolean mute);

    public static native int enableHardwareDecoderJni(boolean enable);

    /* zego-express-mixer.h */
    public static native int startMixerJni(ZegoMixerTask task);

    public static native int stopMixerJni(String taskID);

    /* zego-express-device.h */
    public static native int muteMicrophoneJni(boolean mute);

    public static native int muteAudioOutputJni(boolean enable);

    public static native int enableCameraJni(boolean enable);

    public static native int useFrontCameraJni(boolean enable);

    public static native int startSoundLevelMonitorJni();

    public static native int stopSoundLevelMonitorJni();

    public static native int startFrequencySpectrumMonitorJni();

    public static native int stopFrequencySpectrumMonitorJni();

    public static native int enableCaptureDeviceJni(boolean enable);

    public static native int setBuildInSpeakerOnJni(boolean enable);

    /* zego-express-preprocess.h */
    public static native int enableAECJni(boolean enable);

    public static native int setAECModeJni(int mode);

    public static native int enableAGCJni(boolean enable);

    public static native int enableANSJni(boolean enable);

    public static native int enableVirtualStereoJni(boolean enable, int angle);

    public static native int enableReverbJni(boolean enable, int reverbMode);

    public static native int setReverbParamsJni(ZegoReverbParam params);

    public static native int enableBeautifyJni(int feature);

    public static native int setBeautifyOptionJni(ZegoBeautifyOption option);

    public static native int setWatermarkImagePathJni(String imagePath);

    public static native int setPreviewWatermarkPositionJni(int left, int top, int right, int bottom);

    public static native int setPublishWatermarkPositionJni(int left, int top, int right, int bottom);

    /* zego-express-im.h */
    public static native int sendBroadcastMessageJni(String message, String roomID);
    public static native int sendCustomerMessageJni(String command, ZegoUser[] toUserList, String roomID);


    /* Callback */
    public static void printDebugInfo(ZegoDebugLevel level, int module, String funcName, int errorCode, Object... args) {
        String enInfo = "";
        String cnInfo = "";
        String msg = "";

        switch (errorCode) {
            case ZEGO_ERRCODE_COMMON_ENGINE_NOT_CREATED:
                enInfo = "Engine not create, engine need to be created before calling non-static function";
                cnInfo = "未初始化引擎，在调用非静态方法前需要先初始化引擎";
                break;
            case ZEGO_ERRCODE_ENGINE_APPID_ZERO:
                enInfo = "App ID cannot be 0, please check if app ID is correct";
                cnInfo = "app ID不能为0，请检查app ID是否正确";
                break;
            case ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_LENGTH:
                enInfo = "The length of input appsign must be 64 bytes";
                cnInfo = "AppSign长度必须为64字节";
                break;
            case ZEGO_ERRCODE_ENGINE_APPSIGN_INVALID_CHARACTER:
                enInfo = "The input appsign contains illegal characters, Only '0'-'9','a'-'f','A'-'F' are valid";
                cnInfo = "输入AppSign包含非法字符, 仅支持'0'-'9','a'-'f','A'-'F'";
                break;
            case ZEGO_ERRCODE_ENGINE_APPSIGN_NULL:
                enInfo = "Input appsign is empty";
                cnInfo = "输入AppSign为空";
                break;
            case ZEGO_ERRCODE_SUCCESS:
            default:
                ZegoExpressEngineJni.printDebugInfoJni(level.value(), module, funcName, errorCode, args);
                return;
        }

        switch (language) {
            case ENGLISH:
                msg = " Kind reminder：Failed to call function: " + funcName + "\n\r" +
                        "Error Code:" + errorCode + "\n\r" +
                        "Error Info：" + enInfo + "\n\r" + "\n\r" +
                        "You can see in the debug console for more details.";
                break;
            case CHINESE:
                msg = " 温馨提醒：调用" + funcName + "接口失败。" + "\n\r" +
                        "错误码:" + errorCode + "\n\r" +
                        "错误信息：" + cnInfo + "\n\r" + "\n\r" +
                        "可以在调试信息控制台中查看更多信息。";
                break;
        }

        if (!msg.equals("")) {
            Log.e("[ZEGO][ERROR][COMMON]" + funcName, msg);
            showToastMsg(msg);
        }
    }

    public static void logInfo(String fileName, String funcName, int line, ZegoDebugLevel level, ZegoDebugLayer layer, int module, String format, Object... args) {
        for (int i = 0; i < args.length; i++) {
            if (args[i] == null) {
                return;
            }
        }
        ZegoExpressEngineJni.logInfoJni(fileName, funcName, line, level.value(), layer.value(), module, format, args);
    }

    //TODO:确认ZegoLiveRoom.java和ZegoLiveRoomJNI.java中的onLoginRoom接口处理的差别
    //TODO:这里数组不指定长度，是否会有问题？
    public static void onRoomStreamUpdate(final String roomID, final int updateType, final ZegoStream[] streamList) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_ROOM, "onRoomStreamUpdate", 0);
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<ZegoStream>();
        for (int i = 0; i < streamList.length; i++) {
            streamArrayList.add(streamList[i]);
        }
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onRoomStreamUpdate(roomID, ZegoUpdateType.values()[updateType], streamArrayList);
                        }
                    }
                }
            });
        }
    }

    public static void onRoomStateUpdate(final String roomID, final int state, final int errorCode) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onRoomStateUpdate(roomID, ZegoRoomState.values()[state], errorCode);
                        }
                    }
                }
            });
        }
    }

    public static void onStreamExtraInfoUpdate(final ZegoStream[] streamList, final int streamInfoCount, final String roomID) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_ROOM, "onStreamExtraInfoUpdate", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            //sEventHandlerList.get(i).onStreamExtraInfoUpdate(streamList, streamInfoCount, roomID);
                        }
                    }
                }
            });
        }
    }

    public static void onRoomUserUpdate(final String roomID, final int updateType, final ZegoUser[] userList) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_ROOM, "onRoomUserUpdate", 0);
        final ArrayList<ZegoUser> userArrayList = new ArrayList<ZegoUser>();
        for (int i = 0; i < userList.length; i++) {
            userArrayList.add(userList[i]);
        }
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onRoomUserUpdate(roomID, ZegoUpdateType.values()[updateType], userArrayList);
                        }
                    }
                }
            });
        }
    }

    public static void onPublisherStateUpdate(final String streamID, final int state, final int errorCode) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PUBLISHER, "onPublisherStateUpdate", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPublisherStateUpdate(streamID, ZegoPublisherState.values()[state], errorCode);
                        }
                    }
                }
            });
        }
    }

    public static void onPublisherUpdateCDNURLResult(final String streamID, final int errorCode, final int seq) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoPublisherUpdateCDNURLCallback handler = sPublisherUpdateCDNURLHandler.get(seq);
                        if (handler != null) {
                            handler.onPublisherUpdateCDNURLResult(streamID, errorCode);
                            sPublisherUpdateCDNURLHandler.remove(seq);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerRecvSEI(final String streamID, final ByteBuffer data, final int dataLength){
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPlayerRecvSEI(streamID, data, dataLength);
                        }
                    }
                }
            });
        }
    }

    public static void onPublisherUpdateStreamExtraInfoResult(final int errorCode, final int seq) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoPublisherSetStreamExtraInfoCallback handler = sPublisherUpdateStreamExtraInfoHandler.get(seq);
                        if (handler != null) {
                            handler.onPublisherSetStreamExtraInfoResult(errorCode);
                            sPublisherUpdateStreamExtraInfoHandler.remove(seq);
                        }
                    }
                }
            });
        }
    }


    public static void onPublisherQualityUpdate(final String streamID, final ZegoPublishStreamQuality quality) {
        //printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PUBLISHER, "onPublisherQualityUpdate", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPublisherQualityUpdate(streamID, quality);
                        }
                    }
                }
            });
        }
    }

    public static void onPublisherMediaEvent(final int media_event, final int reason, final String streamID) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PUBLISHER, "onPublisherMediaEvent", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            //sEventHandlerList.get(i).onPublisherMediaEvent(media_event, reason, streamID);
                        }
                    }
                }
            });
        }
    }

    public static void onPublisherRecvAudioFirstFrame() {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PUBLISHER, "onPublisherRecvAudioFirstFrame", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPublisherRecvFirstFrameEvent(ZegoPublisherFirstFrameEvent.AUDIO_CAPTURED);
                        }
                    }
                }
            });
        }
    }

    public static void onPublisherRecvVideoFirstFrame() {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PUBLISHER, "onPublisherRecvVideoFirstFrame", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPublisherRecvFirstFrameEvent(ZegoPublisherFirstFrameEvent.VIDEO_CAPTURED);
                        }
                    }
                }
            });
        }
    }

    public static void onPublisherVideoSizeChanged(final int width, final int height) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PUBLISHER, "onPublisherVideoSizeChanged", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPublisherVideoSizeChanged(width, height);
                        }
                    }
                }
            });
        }
    }

    public static void onPublisherRelayCDNStateUpdate(final String streamID, ZegoStreamRelayCDNInfo[] infoList) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; i++) {
            infoArrayList.add(infoList[i]);
        }

        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPublisherRelayCDNStateUpdate(streamID, infoArrayList);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerStateUpdate(final String streamID, final int state, final int errorCode) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PLAYER, "onPlayerStateUpdate", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPlayerStateUpdate(streamID, ZegoPlayerState.values()[state], errorCode);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerQualityUpdate(final String streamID, final ZegoPlayStreamQuality quality) {
        //printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.PLAYER, "onPlayerQualityUpdate", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPlayerQualityUpdate(streamID, quality);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerMediaEvent(final String streamID, final int mediaEvent) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PLAYER, "onPlayerMediaEvent", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPlayerMediaEvent(streamID, ZegoPlayerMediaEvent.values()[mediaEvent]);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerRecvAudioFirstFrame(final String streamID) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PLAYER, "onPlayerRecvAudioFirstFrame", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPlayerRecvFirstFrameEvent(streamID, ZegoPlayerFirstFrameEvent.AUDIO_RCV);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerRecvVideoFirstFrame(final String streamID) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PLAYER, "onPlayerRecvVideoFirstFrame", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPlayerRecvFirstFrameEvent(streamID, ZegoPlayerFirstFrameEvent.VIDEO_RCV);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerRenderVideoFirstFrame(final String streamID) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PLAYER, "onPlayerRenderVideoFirstFrame", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPlayerRecvFirstFrameEvent(streamID, ZegoPlayerFirstFrameEvent.VIDEO_RENDER);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerVideoSizeChanged(final String streamID, final int width, final int height) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_PLAYER, "onPlayerVideoSizeChanged", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onPlayerVideoSizeChanged(streamID, width, height);
                        }
                    }
                }
            });
        }
    }

    public static void onRoomStreamExtraInfoUpdate(final String roomID, ZegoStream[] streamList) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_ROOM, "onRoomStreamExtraInfoUpdate", 0);
        final ArrayList<ZegoStream> streamArrayList = new ArrayList<>();
        for (int i = 0; i < streamList.length; i++) {
            streamArrayList.add(streamList[i]);
        }
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onRoomStreamExtraInfoUpdate(roomID, streamArrayList);
                        }
                    }
                }
            });
        }
    }

    public static void onIMRecvBroadcastMessage(final String roomID, ZegoMessageInfo[] messageList) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_IM, "onIMRecvBroadcastMessage", 0);
        final ArrayList<ZegoMessageInfo> messageArrayList = new ArrayList<>();
        for (int i = 0; i < messageList.length; i++) {
            messageArrayList.add(messageList[i]);
        }
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onIMRecvBroadcastMessage(roomID, messageArrayList);
                        }
                    }
                }
            });
        }
    }

    public static void onIMRecvCustomCommand(final String roomID, final ZegoUser fromUser, final String command) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_IM, "onIMRecvCustomCommand", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onIMRecvCustomCommand(roomID, fromUser, command);
                        }
                    }
                }
            });
        }
    }

    public static void onIMSendBroadcastMessageResult(final String roomID, final int errorCode, final int seq) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoIMSendBroadcastMessageCallback callback = sIMSendBoradcastMssageHandler.get(seq);
                        if (callback != null) {
                            callback.onIMSendBroadcastMessageResult(errorCode);
                        }
                        sIMSendBoradcastMssageHandler.remove(seq);
                    }
                }
            });
        }
    }

    public static void onIMSendCustomCommandResult(final String roomID, final int errorCode, final int seq) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoIMSendCustomCommandCallback callback = sIMSendCustomCommandHandler.get(seq);
                        if (callback != null) {
                            callback.onIMSendCustomCommandResult(errorCode);
                        }
                        sIMSendCustomCommandHandler.remove(seq);
                    }
                }
            });
        }
    }

    public static void onRemoteCameraStateUpdate(final String streamID, final int state) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onRemoteCameraStateUpdate(streamID, ZegoRemoteDeviceState.values()[state]);
                        }
                    }
                }
            });
        }
    }

    public static void onRemoteMICStateUpdate(final String streamID, final int state) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onRemoteMicStateUpdate(streamID, ZegoRemoteDeviceState.values()[state]);
                        }
                    }
                }
            });
        }
    }

    public static void onDeviceError(final int errorCode, final String deviceName) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_DEVICE, "onDeviceError", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onDeviceError(errorCode, deviceName);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerSoundLevelUpdate(final HashMap<String, Double> soundLevelHashMap) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_DEVICE, "onPlayerSoundLevelUpdate", 0);

        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onRemoteSoundLevelUpdate(soundLevelHashMap);
                        }
                    }
                }
            });
        }
    }

    public static void onCapturedSoundLevelUpdate(final double soundLevel) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_DEVICE, "onCapturedSoundLevelUpdate", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onCapturedSoundLevelUpdate(soundLevel);
                        }
                    }
                }
            });
        }
    }

    public static void onCapturedFrequencySpectrumUpdate(final double[] frequencySpectrum) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_DEVICE, "onCapturedFrequencySpectrumUpdate", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onCapturedAudioSpectrumUpdate(frequencySpectrum);
                        }
                    }
                }
            });
        }
    }

    public static void onPlayerFrequencySpectrumUpdate(final HashMap<String, double[]> frequencySpectrums) {
        printDebugInfo(ZegoDebugLevel.INFO, ZegoInnerModule.MODULE_DEVICE, "onPlayerFrequencySpectrumUpdate", 0);
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onRemoteAudioSpectrumUpdate(frequencySpectrums);
                        }
                    }
                }
            });
        }
    }

    public static void onMixerStartResult(final String taskID, final int seq, final int errorCode) {
        //todo 混流不走通用事件通知
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        ZegoMixerStartResult result = new ZegoMixerStartResult();
                        result.errorCode = errorCode;
                        IZegoMixerStartCallback callback = sMixerStartResultHandler.get(seq);
                        if (callback != null) {
                            callback.onMixerStartResult(taskID, result);
                        }
                        sMixerStartResultHandler.remove(seq);
                    }
                }
            });
        }
    }

    public static void onMixerStopResult(final String taskID, final int seq, final int errorCode) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        IZegoMixerStopCallback callback = sMixerStopResultHandler.get(seq);
                        if (callback != null) {
                            callback.onMixerStopResult(taskID, errorCode);
                        }
                        sMixerStopResultHandler.remove(seq);
                    }
                }
            });
        }
    }

    public static void onMixerRelayCDNStateUpdate(final ZegoStreamRelayCDNInfo[] infoList, final String taskID) {
        final ArrayList<ZegoStreamRelayCDNInfo> infoArrayList = new ArrayList<ZegoStreamRelayCDNInfo>();
        for (int i = 0; i < infoList.length; i++) {
            infoArrayList.add(infoList[i]);
        }

        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }
            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onMixerRelayCDNStateUpdate(infoArrayList, taskID);
                        }
                    }
                }
            });
        }
    }

    public static void onExternalVideoRenderCapturedFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat,int rotation, int videoFlipMode){
        if (mExternalRenderer != null) {
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            zegoVideoFrameParam.strides = strides;
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            zegoVideoFrameParam.rotation = rotation;
            mExternalRenderer.onCapturedVideoFrameRawData(buffers, dataLen, zegoVideoFrameParam, ZegoVideoFlipMode.values()[videoFlipMode]);
        }
    }

    public static void onExternalVideoRenderRemoteFrameData(ByteBuffer[] buffers, int[] dataLen, int[] strides, int width, int height, int videoPixelFormat, String streamID){
        if(mExternalRenderer != null){
            ZegoVideoFrameParam zegoVideoFrameParam = new ZegoVideoFrameParam();
            zegoVideoFrameParam.strides = strides;
            zegoVideoFrameParam.format = ZegoVideoFrameFormat.values()[videoPixelFormat];
            zegoVideoFrameParam.width = width;
            zegoVideoFrameParam.height = height;
            mExternalRenderer.onRemoteVideoFrameRawData(buffers, dataLen, zegoVideoFrameParam, streamID);
        }
    }



    public static void showToastMsg(String msg) {
        //todo 是否有可能线程不安全
        if (!mIsTestEnv) {
            //只有在测试环境下，才弹窗提示
            return;
        }

        if (context != null) {
            try {
                Toast.makeText(context, msg, Toast.LENGTH_LONG).show();
            }
            catch (Exception e) {
                //do nothing
            }
        }
    }

    public static void onDebugError(final int errorCode, final String funcName, final String info) {
        synchronized (ZegoExpressEngineJni.class) {
            if (mUIHandler == null) {
                //todo: 这里需要增加日志打印
                return;
            }

            mUIHandler.post(new Runnable() {
                @Override
                public void run() {
                    synchronized (ZegoExpressEngineJni.class) {
                        String msg;
                        if (errorCode == 0) {
                            if (!isNoErrorCallback) {
                                return;
                            }
                            msg = "调用" + funcName + "接口成功";
                            showToastMsg(msg);
                        } else {
                            switch (language) {
                                case ENGLISH:
                                default:
                                    msg = " Kind reminder：Failed to call function: " + funcName + "\n\r" +
                                            "Error Code:" + errorCode + "\n\r" +
                                            "Error Info：" + info + "\n\r" + "\n\r" +
                                            "You can see in the debug console for more details.";
                                    break;
                                case CHINESE:
                                    msg = " 温馨提醒：调用" + funcName + "接口失败。" + "\n\r" +
                                            "错误码:" + errorCode + "\n\r" +
                                            "错误信息：" + info + "\n\r" + "\n\r" +
                                            "可以在调试信息控制台中查看更多信息。";
                                    break;
                            }
                            showToastMsg(msg);
                        }

                        if (sEventHandlerList == null) {
                            return;
                        }
                        for (int i = 0; i < sEventHandlerList.size(); i++) {
                            sEventHandlerList.get(i).onDebugError(errorCode, funcName, info);
                        }
                    }
                }
            });
        }
    }

    public static void enableNoErrorCallback(boolean enable) {
        isNoErrorCallback = enable;
    }

    public static native void printDebugInfoJni(int level, int module, String funcName, int errorCode, Object... args);

    public static native void logInfoJni(String fileName, String funcName, int line, int level, int layer, int module, String format, Object... args);

    public static native int setTestCase(int group, int id, String desc, boolean enableStub);

    public static native int triggerCallback();

    public static native int setAudioConfigJni(ZegoAudioConfig config) ;

}
