package com.zego.zegoavkit2.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;

public class NetworkStateChangeReceiver2 extends BroadcastReceiver {

    private long mThis;
    private Context mContext;

    public void setThis(long pThis) {
        mThis = pThis;
    }

    public int init(Context ctx) {
        mContext = ctx;
        if (mContext == null) {
            return -1;
        }

        // 注册广播, 监听网络状态变化
        IntentFilter intentFilterNetwork = new IntentFilter();
        intentFilterNetwork.addAction(ConnectivityManager.CONNECTIVITY_ACTION);

        mContext.registerReceiver(this, intentFilterNetwork);

        // * init state
        onReceive(null, null);
        return 0;
    }

    public int uninit() {
        if (mContext == null) {
            return -1;
        }

        mContext.unregisterReceiver(this);
        mContext = null;
        return 0;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        if (mContext == null) {
            return ;
        }

        int nt = 32;

        ConnectivityManager cm = (ConnectivityManager) mContext.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo ni = null;
        if (cm != null) {
            ni = cm.getActiveNetworkInfo();
        }

        if (ni == null || !ni.isConnectedOrConnecting()) {
            nt = 0;  // * no network
        } else {
            switch (ni.getType()) {
                case ConnectivityManager.TYPE_WIFI:
                    nt = 2;
                    break;
                case ConnectivityManager.TYPE_MOBILE:
                    switch (ni.getSubtype()) {
                        case TelephonyManager.NETWORK_TYPE_GPRS: //联通2g
                        case TelephonyManager.NETWORK_TYPE_CDMA: //电信2g
                        case TelephonyManager.NETWORK_TYPE_EDGE: //移动2g
                        case TelephonyManager.NETWORK_TYPE_1xRTT:
                        case TelephonyManager.NETWORK_TYPE_IDEN:
                            nt = 3;
                            break;
                        case TelephonyManager.NETWORK_TYPE_EVDO_A: //电信3g
                        case TelephonyManager.NETWORK_TYPE_UMTS:
                        case TelephonyManager.NETWORK_TYPE_EVDO_0:
                        case TelephonyManager.NETWORK_TYPE_HSDPA:
                        case TelephonyManager.NETWORK_TYPE_HSUPA:
                        case TelephonyManager.NETWORK_TYPE_HSPA:
                        case TelephonyManager.NETWORK_TYPE_EVDO_B:
                        case TelephonyManager.NETWORK_TYPE_EHRPD:
                        case TelephonyManager.NETWORK_TYPE_HSPAP:
                            nt = 4;
                            break;
                        case TelephonyManager.NETWORK_TYPE_LTE:
                            nt = 5;
                            break;
                        default:
                            nt = 32;    // unknown
                            break;
                    }
                    break;
                case ConnectivityManager.TYPE_ETHERNET:
                    nt = 1;     // network line
                    break;
                default:
                    nt = 32;    // unknown
                    break;
            }
        }

        onNetTypeChanged(mThis, nt);
    }

    native static void onNetTypeChanged(long pThis, int nt);
}
