package com.zego.zegoavkit2.hardwaremonitor;

import android.os.Process;
import android.content.Context;

import com.zego.zegoavkit2.hardwaremonitor.ZegoMEMUtils;
import com.zego.zegoavkit2.hardwaremonitor.ZegoCPUUtils;

public final class ZegoHardwareMonitor {

    public static double getProcessCPUUsage() {
        int pid = android.os.Process.myPid();
        return ZegoCPUUtils.getProcessCPUUsage(pid);
    }

    public static double getSystemCPUUsage() {
        return ZegoCPUUtils.getSystemCPUUsage();
    }

    public static double getMEMUsage(Context context) {
        int pid = android.os.Process.myPid();
        long[] value = ZegoMEMUtils.getPSS(context, pid);
        return (double)(value[2] / 1024.0);
    }

    public static double getSystemMEMUsage(Context context) {
        long[] value = ZegoMEMUtils.getMemInfo();
        return (double)(value[0] - value[1]);
    }

    public static double getMEMTotal(Context context) {
        long[] value = ZegoMEMUtils.getMemInfo();
        return (double)(value[0]);
    }
}