/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress;

import android.app.Application;
import android.graphics.SurfaceTexture;
import im.zego.zegoexpress.ZegoExpressEngineJni;
import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.ZegoMediaPlayerJni;
import im.zego.zegoexpress.callback.IZegoAudioDataHandler;
import im.zego.zegoexpress.callback.IZegoAudioMixingHandler;
import im.zego.zegoexpress.callback.IZegoCustomVideoCaptureHandler;
import im.zego.zegoexpress.callback.IZegoCustomVideoRenderHandler;
import im.zego.zegoexpress.callback.IZegoDataRecordEventHandler;
import im.zego.zegoexpress.callback.IZegoDestroyCompletionCallback;
import im.zego.zegoexpress.callback.IZegoEventHandler;
import im.zego.zegoexpress.callback.IZegoIMSendBarrageMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendBroadcastMessageCallback;
import im.zego.zegoexpress.callback.IZegoIMSendCustomCommandCallback;
import im.zego.zegoexpress.callback.IZegoMixerStartCallback;
import im.zego.zegoexpress.callback.IZegoMixerStopCallback;
import im.zego.zegoexpress.callback.IZegoPublisherSetStreamExtraInfoCallback;
import im.zego.zegoexpress.callback.IZegoPublisherUpdateCdnUrlCallback;
import im.zego.zegoexpress.constants.ZegoAECMode;
import im.zego.zegoexpress.constants.ZegoANSMode;
import im.zego.zegoexpress.constants.ZegoCapturePipelineScaleMode;
import im.zego.zegoexpress.constants.ZegoLanguage;
import im.zego.zegoexpress.constants.ZegoOrientation;
import im.zego.zegoexpress.constants.ZegoPublishChannel;
import im.zego.zegoexpress.constants.ZegoScenario;
import im.zego.zegoexpress.constants.ZegoTrafficControlMinVideoBitrateMode;
import im.zego.zegoexpress.constants.ZegoVideoMirrorMode;
import im.zego.zegoexpress.constants.ZegoViewMode;
import im.zego.zegoexpress.constants.ZegoVolumeType;
import im.zego.zegoexpress.entity.ZegoAudioConfig;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoBeautifyOption;
import im.zego.zegoexpress.entity.ZegoCDNConfig;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoCustomAudioConfig;
import im.zego.zegoexpress.entity.ZegoCustomVideoCaptureConfig;
import im.zego.zegoexpress.entity.ZegoCustomVideoRenderConfig;
import im.zego.zegoexpress.entity.ZegoDataRecordConfig;
import im.zego.zegoexpress.entity.ZegoEngineConfig;
import im.zego.zegoexpress.entity.ZegoMixerTask;
import im.zego.zegoexpress.entity.ZegoPlayerConfig;
import im.zego.zegoexpress.entity.ZegoReverbParam;
import im.zego.zegoexpress.entity.ZegoRoomConfig;
import im.zego.zegoexpress.entity.ZegoUser;
import im.zego.zegoexpress.entity.ZegoVideoConfig;
import im.zego.zegoexpress.entity.ZegoVideoEncodedFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.entity.ZegoVoiceChangerParam;
import im.zego.zegoexpress.entity.ZegoWatermark;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ZegoExpressEngine {
    ZegoExpressEngine() {
    }

    public static ZegoExpressEngine createEngine(long appID, String appSign, boolean isTestEnv, ZegoScenario scenario, Application application, IZegoEventHandler eventHandler) {
        return ZegoExpressEngineJni.createEngine(appID, appSign, isTestEnv, scenario, application, eventHandler);
    }

    public static void destroyEngine(IZegoDestroyCompletionCallback callback) {
        ZegoExpressEngineJni.destroyEngine(callback);
    }

    public static ZegoExpressEngine getEngine() {
        return ZegoExpressEngineJni.getEngine();
    }

    public static void setEngineConfig(ZegoEngineConfig config) {
        ZegoExpressEngineJni.setEngineConfig(config);
    }

    public static String getVersion() {
        return ZegoExpressEngineJni.getVersion();
    }

    public void setEventHandler(IZegoEventHandler eventHandler) {
        ZegoExpressEngineJni.setEventHandler(eventHandler);
    }

    public void uploadLog() {
        ZegoExpressEngineJni.uploadLog();
    }

    public void setDebugVerbose(boolean enable, ZegoLanguage language) {
        ZegoExpressEngineJni.setDebugVerbose(enable, language);
    }

    public void loginRoom(String roomID, ZegoUser user) {
        ZegoExpressEngineJni.loginRoom(roomID, user, null);
    }

    public void loginRoom(String roomID, ZegoUser user, ZegoRoomConfig config) {
        ZegoExpressEngineJni.loginRoom(roomID, user, config);
    }

    public void logoutRoom(String roomID) {
        ZegoExpressEngineJni.logoutRoom(roomID);
    }

    public void startPublishingStream(String streamID) {
        ZegoExpressEngineJni.startPublishingStream(streamID, ZegoPublishChannel.MAIN);
    }

    public void startPublishingStream(String streamID, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.startPublishingStream(streamID, channel);
    }

    public void stopPublishingStream() {
        ZegoExpressEngineJni.stopPublishingStream(ZegoPublishChannel.MAIN);
    }

    public void stopPublishingStream(ZegoPublishChannel channel) {
        ZegoExpressEngineJni.stopPublishingStream(channel);
    }

    public void setStreamExtraInfo(String extraInfo, IZegoPublisherSetStreamExtraInfoCallback callback) {
        ZegoExpressEngineJni.setStreamExtraInfo(extraInfo, ZegoPublishChannel.MAIN, callback);
    }

    public void setStreamExtraInfo(String extraInfo, ZegoPublishChannel channel, IZegoPublisherSetStreamExtraInfoCallback callback) {
        ZegoExpressEngineJni.setStreamExtraInfo(extraInfo, channel, callback);
    }

    public void startPreview(ZegoCanvas canvas) {
        ZegoExpressEngineJni.startPreview(canvas, ZegoPublishChannel.MAIN);
    }

    public void startPreview(ZegoCanvas canvas, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.startPreview(canvas, channel);
    }

    public void stopPreview() {
        ZegoExpressEngineJni.stopPreview(ZegoPublishChannel.MAIN);
    }

    public void stopPreview(ZegoPublishChannel channel) {
        ZegoExpressEngineJni.stopPreview(channel);
    }

    public void setReverbParam(ZegoReverbParam param) {
        ZegoExpressEngineJni.setReverbParam(param);
    }

    public void enableVirtualStereo(boolean enable, int angle) {
        ZegoExpressEngineJni.enableVirtualStereo(enable, angle);
    }

    public void setVoiceChangerParam(ZegoVoiceChangerParam param) {
        ZegoExpressEngineJni.setVoiceChangerParam(param);
    }

    public void setVideoConfig(ZegoVideoConfig config) {
        ZegoExpressEngineJni.setVideoConfig(config, ZegoPublishChannel.MAIN);
    }

    public void setVideoConfig(ZegoVideoConfig config, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.setVideoConfig(config, channel);
    }

    public ZegoVideoConfig getVideoConfig() {
        return ZegoExpressEngineJni.getVideoConfig(ZegoPublishChannel.MAIN);
    }

    public ZegoVideoConfig getVideoConfig(ZegoPublishChannel channel) {
        return ZegoExpressEngineJni.getVideoConfig(channel);
    }

    public void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode) {
        ZegoExpressEngineJni.setVideoMirrorMode(mirrorMode, ZegoPublishChannel.MAIN);
    }

    public void setVideoMirrorMode(ZegoVideoMirrorMode mirrorMode, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.setVideoMirrorMode(mirrorMode, channel);
    }

    public void setAppOrientation(ZegoOrientation orientation) {
        ZegoExpressEngineJni.setAppOrientation(orientation, ZegoPublishChannel.MAIN);
    }

    public void setAppOrientation(ZegoOrientation orientation, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.setAppOrientation(orientation, channel);
    }

    public void setAudioConfig(ZegoAudioConfig config) {
        ZegoExpressEngineJni.setAudioConfig(config);
    }

    public ZegoAudioConfig getAudioConfig() {
        return ZegoExpressEngineJni.getAudioConfig();
    }

    public void mutePublishStreamAudio(boolean mute) {
        ZegoExpressEngineJni.mutePublishStreamAudio(mute, ZegoPublishChannel.MAIN);
    }

    public void mutePublishStreamAudio(boolean mute, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.mutePublishStreamAudio(mute, channel);
    }

    public void mutePublishStreamVideo(boolean mute) {
        ZegoExpressEngineJni.mutePublishStreamVideo(mute, ZegoPublishChannel.MAIN);
    }

    public void mutePublishStreamVideo(boolean mute, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.mutePublishStreamVideo(mute, channel);
    }

    public void enableTrafficControl(boolean enable, int property) {
        ZegoExpressEngineJni.enableTrafficControl(enable, property);
    }

    public void setMinVideoBitrateForTrafficControl(int bitrate, ZegoTrafficControlMinVideoBitrateMode mode) {
        ZegoExpressEngineJni.setMinVideoBitrateForTrafficControl(bitrate, mode);
    }

    public void setCaptureVolume(int volume) {
        ZegoExpressEngineJni.setCaptureVolume(volume);
    }

    public void addPublishCdnUrl(String streamID, String targetURL, IZegoPublisherUpdateCdnUrlCallback callback) {
        ZegoExpressEngineJni.addPublishCdnUrl(streamID, targetURL, callback);
    }

    public void removePublishCdnUrl(String streamID, String targetURL, IZegoPublisherUpdateCdnUrlCallback callback) {
        ZegoExpressEngineJni.removePublishCdnUrl(streamID, targetURL, callback);
    }

    public void enablePublishDirectToCDN(boolean enable, ZegoCDNConfig config) {
        ZegoExpressEngineJni.enablePublishDirectToCDN(enable, config, ZegoPublishChannel.MAIN);
    }

    public void enablePublishDirectToCDN(boolean enable, ZegoCDNConfig config, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.enablePublishDirectToCDN(enable, config, channel);
    }

    public void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible) {
        ZegoExpressEngineJni.setPublishWatermark(watermark, isPreviewVisible, ZegoPublishChannel.MAIN);
    }

    public void setPublishWatermark(ZegoWatermark watermark, boolean isPreviewVisible, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.setPublishWatermark(watermark, isPreviewVisible, channel);
    }

    public void sendSEI(byte[] data) {
        ZegoExpressEngineJni.sendSEI(data, ZegoPublishChannel.MAIN);
    }

    public void sendSEI(byte[] data, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.sendSEI(data, channel);
    }

    public void enableHardwareEncoder(boolean enable) {
        ZegoExpressEngineJni.enableHardwareEncoder(enable);
    }

    public void setCapturePipelineScaleMode(ZegoCapturePipelineScaleMode mode) {
        ZegoExpressEngineJni.setCapturePipelineScaleMode(mode);
    }

    public void startPlayingStream(String streamID, ZegoCanvas canvas) {
        ZegoExpressEngineJni.startPlayingStream(streamID, canvas, null);
    }

    public void startPlayingStream(String streamID, ZegoCanvas canvas, ZegoPlayerConfig config) {
        ZegoExpressEngineJni.startPlayingStream(streamID, canvas, config);
    }

    public void stopPlayingStream(String streamID) {
        ZegoExpressEngineJni.stopPlayingStream(streamID);
    }

    public void setPlayVolume(String streamID, int volume) {
        ZegoExpressEngineJni.setPlayVolume(streamID, volume);
    }

    public void mutePlayStreamAudio(String streamID, boolean mute) {
        ZegoExpressEngineJni.mutePlayStreamAudio(streamID, mute);
    }

    public void mutePlayStreamVideo(String streamID, boolean mute) {
        ZegoExpressEngineJni.mutePlayStreamVideo(streamID, mute);
    }

    public void enableHardwareDecoder(boolean enable) {
        ZegoExpressEngineJni.enableHardwareDecoder(enable);
    }

    public void enableCheckPoc(boolean enable) {
        ZegoExpressEngineJni.enableCheckPoc(enable);
    }

    public void startMixerTask(ZegoMixerTask task, IZegoMixerStartCallback callback) {
        ZegoExpressEngineJni.startMixerTask(task, callback);
    }

    public void stopMixerTask(ZegoMixerTask task, IZegoMixerStopCallback callback) {
        ZegoExpressEngineJni.stopMixerTask(task, callback);
    }

    public void muteMicrophone(boolean mute) {
        ZegoExpressEngineJni.muteMicrophone(mute);
    }

    public boolean isMicrophoneMuted() {
        return ZegoExpressEngineJni.isMicrophoneMuted();
    }

    public void muteSpeaker(boolean mute) {
        ZegoExpressEngineJni.muteSpeaker(mute);
    }

    public boolean isSpeakerMuted() {
        return ZegoExpressEngineJni.isSpeakerMuted();
    }

    public void enableAudioCaptureDevice(boolean enable) {
        ZegoExpressEngineJni.enableAudioCaptureDevice(enable);
    }

    public void setBuiltInSpeakerOn(boolean enable) {
        ZegoExpressEngineJni.setBuiltInSpeakerOn(enable);
    }

    public void enableCamera(boolean enable) {
        ZegoExpressEngineJni.enableCamera(enable, ZegoPublishChannel.MAIN);
    }

    public void enableCamera(boolean enable, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.enableCamera(enable, channel);
    }

    public void useFrontCamera(boolean enable) {
        ZegoExpressEngineJni.useFrontCamera(enable, ZegoPublishChannel.MAIN);
    }

    public void useFrontCamera(boolean enable, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.useFrontCamera(enable, channel);
    }

    public void startSoundLevelMonitor() {
        ZegoExpressEngineJni.startSoundLevelMonitor();
    }

    public void stopSoundLevelMonitor() {
        ZegoExpressEngineJni.stopSoundLevelMonitor();
    }

    public void startAudioSpectrumMonitor() {
        ZegoExpressEngineJni.startAudioSpectrumMonitor();
    }

    public void stopAudioSpectrumMonitor() {
        ZegoExpressEngineJni.stopAudioSpectrumMonitor();
    }

    public void enableHeadphoneMonitor(boolean enable) {
        ZegoExpressEngineJni.enableHeadphoneMonitor(enable);
    }

    public void setHeadphoneMonitorVolume(int volume) {
        ZegoExpressEngineJni.setHeadphoneMonitorVolume(volume);
    }

    public void enableAEC(boolean enable) {
        ZegoExpressEngineJni.enableAEC(enable);
    }

    public void enableHeadphoneAEC(boolean enable) {
        ZegoExpressEngineJni.enableHeadphoneAEC(enable);
    }

    public void setAECMode(ZegoAECMode mode) {
        ZegoExpressEngineJni.setAECMode(mode);
    }

    public void enableAGC(boolean enable) {
        ZegoExpressEngineJni.enableAGC(enable);
    }

    public void enableANS(boolean enable) {
        ZegoExpressEngineJni.enableANS(enable);
    }

    public void setANSMode(ZegoANSMode mode) {
        ZegoExpressEngineJni.setANSMode(mode);
    }

    public void enableAudioMixing(boolean enable) {
        ZegoExpressEngineJni.enableAudioMixing(enable);
    }

    public void setAudioMixingHandler(IZegoAudioMixingHandler handler) {
        ZegoExpressEngineJni.setAudioMixingHandler(handler);
    }

    public void muteLocalAudioMixing(boolean mute) {
        ZegoExpressEngineJni.muteLocalAudioMixing(mute);
    }

    public void setAudioMixingVolume(int volume) {
        ZegoExpressEngineJni.setAudioMixingVolume(volume);
    }

    public void setAudioMixingVolume(int volume, ZegoVolumeType type) {
        ZegoExpressEngineJni.setAudioMixingVolume(volume, type);
    }

    public void enableBeautify(int featureBitmask) {
        ZegoExpressEngineJni.enableBeautify(featureBitmask, ZegoPublishChannel.MAIN);
    }

    public void enableBeautify(int featureBitmask, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.enableBeautify(featureBitmask, channel);
    }

    public void setBeautifyOption(ZegoBeautifyOption option) {
        ZegoExpressEngineJni.setBeautifyOption(option, ZegoPublishChannel.MAIN);
    }

    public void setBeautifyOption(ZegoBeautifyOption option, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.setBeautifyOption(option, channel);
    }

    public void sendBroadcastMessage(String roomID, String message, IZegoIMSendBroadcastMessageCallback callback) {
        ZegoExpressEngineJni.sendBroadcastMessage(roomID, message, callback);
    }

    public void sendBarrageMessage(String roomID, String message, IZegoIMSendBarrageMessageCallback callback) {
        ZegoExpressEngineJni.sendBarrageMessage(roomID, message, callback);
    }

    public void sendCustomCommand(String roomID, String command, ArrayList<ZegoUser> toUserList, IZegoIMSendCustomCommandCallback callback) {
        ZegoExpressEngineJni.sendCustomCommand(roomID, command, toUserList, callback);
    }

    public ZegoMediaPlayer createMediaPlayer() {
        return ZegoMediaPlayerJni.createMediaPlayer();
    }

    public void destroyMediaPlayer(ZegoMediaPlayer mediaPlayer) {
        ZegoMediaPlayerJni.destroyMediaPlayer(mediaPlayer);
    }

    public void startRecordingCapturedData(ZegoDataRecordConfig config, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.startRecordingCapturedData(config, channel);
    }

    public void stopRecordingCapturedData(ZegoPublishChannel channel) {
        ZegoExpressEngineJni.stopRecordingCapturedData(channel);
    }

    public void setDataRecordEventHandler(IZegoDataRecordEventHandler eventHandler) {
        ZegoExpressEngineJni.setDataRecordEventHandler(eventHandler);
    }

    public void enableCustomVideoRender(boolean enable, ZegoCustomVideoRenderConfig config) {
        ZegoExpressEngineJni.enableCustomVideoRender(enable, config);
    }

    public void setCustomVideoRenderHandler(IZegoCustomVideoRenderHandler handler) {
        ZegoExpressEngineJni.setCustomVideoRenderHandler(handler);
    }

    public void enableCustomVideoCapture(boolean enable, ZegoCustomVideoCaptureConfig config) {
        ZegoExpressEngineJni.enableCustomVideoCapture(enable, config, ZegoPublishChannel.MAIN);
    }

    public void enableCustomVideoCapture(boolean enable, ZegoCustomVideoCaptureConfig config, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.enableCustomVideoCapture(enable, config, channel);
    }

    public void setCustomVideoCaptureHandler(IZegoCustomVideoCaptureHandler handler) {
        ZegoExpressEngineJni.setCustomVideoCaptureHandler(handler);
    }

    public void sendCustomVideoCaptureRawData(ByteBuffer data, int dataLength, ZegoVideoFrameParam params, long referenceTimeMillisecond) {
        ZegoExpressEngineJni.sendCustomVideoCaptureRawData(data, dataLength, params, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }

    public void sendCustomVideoCaptureRawData(ByteBuffer data, int dataLength, ZegoVideoFrameParam params, long referenceTimeMillisecond, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.sendCustomVideoCaptureRawData(data, dataLength, params, referenceTimeMillisecond, channel);
    }

    public void sendCustomVideoCaptureTextureData(int textureID, int width, int height, double referenceTimeMillisecond) {
        ZegoExpressEngineJni.sendCustomVideoCaptureTextureData(textureID, width, height, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }

    public void sendCustomVideoCaptureTextureData(int textureID, int width, int height, double referenceTimeMillisecond, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.sendCustomVideoCaptureTextureData(textureID, width, height, referenceTimeMillisecond, channel);
    }

    public SurfaceTexture getCustomVideoCaptureSurfaceTexture() {
        return ZegoExpressEngineJni.getCustomVideoCaptureSurfaceTexture();
    }

    public SurfaceTexture getCustomVideoCaptureSurfaceTexture(ZegoPublishChannel channel) {
        return ZegoExpressEngineJni.getCustomVideoCaptureSurfaceTexture(channel);
    }

    public void sendCustomVideoCaptureEncodedData(ByteBuffer data, int dataLength, ZegoVideoEncodedFrameParam params, long referenceTimeMillisecond) {
        ZegoExpressEngineJni.sendCustomVideoCaptureEncodedData(data, dataLength, params, referenceTimeMillisecond, ZegoPublishChannel.MAIN);
    }

    public void sendCustomVideoCaptureEncodedData(ByteBuffer data, int dataLength, ZegoVideoEncodedFrameParam params, long referenceTimeMillisecond, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.sendCustomVideoCaptureEncodedData(data, dataLength, params, referenceTimeMillisecond, channel);
    }

    public void setCustomVideoCaptureFillMode(ZegoViewMode mode) {
        ZegoExpressEngineJni.setCustomVideoCaptureFillMode(mode.value(), ZegoPublishChannel.MAIN);
    }

    public void setCustomVideoCaptureFillMode(ZegoViewMode mode, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.setCustomVideoCaptureFillMode(mode.value(), channel);
    }

    public void enableAudioDataCallback(boolean enable, int callbackBitMask, ZegoAudioFrameParam param) {
        ZegoExpressEngineJni.enableAudioDataCallback(enable, callbackBitMask, param);
    }

    public void setAudioDataHandler(IZegoAudioDataHandler handler) {
        ZegoExpressEngineJni.setAudioDataHandler(handler);
    }

    public void enableCustomAudioIO(boolean enable, ZegoCustomAudioConfig config) {
        ZegoExpressEngineJni.enableCustomAudioIO(enable, config, ZegoPublishChannel.MAIN);
    }

    public void enableCustomAudioIO(boolean enable, ZegoCustomAudioConfig config, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.enableCustomAudioIO(enable, config, channel);
    }

    public void sendCustomAudioCaptureAACData(ByteBuffer data, int dataLength, int configLength, long referenceTimeMillisecond, ZegoAudioFrameParam param) {
        ZegoExpressEngineJni.sendCustomAudioCaptureAACData(data, dataLength, configLength, referenceTimeMillisecond, param, ZegoPublishChannel.MAIN);
    }

    public void sendCustomAudioCaptureAACData(ByteBuffer data, int dataLength, int configLength, long referenceTimeMillisecond, ZegoAudioFrameParam param, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.sendCustomAudioCaptureAACData(data, dataLength, configLength, referenceTimeMillisecond, param, channel);
    }

    public void sendCustomAudioCapturePCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param) {
        ZegoExpressEngineJni.sendCustomAudioCapturePCMData(data, dataLength, param, ZegoPublishChannel.MAIN);
    }

    public void sendCustomAudioCapturePCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param, ZegoPublishChannel channel) {
        ZegoExpressEngineJni.sendCustomAudioCapturePCMData(data, dataLength, param, channel);
    }

    public void fetchCustomAudioRenderPCMData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param) {
        ZegoExpressEngineJni.fetchCustomAudioRenderPCMData(data, dataLength, param);
    }

    @Deprecated
    public static void destroyEngine() {
        ZegoExpressEngineJni.destroyEngine(null);
    }

    @Deprecated
    public void muteAudioOutput(boolean mute) {
        ZegoExpressEngineJni.muteAudioOutput(mute);
    }
}

