package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

/**
 * Advanced engine configuration
 *
 * When you need to use the advanced functions of SDK, such as custom video capture, custom video rendering and other advanced functions, you need to set the instance corresponding to the advanced function configuration to the corresponding field of this type of instance to achieve the purpose of enabling the corresponding advanced functions of ZegoExpressEngine.
 * The configuration of the corresponding advanced functions needs to be set before [createEngine], and it is invalid to set after [createEngine].
 */
public class ZegoEngineConfig {

    /** Log configuration, if not set, use the default configuration. It must be valid before [createEngine], if it is set after SDK initialization, it will take effect the next time [createEngine]. */
    public ZegoLogConfig logConfig;

    /** @deprecated This configuration is deprecated after 1.9.0. Please use the ZegoExpressEngine's [enableCustomVideoCapture] method instead */
    @Deprecated
    public ZegoCustomVideoCaptureConfig customVideoCaptureMainConfig;

    /** @deprecated This configuration is deprecated after 1.9.0. Please use the ZegoExpressEngine's [enableCustomVideoCapture] method instead */
    @Deprecated
    public ZegoCustomVideoCaptureConfig customVideoCaptureAuxConfig;

    /** @deprecated This configuration is deprecated after 1.9.0. Please use the ZegoExpressEngine's [enableCustomVideoRender] method instead */
    @Deprecated
    public ZegoCustomVideoRenderConfig customVideoRenderConfig;

    /** Other special function switches, if not set, no other special functions are used by default. Please contact ZEGO technical support before use. */
    public HashMap<String, String> advancedConfig = new HashMap<>();

    /** Dynamic library path. For developers who need to dynamically load so, the default is empty string. Use project packaged so */
    public String soFullPath;

    public ZegoEngineConfig(){
        logConfig = new ZegoLogConfig();
        soFullPath = "";
    }

}
