package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoDataRecordEventHandler {

    /**
     * State update callback for recording to a file, triggered when the state of the recording state changes.
     *
     * @param state File recording status, according to which you should determine the state of the file recording or the prompt of the UI.
     * @param errorCode Error code, please refer to the common error code document [https://doc-en.zego.im/en/308.html] for details
     * @param config Record config
     * @param channel Publishing stream channel
     */
    public void onCapturedDataRecordStateUpdate(ZegoDataRecordState state, int errorCode, ZegoDataRecordConfig config, ZegoPublishChannel channel){

    }

    /**
     * Recording progress update
     *
     * @param progress File recording progress, which allows developers to hint at the UI, etc.
     * @param config Record config
     * @param channel Publishing stream channel
     */
    public void onCapturedDataRecordProgressUpdate(ZegoDataRecordProgress progress, ZegoDataRecordConfig config, ZegoPublishChannel channel){

    }

}

