package im.zego.zegoexpress.callback;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

public abstract class IZegoAudioDataHandler {

    /**
     * Callback for audio data collected by the local microphone.
     *
     * In non-custom audio capture mode, the SDK capture the microphone's sound, but the developer may also need to get a copy of the The audio data captured by the SDK SDK is available through this callback.
     * On the premise of calling [setAudioDataHandler] to set the listener callback, after calling [enableAudioDataCallback] to set the mask 0x01, this callback will be triggered only when it is in the publishing stream state.
     *
     * @param data audio data of pcm format
     * @param dataLength length of data
     * @param param 音频帧参数
     */
    public void onCapturedAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param){

    }

    /**
     * Callback for audio data of all playing stream.
     *
     * This method will callback all of the remote user's audio mix data. This callback can be used for that you needs to fetch all the playing streams to proccess.
     * On the premise of calling [setAudioDataHandler] to set the listener callback, after calling [enableAudioDataCallback] to set the mask 0x02, this callback will be triggered only when it is in the playing stream state.
     *
     * @param data audio data of pcm format
     * @param dataLength length of data
     * @param param 音频帧参数
     */
    public void onRemoteAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param){

    }

    /**
     * Callback for the audio data of all the streams pulled and the audio data captured by the local microphone that was mixed by the SDK.
     *
     * The audio data of all playing data is mixed with the data captured by the local microphone before it is sent to the loudspeaker, and calleback out in this way.
     * On the premise of calling [setAudioDataHandler] to set the listener callback, after calling [enableAudioDataCallback] to set the mask 0x04, this callback will be triggered only when it is in the publishing stream state or playing stream state.
     *
     * @param data audio data of pcm format
     * @param dataLength length of data
     * @param param 音频帧参数
     */
    public void onMixedAudioData(ByteBuffer data, int dataLength, ZegoAudioFrameParam param){

    }

}

