
package im.zego.zegoexpress;

final public class ZegoExpressErrorCode{

    /** 执行成功 */
    final static public int CommonSuccess                                      = 0;

    /** 未初始化引擎，在调用非静态方法前需要先初始化引擎 */
    final static public int CommonEngineNotCreate                              = 1000001;

    /** 未登陆房间, 在调用推流或拉流前，请先登陆房间 */
    final static public int CommonNotLoginRoom                                 = 1000002;

    /** 引擎未启动，请先调用预览/推流/拉流接口 */
    final static public int CommonEngineNotStarted                             = 1000003;

    /** 调用了当前平台不支持的接口, 例如在非 Android 平台调用了设置 Android 上下文环境的接口 */
    final static public int CommonUnsupportedPlatform                          = 1000006;

    /** 无效的 Android 上下文环境 */
    final static public int CommonInvalidAndroidEnvironment                    = 1000007;

    /** 已调用 `setEventHandler` 设置了 handler，请勿重复设置；若需要重复设置，请先调用 `setEventHandler` 将之前的 handler 置空 */
    final static public int CommonEventHandlerExists                           = 1000008;

    /** 此 SDK 没有包含此模块功能，请联系技术支持提供 */
    final static public int CommonSdkNoModule                                  = 1000010;

    /** 输入流 ID 超长, 最大支持输入 256 个字符 */
    final static public int CommonStreamIdTooLong                              = 1000014;

    /** 输入流 ID 为空 */
    final static public int CommonStreamIdNull                                 = 1000015;

    /** 输入流 ID 包含非法字符 */
    final static public int CommonStreamIdInvalidCharacter                     = 1000016;

    /** 该 AppID 已经下线 */
    final static public int CommonAppOfflineError                              = 1000037;

    /** 后台配置有错误，请检查 APP 配置项 */
    final static public int CommonAppFlexiableConfigError                      = 1000038;

    /** CDN 地址有误，请检查支持的协议和格式 */
    final static public int CommonCdnUrlInvalid                                = 1000055;

    /** DNS 解析失败，请检查网络配置 */
    final static public int CommonDnsResolveError                              = 1000060;

    /** 服务器调度异常，请联系技术支持解决 */
    final static public int CommonDispatchError                                = 1000065;

    /** 内部空指针错误，请联系技术支持解决 */
    final static public int CommonInnerNullptr                                 = 1000090;

    /** AppID 不能为 0，请检查 AppID 是否正确 */
    final static public int EngineAppidZero                                    = 1001000;

    /** 输入 AppSign 长度必须为 64 字节 */
    final static public int EngineAppsignInvalidLength                         = 1001001;

    /** 输入 AppSign 包含非法字符, 仅支持'0'-'9','a'-'f','A'-'F' */
    final static public int EngineAppsignInvalidCharacter                      = 1001002;

    /** 输入 AppSign 为空 */
    final static public int EngineAppsignNull                                  = 1001003;

    /** 认证失败，请检查 AppID 是否正确；或是否在没有向 ZEGO 申请上线的情况下选择了正式环境初始化 */
    final static public int EngineAppidIncorrectOrNotOnline                    = 1001004;

    /** AppSign 认证失败，请检查 AppSign 是否正确 */
    final static public int EngineAppsignIncorrect                             = 1001005;

    /** 日志没有写入权限 */
    final static public int EngineLogNoWritePermission                         = 1001014;

    /** 输入日志的路径超长 */
    final static public int EngineLogPathTooLong                               = 1001015;

    /** 登陆房间数量超过上限，当前仅支持同时登陆 1 个房间 */
    final static public int RoomCountExceed                                    = 1002001;

    /** 输入用户 ID 为空 */
    final static public int RoomUserIdNull                                     = 1002005;

    /** 输入用户 ID 包含非法字符 */
    final static public int RoomUserIdInvalidCharacter                         = 1002006;

    /** 输入用户 ID 超长，最大支持输入 64 个字符 */
    final static public int RoomUserIdTooLong                                  = 1002007;

    /** 输入用户名为空 */
    final static public int RoomUserNameNull                                   = 1002008;

    /** 输入用户名包含非法字符 */
    final static public int RoomUserNameInvalidCharacter                       = 1002009;

    /** 输入用户 ID 超长，最大支持输入 256 个字符 */
    final static public int RoomUserNameTooLong                                = 1002010;

    /** 输入房间 ID 为空 */
    final static public int RoomRoomidNull                                     = 1002011;

    /** 输入房间 ID 包含非法字符 */
    final static public int RoomRoomidInvalidCharacter                         = 1002012;

    /** 输入房间 ID 超长，最大支持输入 128 个字符 */
    final static public int RoomRoomidTooLong                                  = 1002013;

    /** 登陆房间失败，可能是由于网络原因 */
    final static public int RoomErrorConnectFailed                             = 1002030;

    /** 登陆房间超时，可能是由于网络原因 */
    final static public int RoomErrorLoginTimeout                              = 1002031;

    /** 登陆房间鉴权失败 */
    final static public int RoomErrorAuthenticationFailed                      = 1002033;

    /** 登陆房间的用户数超过该房间配置的最大用户数量限制 */
    final static public int RoomErrorExceedMaximumMember                       = 1002034;

    /** 用户被踢出房间，可能是相同用户 ID 在其他设备登陆 */
    final static public int RoomKickedOut                                      = 1002050;

    /** 网络原因导致房间连接临时中断，正在重试 */
    final static public int RoomConnectTemporaryBroken                         = 1002051;

    /** 房间连接断开，可能是由于网络原因导致 */
    final static public int RoomDisconnect                                     = 1002052;

    /** 重试登录房间超过最大的重试时间 */
    final static public int RoomRetryTimeout                                   = 1002053;

    /** 业务后台发出了踢出房间信令，请查看被踢原因 */
    final static public int RoomManualKickedOut                                = 1002055;

    /** 系统内部异常导致房间登陆失败 */
    final static public int RoomInnerError                                     = 1002099;

    /** 推流失败，有可能是推流没有数据 */
    final static public int PublisherPublishStreamFailed                       = 1003001;

    /** 码率设置有误，请检查单位(kbps)是否有误 */
    final static public int PublisherBitrateInvalid                            = 1003002;

    /** 推流流控参数设置有误 */
    final static public int PublisherTrafficModeInvalid                        = 1003005;

    /** 推流临时中断，正在重试 */
    final static public int PublisherErrorNetworkInterrupt                     = 1003020;

    /** 推流失败，该用户已在推流 */
    final static public int PublisherErrorAlreadyDoPublish                     = 1003023;

    /** 推流失败，该流被后台系统配置为禁止推送 */
    final static public int PublisherErrorServerForbid                         = 1003025;

    /** 推流失败，房间内已有相同的流 */
    final static public int PublisherErrorRepetitivePublishStream              = 1003028;

    /** 与 RTMP 服务器连接中断，请检查网络或推流地址是否异常 */
    final static public int PublisherRtmpServerDisconnect                      = 1003029;

    /** 更新转推 CDN 状态失败，请检测 URL 是否合法 */
    final static public int PublisherUpdateCdnTargetError                      = 1003040;

    /** 发送 SEI 失败，data 为空 */
    final static public int PublisherSeiDataNull                               = 1003043;

    /** 发送 SEI 失败，data 超长，最大支持 4096 个字符 */
    final static public int PublisherSeiDataTooLong                            = 1003044;

    /** 流附加信息为空 */
    final static public int PublisherExtraInfoNull                             = 1003050;

    /** 流附加信息超长，最大为 1024 个字符 */
    final static public int PublisherExtraInfoTooLong                          = 1003051;

    /** 更新流附加信息失败，请检查网络连接 */
    final static public int PublisherUpdateExtraInfoFailed                     = 1003053;

    /** 推流水印路径为空 */
    final static public int PublisherWatermarkUrlNull                          = 1003055;

    /** 推流水印路径超长，最大为 1024 个字符 */
    final static public int PublisherWatermarkUrlTooLong                       = 1003056;

    /** 推流水印格式错误，仅支持 jpg 和 png 格式 */
    final static public int PublisherWatermarkUrlInvalid                       = 1003057;

    /** 推流水印布局有误，布局区域不能超出编码分辨率大小 */
    final static public int PublisherWatermarkLayoutInvalid                    = 1003058;

    /** 系统内部异常导致推流失败 */
    final static public int PublisherInnerError                                = 1003099;

    /** 推流失败，有可能是拉流没有数据 */
    final static public int PlayerPlayStreamFailed                             = 1004001;

    /** 拉流超过最大的数量，目前支持最多 12 路拉流（如有需要可联系技术支持扩容） */
    final static public int PlayerCountExceed                                  = 1004010;

    /** 拉流临时中断，正在重试 */
    final static public int PlayerErrorNetworkInterrupt                        = 1004020;

    /** 系统内部异常导致拉流失败 */
    final static public int PlayerInnerError                                   = 1004099;

    /** 无混流服务，请联系技术支持开启 */
    final static public int MixerNoServices                                    = 1005000;

    /** 混流任务 ID 为空 */
    final static public int MixerTaskIdNull                                    = 1005001;

    /** 混流任务 ID 超长，最大为 256 个字符 */
    final static public int MixerTaskIdTooLong                                 = 1005002;

    /** 混流任务 ID 中含有非法字符 */
    final static public int MixerTaskIdInvalidCharacter                        = 1005003;

    /** 混流任务配置未指定输出 */
    final static public int MixerNoOutputTarget                                = 1005005;

    /** 混流输出目标有误，请检查是否 target 为 streamID 时，传入了非法字符 */
    final static public int MixerOutputTargetInvalid                           = 1005006;

    /** 启动混流任务请求失败，可能是由于网络原因 */
    final static public int MixerStartRequestError                             = 1005010;

    /** 停止混流任务请求失败，可能是由于网络原因 */
    final static public int MixerStopRequestError                              = 1005011;

    /** 该混流任务必须由该任务的启动用户执行停止操作 */
    final static public int MixerNotOwnerStopMixer                             = 1005012;

    /** 混流任务启动过于频繁 */
    final static public int MixerStartQpsOverload                              = 1005015;

    /** 混流任务停止过于频繁 */
    final static public int MixerStopQpsOverload                               = 1005016;

    /** 混流任务输入流列表为空 */
    final static public int MixerInputListInvalid                              = 1005020;

    /** 混流任务输出列表为空 */
    final static public int MixerOutputListInvalid                             = 1005021;

    /** 混流任务视频配置无效 */
    final static public int MixerVideoConfigInvalid                            = 1005023;

    /** 混流任务音频配置无效，请检查是否使用了不支持的编解码 */
    final static public int MixerAudioConfigInvalid                            = 1005024;

    /** 超过最大的输入流数量，最大支持 9 个输入流 */
    final static public int MixerExceedMaxInputCount                           = 1005025;

    /** 输入流不存在 */
    final static public int MixerInputStreamNotExists                          = 1005026;

    /** 混流输入参数错误，可能是输入流的布局超过画布范围 */
    final static public int MixerInputParametersError                          = 1005027;

    /** 超过最大的输出流数量，最大支持 3 个输出流 */
    final static public int MixerExceedMaxOutputCount                          = 1005030;

    /** 混流认证失败 */
    final static public int MixerAuthenticationFailed                          = 1005050;

    /** 输入水印为空 */
    final static public int MixerWatermarkNull                                 = 1005061;

    /** 输入水印参数错误，可能是布局超过画布范围 */
    final static public int MixerWatermarkParametersError                      = 1005062;

    /** 输入水印 URL 非法，必须以 `preset-id://` 开头且需要是 `.jpg` 或 `.png` 结尾 */
    final static public int MixerWatermarkUrlInvalid                           = 1005063;

    /** 输入背景图 URL 非法，必须以 preset-id://开头且需要是 `.jpg` 或 `.png` 结尾 */
    final static public int MixerBackgroundImageUrlInvalid                     = 1005067;

    /** 未找到自动混流服务器，请联系技术支持配置 */
    final static public int MixerAutoMixStreamServerNotFound                   = 1005070;

    /** 混流内部错误 */
    final static public int MixerInnerError                                    = 1005099;

    /** 设备一般错误 */
    final static public int DeviceErrorTypeGeneric                             = 1006001;

    /** 设备 ID 不存在 */
    final static public int DeviceErrorTypeInvalidId                           = 1006002;

    /** 没有设备权限，请检查摄像头或麦克风的权限 */
    final static public int DeviceErrorTypeNoAuthorization                     = 1006003;

    /** 设备采集帧率为 0 */
    final static public int DeviceErrorTypeZeroFps                             = 1006004;

    /** 设备被占用 */
    final static public int DeviceErrorTypeInUseByOther                        = 1006005;

    /** 设备被拔出 */
    final static public int DeviceErrorTypeUnplugged                           = 1006006;

    /** 设备需要重启 */
    final static public int DeviceErrorTypeRebootRequired                      = 1006007;

    /** 设备媒体丢失 */
    final static public int DeviceErrorMediaServicesLost                       = 1006008;

    /** 释放释放设备列表时，列表为空 */
    final static public int DeviceFreeDeviceListNull                           = 1006020;

    /** 设备内部错误 */
    final static public int DeviceInnerError                                   = 1006099;

    /** 前处理模块未知错误，请联系 ZEGO 技术人员 */
    final static public int PreprocessPreprocessUnknownError                   = 1007001;

    /** 美颜参数非法，请检查传入的参数 */
    final static public int PreprocessBeautifyOptionInvalid                    = 1007005;

    /** 混响参数为 null，请检查传入的混响参数 */
    final static public int PreprocessReverbParamNull                          = 1007006;

    /** 变声器参数为 null，请检查传入的变声器参数 */
    final static public int PreprocessVoiceChangerParamNull                    = 1007007;

    /** 混响 room size 参数非法，正常范围 0.0 ~ 1.0 */
    final static public int PreprocessReverbParamRoomSizeInvalid               = 1007011;

    /** 混响 reverberance 参数非法，正常范围 0.0 ~ 0.5 */
    final static public int PreprocessReverbParamReverberanceInvalid           = 1007012;

    /** 混响 damping 参数非法，正常范围 0.0 ~ 2.0 */
    final static public int PreprocessReverbParamDampingInvalid                = 1007013;

    /** 混响 dry_wet_ratio 参数非法，正常范围 > 0.0 */
    final static public int PreprocessReverbParamDryWetRatioInvalid            = 1007014;

    /** 虚拟立体声 angle 参数非法，正常范围 0 ~ 180 */
    final static public int PreprocessVirtualStereoAngleInvalid                = 1007015;

    /** 变声参数非法，正常范围 -8.0 ~ 8.0 */
    final static public int PreprocessVoiceChangerParamInvalid                 = 1007016;

    /** 没有创建该媒体播放器实例 */
    final static public int MediaPlayerNoInstance                              = 1008001;

    /** 媒体播放器播放失败，未加载资源文件 */
    final static public int MediaPlayerNoFilePath                              = 1008003;

    /** 媒体播放器载入文件失败，不支持该格式文件 */
    final static public int MediaPlayerFileFormatError                         = 1008005;

    /** 媒体播放器载入文件失败，路径不存在 */
    final static public int MediaPlayerFilePathNotExists                       = 1008006;

    /** 媒体播放器载入文件失败，解码错误 */
    final static public int MediaPlayerFileDecodeError                         = 1008007;

    /** 媒体播放器载入文件失败，无可播放的音视频流 */
    final static public int MediaPlayerFileNoSupportedStream                   = 1008008;

    /** 媒体播放器播放失败，文件解析过程中出现错误 */
    final static public int MediaPlayerDemuxError                              = 1008010;

    /** 媒体播放器 Seek 失败，可能是还没加载文件 */
    final static public int MediaPlayerSeekError                               = 1008016;

    /** 媒体播放器设置了该平台不支持的视频数据格式（如 iOS 平台下 CVPixelBuffer 不支持 NV21） */
    final static public int MediaPlayerPlatformFormatNotSupported              = 1008020;

    /** 媒体播放器创建实例超过最大限制，最多可创建 4 个实例 */
    final static public int MediaPlayerExceedMaxCount                          = 1008030;

    /** 媒体播放器内部错误 */
    final static public int MediaPlayerInnerError                              = 1008099;

    /** 输入消息内容为空 */
    final static public int IMContentNull                                      = 1009001;

    /** 输入消息内容超长，最长为 1024 字节 */
    final static public int IMContentTooLong                                   = 1009002;

    /** 发送消息失败，可能是由于网络原因 */
    final static public int IMSendFailed                                       = 1009010;

    /** 文件名后缀不支持，目前只支持 .mp4 或 .flv 文件名后缀，SDK 内部需要根据文件名后缀设置指定的录制格式 */
    final static public int RecorderFileSuffixNameFormatNotSupport             = 1010002;

    /** 录制接口通用错误，一般为所传参数不合法 */
    final static public int RecorderCommonLiveroomApiError                     = 1010003;

    /** 指定录制文件路径太长 */
    final static public int RecorderFilePathTooLong                            = 1010011;

    /** SDK 内部 VE 错误，请联系 ZEGO 技术人员解决 */
    final static public int RecorderInnerVeError                               = 1010012;

    /** 打开文件失败，不是合法的路径或没有文件权限 */
    final static public int RecorderOpenFileFailed                             = 1010013;

    /** 写文件失败，可能是无写入文件权限 */
    final static public int RecorderWriteFileError                             = 1010014;

    /** 剩余容量不够 */
    final static public int RecorderNoEnoughSpareCapacity                      = 1010017;

    /** 文件句柄异常 */
    final static public int RecorderFileHandleExceptions                       = 1010018;

    /** 输入输出异常 */
    final static public int RecorderIoExceptions                               = 1010019;

    /** 自定义视频采集器未创建，请确保在收到 OnStart 回调后使用 */
    final static public int CustomVideoIOCapturerNotCreated                    = 1011001;

    /** 自定义视频采集模块未开启，请确保在初始化配置中已开启自定义视频采集 */
    final static public int CustomVideoIONoCustomVideoCapture                  = 1011002;

    /** 设置自定义采集/渲染失败，请确保在引擎启动前调用（确保在 `startPreview`/`startPublishingStream`/`startPlayingStream` 之前调用） */
    final static public int CustomVideoIOEnableCustomIoFailed                  = 1011003;

    /** 当前设置的自定义视频采集格式不支持该 API */
    final static public int CustomVideoIONotSupportedFormat                    = 1011010;

    /** 自定义视频渲染不支持当前设置的视频数据类型 */
    final static public int CustomVideoIONotSupportedBufferType                = 1011011;

    /** 不支持的自定义音频采集源类型 */
    final static public int CustomAudioIOUnsupportedAudioSourceType            = 1012001;

    /** 自定义音频采集功能未开启，请确保已开启指定推流通道的自定义音频 IO 功能 */
    final static public int CustomAudioIOCapturerNotCreated                    = 1012002;

    /** 自定义音频渲染功能未开启，请确保已开启自定义音频 IO 功能 */
    final static public int CustomAudioIORendererNotCreated                    = 1012003;

    /** 设置自定义音频采集和渲染失败，请确保在引擎启动前调用（确保在 `startPreview`/`startPublishingStream`/`startPlayingStream` 之前调用） */
    final static public int CustomAudioIOEnableCustomAudioIoFailed             = 1012004;


}
