/*
 * Decompiled with CFR 0.152.
 */
package com.zego.ve;

import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.view.Choreographer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;

@TargetApi(value=16)
public class VClk {
    private static final String TAG = "VClk";
    private static final int MESSAGE_START = 0;
    private static final int MESSAGE_STOP = 1;
    private static final int MESSAGE_RESTART = 2;
    private HandlerThread mThread = new HandlerThread("VClk");
    private EventHandler mCallback = null;
    private Handler mHandler = null;
    private long pThis = 0L;
    private static VClk sInstance = new VClk();

    private static VClk getInstance() {
        return sInstance;
    }

    VClk() {
        this.mThread.start();
        this.mCallback = new EventHandler();
        this.mHandler = new Handler(this.mThread.getLooper(), (Handler.Callback)this.mCallback);
    }

    public int start(long l) {
        this.pThis = l;
        return 0;
    }

    public int stop(long l) {
        this.mHandler.removeCallbacksAndMessages(null);
        this.pThis = 0L;
        return 0;
    }

    public int startClock() {
        if (this.pThis != 0L) {
            this.mCallback.init(this.pThis);
            this.mHandler.sendEmptyMessage(0);
        }
        return 0;
    }

    public int restartClock() {
        if (this.pThis != 0L) {
            this.mHandler.sendEmptyMessage(2);
        }
        return 0;
    }

    public int stopClock() {
        if (this.pThis != 0L) {
            this.mHandler.sendEmptyMessage(1);
            this.mCallback.uninit();
        }
        return 0;
    }

    private static native int on_video_tick(long var0, long var2);

    private static native int on_error(long var0);

    private static class EventHandler
    implements Handler.Callback,
    Choreographer.FrameCallback {
        private AtomicLong mAtomicThis = new AtomicLong();
        private boolean mRunning = false;

        private EventHandler() {
        }

        public void init(long l) {
            this.mAtomicThis.set(l);
        }

        public void uninit() {
            this.mAtomicThis.set(0L);
        }

        public boolean handleMessage(Message message) {
            block25: {
                if (message.what == 0) {
                    if (!this.mRunning) {
                        this.mRunning = true;
                        try {
                            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            long l = this.mAtomicThis.get();
                            if (l != 0L) {
                                VClk.on_error(l);
                            }
                        }
                    }
                } else if (message.what == 1) {
                    if (this.mRunning) {
                        this.mRunning = false;
                        try {
                            Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
                            if (Build.VERSION.SDK_INT >= 28) break block25;
                            if (Build.VERSION.SDK_INT >= 24) {
                                try {
                                    Method method = Choreographer.class.getMethod("releaseInstance", new Class[0]);
                                    method.invoke(null, new Object[0]);
                                }
                                catch (NoSuchMethodException noSuchMethodException) {
                                    noSuchMethodException.printStackTrace();
                                }
                                catch (IllegalAccessException illegalAccessException) {
                                    illegalAccessException.printStackTrace();
                                }
                                catch (InvocationTargetException invocationTargetException) {
                                    invocationTargetException.printStackTrace();
                                }
                                break block25;
                            }
                            if (Build.VERSION.SDK_INT < 16) break block25;
                            Choreographer choreographer = Choreographer.getInstance();
                            try {
                                Field field = Choreographer.class.getDeclaredField("sThreadInstance");
                                field.setAccessible(true);
                                ThreadLocal threadLocal = (ThreadLocal)field.get(null);
                                threadLocal.remove();
                                Field field2 = Choreographer.class.getDeclaredField("mDisplayEventReceiver");
                                field2.setAccessible(true);
                                Object object = field2.get(choreographer);
                                Method method = object.getClass().getMethod("dispose", new Class[0]);
                                method.invoke(object, new Object[0]);
                            }
                            catch (NoSuchFieldException noSuchFieldException) {
                                noSuchFieldException.printStackTrace();
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                noSuchMethodException.printStackTrace();
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                illegalAccessException.printStackTrace();
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                invocationTargetException.printStackTrace();
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                            }
                        }
                        catch (Exception exception) {}
                    }
                } else if (message.what == 2) {
                    try {
                        Choreographer.getInstance().removeFrameCallback((Choreographer.FrameCallback)this);
                        Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return false;
        }

        public void doFrame(long l) {
            if (!this.mRunning) {
                return;
            }
            long l2 = this.mAtomicThis.get();
            if (l2 == 0L) {
                return;
            }
            VClk.on_video_tick(l2, l);
            Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)this);
        }
    }
}

