package im.zego.zegoexpress.entity;

import im.zego.zegoexpress.constants.*;
import im.zego.zegoexpress.callback.*;
import im.zego.zegoexpress.entity.*;
import java.nio.*;
import java.util.*;
import org.json.*;
import im.zego.zegoexpress.*;
import android.app.Application;
import android.graphics.*;

/**
 * Audio reverberation parameters
 *
 * Developers can use the SDK's built-in presets to change the parameters of the reverb.
 */
public class ZegoReverbParam {

    /** Reverb Damping, range [0.0, 2.0], controls the attenuation of the reverb, the higher the damping, the higher the attenuation. */
    public float damping;

    /** Dry to wet ratio, with a range of values equal to or greater than 0.0. To control the ratio of reverberation to direct and early reflections, the dry ( When the wet/dry part is set to 1 by default, when the wet/dry ratio is set to smaller, the proportion of wet is larger, and the reverberation is stronger at this time. */
    public float dryWetRatio;

    /** Echo, in the range [0.0, 0.5], to control the trailing length of the reverb. */
    public float reverberance;

    /** Room size, range [0.0, 1.0], to control the size of the "room" where the reverb will be generated, the more the room is, the more the reverb will be in the room. // Bigger, stronger reverb */
    public float roomSize;

    /**
     * Create rever changer configuration with preset enumeration values
     */
    public ZegoReverbParam(ZegoReverbPreset preset){
        if (preset == ZegoReverbPreset.SOFT_ROOM) {
            this.roomSize = 0.6f;
            this.reverberance = 0.03f;
            this.damping = 0.25f;
            this.dryWetRatio = 2.5f;
        } else if (preset == ZegoReverbPreset.LARGE_ROOM) {
            this.roomSize = 0.65f;
            this.reverberance = 0.03f;
            this.damping = 0.25f;
            this.dryWetRatio = 0.94f;
        } else if (preset == ZegoReverbPreset.CONCER_HALL) {
            this.roomSize = 0.8f;
            this.reverberance = 0.03f;
            this.damping = 0.25f;
            this.dryWetRatio = 1.1f;
        } else if (preset == ZegoReverbPreset.VALLEY) {
            this.roomSize = 0.85f;
            this.reverberance = 0.03f;
            this.damping = 0.25f;
            this.dryWetRatio = 0.92f;
        } else if (preset == ZegoReverbPreset.NONE) {
            this.roomSize = 0f;
            this.reverberance = 0f;
            this.damping = 0f;
            this.dryWetRatio = 0f;
        } else if (preset == null) {
            this.roomSize = 0f;
            this.reverberance = 0f;
            this.damping = 0f;
            this.dryWetRatio = 0f;
        }
    }

    public ZegoReverbParam(){
        this(ZegoReverbPreset.NONE);
    }

}
