
package im.zego.zegoexpress;

final public class ZegoExpressErrorCode{

    /** Execution successful. */
    final static public int CommonSuccess                                      = 0;

    /** Engine not yet created. Please create the engine first before calling non-static functions. */
    final static public int CommonEngineNotCreate                              = 1000001;

    /** Not yet logged in to any room. Please log in to a room before publishing or playing streams. */
    final static public int CommonNotLoginRoom                                 = 1000002;

    /** Engine not yet started. Please call `startPreviewView`, `startPublishing`, or `startPlayingStream` to get the engine started first. */
    final static public int CommonEngineNotStarted                             = 1000003;

    /** An API not supported by the current platform is called; for example, an API that sets the Android context is called on a non-Android platform. */
    final static public int CommonUnsupportedPlatform                          = 1000006;

    /** Invalid Android context. */
    final static public int CommonInvalidAndroidEnvironment                    = 1000007;

    /** The event handler has already been set by calling `setEventHandler`. Please do not repeat the setting. If you do need to set up the event handler again, please call `setEventHandler` to set it to null first before applying the new setting. */
    final static public int CommonEventHandlerExists                           = 1000008;

    /** This feature is not included in the SDK. Please contact ZEGO technical support. */
    final static public int CommonSdkNoModule                                  = 1000010;

    /** The input stream ID is too long. The maximum length allowed is 256 characters. */
    final static public int CommonStreamIdTooLong                              = 1000014;

    /** The input stream ID is empty. */
    final static public int CommonStreamIdNull                                 = 1000015;

    /** The input stream ID contains invalid characters. */
    final static public int CommonStreamIdInvalidCharacter                     = 1000016;

    /** This AppID has been removed from production. */
    final static public int CommonAppOfflineError                              = 1000037;

    /** There is an error in the backend configurations. Please check the configuration items of the app. */
    final static public int CommonAppFlexiableConfigError                      = 1000038;

    /** Incorrect CDN address. Please check the supported protocol and format. */
    final static public int CommonCdnUrlInvalid                                = 1000055;

    /** DNS resolution failed. Please check network configurations. */
    final static public int CommonDnsResolveError                              = 1000060;

    /** Server dispatching exception. Please contact ZEGO technical support to solve the problem. */
    final static public int CommonDispatchError                                = 1000065;

    /** Internal null pointer error. Please contact ZEGO technical support to solve the problem. */
    final static public int CommonInnerNullptr                                 = 1000090;

    /** AppID cannot be 0. Please check if the AppID is correct. */
    final static public int EngineAppidZero                                    = 1001000;

    /** The length of the input AppSign must be 64 bytes. */
    final static public int EngineAppsignInvalidLength                         = 1001001;

    /** The input AppSign contains invalid characters. Only '0'-'9','a'-'f','A'-'F' are valid. */
    final static public int EngineAppsignInvalidCharacter                      = 1001002;

    /** The input AppSign is empty. */
    final static public int EngineAppsignNull                                  = 1001003;

    /** Authentication failed. Please check if the AppID is correct, or whether the production environment was selected for SDK initialization without prior go-live process. */
    final static public int EngineAppidIncorrectOrNotOnline                    = 1001004;

    /** AppSign authentication failed. Please check if the AppSign is correct. */
    final static public int EngineAppsignIncorrect                             = 1001005;

    /** No write permission to the log file. */
    final static public int EngineLogNoWritePermission                         = 1001014;

    /** The log file path is too long. */
    final static public int EngineLogPathTooLong                               = 1001015;

    /** The number of rooms the user attempted to log into simultaneously exceeds the maximum number allowed. Currently, a user can only be logged in to one room at the same time. */
    final static public int RoomCountExceed                                    = 1002001;

    /** The input user ID is empty. */
    final static public int RoomUserIdNull                                     = 1002005;

    /** The input user ID contains invalid characters. */
    final static public int RoomUserIdInvalidCharacter                         = 1002006;

    /** The input user ID is too long. The maximum length allowed is 64 characters. */
    final static public int RoomUserIdTooLong                                  = 1002007;

    /** The input user name is empty. */
    final static public int RoomUserNameNull                                   = 1002008;

    /** The input user name contains invalid characters. */
    final static public int RoomUserNameInvalidCharacter                       = 1002009;

    /** The input user name is too long. The maximum length allowed is 256 characters. */
    final static public int RoomUserNameTooLong                                = 1002010;

    /** The input room ID is empty. */
    final static public int RoomRoomidNull                                     = 1002011;

    /** The input room ID contains invalid characters. */
    final static public int RoomRoomidInvalidCharacter                         = 1002012;

    /** The input room ID is too long. The maximum length is 128 characters. */
    final static public int RoomRoomidTooLong                                  = 1002013;

    /** Login failed, possibly due to network problems. */
    final static public int RoomErrorConnectFailed                             = 1002030;

    /** Login timed out, possibly due to network problems. */
    final static public int RoomErrorLoginTimeout                              = 1002031;

    /** Room login authentication failed. */
    final static public int RoomErrorAuthenticationFailed                      = 1002033;

    /** The number of users logging into the room exceeds the maximum number of concurrent users configured for the room. */
    final static public int RoomErrorExceedMaximumMember                       = 1002034;

    /** The user is kicked out of the room, possibly because the same user ID is logged in on another device. */
    final static public int RoomKickedOut                                      = 1002050;

    /** Room connection is temporarily interrupted, possibly due to network problems. Retrying... */
    final static public int RoomConnectTemporaryBroken                         = 1002051;

    /** Room disconnected, possibly due to network problems. */
    final static public int RoomDisconnect                                     = 1002052;

    /** Room login retry has exceeded the maximum retry time. */
    final static public int RoomRetryTimeout                                   = 1002053;

    /** The business server has sent a signal to kick the user out of the room. Please check the reason for the kick-out. */
    final static public int RoomManualKickedOut                                = 1002055;

    /** Room login failed due to internal system exceptions. */
    final static public int RoomInnerError                                     = 1002099;

    /** Stream publishing failed, possibly due to no data in the stream. */
    final static public int PublisherPublishStreamFailed                       = 1003001;

    /** Incorrect bitrate setting. Please check if the bitrate value is in the correct unit (kbps). */
    final static public int PublisherBitrateInvalid                            = 1003002;

    /** Incorrect setting of stream publishing traffic control parameters. */
    final static public int PublisherTrafficModeInvalid                        = 1003005;

    /** Stream publishing is temporarily interrupted. Retrying... */
    final static public int PublisherErrorNetworkInterrupt                     = 1003020;

    /** Failed to publish the stream. The user is already publishing streams. */
    final static public int PublisherErrorAlreadyDoPublish                     = 1003023;

    /** Failed to publish the stream. Publishing of this stream is prohibited by backend configuration. */
    final static public int PublisherErrorServerForbid                         = 1003025;

    /** Failed to publish the stream. The same stream already exists in the room. */
    final static public int PublisherErrorRepetitivePublishStream              = 1003028;

    /** The connection to the RTMP server is interrupted. Please check whether there is any problem with the network connection or the stream publishing URL. */
    final static public int PublisherRtmpServerDisconnect                      = 1003029;

    /** Failed to get status updates of relayed streaming to CDN. Please check whether the URL is valid. */
    final static public int PublisherUpdateCdnTargetError                      = 1003040;

    /** Failed to send SEI. The SEI data is null. */
    final static public int PublisherSeiDataNull                               = 1003043;

    /** Failed to send SEI because the SEI data is too long. The maximum length allowed is 4096 characters. */
    final static public int PublisherSeiDataTooLong                            = 1003044;

    /** The extra info of the stream is null. */
    final static public int PublisherExtraInfoNull                             = 1003050;

    /** The extra info of the stream is too long. The maximum length allowed is 1024 characters. */
    final static public int PublisherExtraInfoTooLong                          = 1003051;

    /** Failed to update the extra info of the stream. Please check the network connection. */
    final static public int PublisherUpdateExtraInfoFailed                     = 1003053;

    /** The watermark URL is null. */
    final static public int PublisherWatermarkUrlNull                          = 1003055;

    /** The watermark URL is too long. The maximum length allowed is 1024 characters. */
    final static public int PublisherWatermarkUrlTooLong                       = 1003056;

    /** Invalid watermark format. The supported formats are `jpg` and `png`. */
    final static public int PublisherWatermarkUrlInvalid                       = 1003057;

    /** Incorrect watermark layout. The layout area cannot exceed the encoding resolution. */
    final static public int PublisherWatermarkLayoutInvalid                    = 1003058;

    /** Stream publishing failed due to system internal exceptions. */
    final static public int PublisherInnerError                                = 1003099;

    /** Stream playing failed, possibly due to no data in the stream. */
    final static public int PlayerPlayStreamFailed                             = 1004001;

    /** The number of streams the user attempted to play simultaneously exceeds the maximum number allowed. Currently, up to 12 steams can be played at the same time. Please contact ZEGO technical support to increase the capacity if necessary. */
    final static public int PlayerCountExceed                                  = 1004010;

    /** Stream playing is temporarily interrupted. Retrying... */
    final static public int PlayerErrorNetworkInterrupt                        = 1004020;

    /** Stream playing failed due to system internal exceptions. */
    final static public int PlayerInnerError                                   = 1004099;

    /** Stream mixing service not yet enabled.  Please contact ZEGO technical support to enable the service. */
    final static public int MixerNoServices                                    = 1005000;

    /** The stream mixing task ID is null. */
    final static public int MixerTaskIdNull                                    = 1005001;

    /** The stream mixing task ID is too long. The maximum length allowed is 256 characters. */
    final static public int MixerTaskIdTooLong                                 = 1005002;

    /** The stream mixing task ID contains invalid characters. */
    final static public int MixerTaskIdInvalidCharacter                        = 1005003;

    /** No output is specified in the configuration of the stream mixing task. */
    final static public int MixerNoOutputTarget                                = 1005005;

    /** Incorrect stream mixing output. Please check if the streamID of the output target contains invalid characters. */
    final static public int MixerOutputTargetInvalid                           = 1005006;

    /** Failed to start the stream mixing task, possibly due to network problems. */
    final static public int MixerStartRequestError                             = 1005010;

    /** Failed to stop the stream mixing task, possibly due to network problems. */
    final static public int MixerStopRequestError                              = 1005011;

    /** The stream mixing task must be stopped by the user who started the task. */
    final static public int MixerNotOwnerStopMixer                             = 1005012;

    /** Starts stream mixing tasks too frequently. */
    final static public int MixerStartQpsOverload                              = 1005015;

    /** Stops stream mixing tasks too frequently. */
    final static public int MixerStopQpsOverload                               = 1005016;

    /** The input stream list of the stream mixing task is null. */
    final static public int MixerInputListInvalid                              = 1005020;

    /** The output stream list of the stream mixing task is null. */
    final static public int MixerOutputListInvalid                             = 1005021;

    /** The video configuration of the stream mixing task is invalid. */
    final static public int MixerVideoConfigInvalid                            = 1005023;

    /** The audio configuration of the stream mixing task is invalid. Please check if an unsupported codec is used. */
    final static public int MixerAudioConfigInvalid                            = 1005024;

    /** The number of input streams exceeds the maximum number allowed. Up to 9 input streams can be specified. */
    final static public int MixerExceedMaxInputCount                           = 1005025;

    /** The input stream does not exist. */
    final static public int MixerInputStreamNotExists                          = 1005026;

    /** Invalid stream mixing input parameters. It may be that the layout of the input streams exceeds the canvas. */
    final static public int MixerInputParametersError                          = 1005027;

    /** The number of output streams exceeds the maximum number allowed. Up to 3 output streams can be specified. */
    final static public int MixerExceedMaxOutputCount                          = 1005030;

    /** Stream mixing authentication failed. */
    final static public int MixerAuthenticationFailed                          = 1005050;

    /** The input watermark is null. */
    final static public int MixerWatermarkNull                                 = 1005061;

    /** Invalid watermark parameter. It may be that the layout of the watermark exceeds the canvas. */
    final static public int MixerWatermarkParametersError                      = 1005062;

    /** Invalid watermark URL. The URL must start with `preset-id://`, and must end with `.jpg` or `.png`. */
    final static public int MixerWatermarkUrlInvalid                           = 1005063;

    /** Invalid background image URL. The URL must start with `preset-id://`, and must end with `.jpg` or `.png`. */
    final static public int MixerBackgroundImageUrlInvalid                     = 1005067;

    /** The server for auto stream mixing is not found. Please contact ZEGO technical support to enable it. */
    final static public int MixerAutoMixStreamServerNotFound                   = 1005070;

    /** Stream mixing internal error. */
    final static public int MixerInnerError                                    = 1005099;

    /** Generic device error. */
    final static public int DeviceErrorTypeGeneric                             = 1006001;

    /** The device ID does not exist. */
    final static public int DeviceErrorTypeInvalidId                           = 1006002;

    /** No permission to access the device. Please check the permissions of the camera or microphone. */
    final static public int DeviceErrorTypeNoAuthorization                     = 1006003;

    /** The sampling frame rate of the video capture device is 0. */
    final static public int DeviceErrorTypeZeroFps                             = 1006004;

    /** The device is occupied. */
    final static public int DeviceErrorTypeInUseByOther                        = 1006005;

    /** The device is unplugged. */
    final static public int DeviceErrorTypeUnplugged                           = 1006006;

    /** The device needs to be restarted. */
    final static public int DeviceErrorTypeRebootRequired                      = 1006007;

    /** The device media is lost. */
    final static public int DeviceErrorMediaServicesLost                       = 1006008;

    /** The device list cannot be empty when trying to release devices. */
    final static public int DeviceFreeDeviceListNull                           = 1006020;

    /** Device internal error. */
    final static public int DeviceInnerError                                   = 1006099;

    /** Unknown error in the preprocessing module. Please contact ZEGO technical support. */
    final static public int PreprocessPreprocessUnknownError                   = 1007001;

    /** Invalid beauty option. Please check the input parameters. */
    final static public int PreprocessBeautifyOptionInvalid                    = 1007005;

    /** The reverberation parameter is null. Please check the input parameter. */
    final static public int PreprocessReverbParamNull                          = 1007006;

    /** The voice changer parameter is null. Please check the input parameter. */
    final static public int PreprocessVoiceChangerParamNull                    = 1007007;

    /** The room size value of the reverberation parameters is invalid. The value should be in the range of 0.0 ~ 1.0. */
    final static public int PreprocessReverbParamRoomSizeInvalid               = 1007011;

    /** The reverberance value of the reverberation parameters is invalid. The value should be in the range of 0.0 ~ 0.5. */
    final static public int PreprocessReverbParamReverberanceInvalid           = 1007012;

    /** The damping value of the reverberation parameters is invalid. The value should be in the range of 0.0 ~ 2.0. */
    final static public int PreprocessReverbParamDampingInvalid                = 1007013;

    /** The dry_wet_ratio value of the reverberation parameters is invalid. The value should be greater than 0.0. */
    final static public int PreprocessReverbParamDryWetRatioInvalid            = 1007014;

    /** The angle value of the virtual stereo parameters is invalid. The value should be in the range of 0 ~ 180. */
    final static public int PreprocessVirtualStereoAngleInvalid                = 1007015;

    /** The voice changer param is invalid. The value should be in the range of -8.0 ~ 8.0. */
    final static public int PreprocessVoiceChangerParamInvalid                 = 1007016;

    /** The MediaPlayer instance is not created. */
    final static public int MediaPlayerNoInstance                              = 1008001;

    /** The MediaPlayer failed to play the media. The resource file is not loaded. */
    final static public int MediaPlayerNoFilePath                              = 1008003;

    /** The MediaPlayer failed to load the file. The file format is not supported. */
    final static public int MediaPlayerFileFormatError                         = 1008005;

    /** The MediaPlayer failed to load the file. The file path does not exist. */
    final static public int MediaPlayerFilePathNotExists                       = 1008006;

    /** The MediaPlayer failed to load the file due to decoding errors. */
    final static public int MediaPlayerFileDecodeError                         = 1008007;

    /** The MediaPlayer failed to load files. No supported audio/video stream exists. */
    final static public int MediaPlayerFileNoSupportedStream                   = 1008008;

    /** The MediaPlayer failed to play the file due to demuxing errors. */
    final static public int MediaPlayerDemuxError                              = 1008010;

    /** The MediaPlayer failed to seek, possibly because the file hasn't been loaded yet. */
    final static public int MediaPlayerSeekError                               = 1008016;

    /** The MediaPlayer is configured with a video data format not supported by the platform (e.g., CVPixelBuffer on iOS does not support NV21). */
    final static public int MediaPlayerPlatformFormatNotSupported              = 1008020;

    /** The number of MediaPlayer instances exceeds the maximum number allowed. Up to 4 instances can be created. */
    final static public int MediaPlayerExceedMaxCount                          = 1008030;

    /** MediaPlayer internal error. */
    final static public int MediaPlayerInnerError                              = 1008099;

    /** The input message content is empty. */
    final static public int IMContentNull                                      = 1009001;

    /** The input message content is too long. The maximum length allowed is 1024 bytes. */
    final static public int IMContentTooLong                                   = 1009002;

    /** Failed to send the message, possibly due to network problems. */
    final static public int IMSendFailed                                       = 1009010;

    /** The file name suffix is not supported. Only .mp4 and .flv are supported currently. Depending on file name suffix, SDK sets the specified recording format accordingly. */
    final static public int RecorderFileSuffixNameFormatNotSupport             = 1010002;

    /** Generic error of recording API, generally due to invalid input parameters. */
    final static public int RecorderCommonLiveroomApiError                     = 1010003;

    /** The specified recorded file path is too long. */
    final static public int RecorderFilePathTooLong                            = 1010011;

    /** SDK internal VE error. Please contact ZEGO technical support to solve the problem. */
    final static public int RecorderInnerVeError                               = 1010012;

    /** Failed to open the file. Invalid file path or no permissions to the file. */
    final static public int RecorderOpenFileFailed                             = 1010013;

    /** Failed to write to the file, possibly due to no write permission to the file. */
    final static public int RecorderWriteFileError                             = 1010014;

    /** Not enough spare capacity. */
    final static public int RecorderNoEnoughSpareCapacity                      = 1010017;

    /** File handle exceptions. */
    final static public int RecorderFileHandleExceptions                       = 1010018;

    /** I/O exceptions. */
    final static public int RecorderIoExceptions                               = 1010019;

    /** The custom video capturer is not created. Please make sure to use it only after the `onStart` callback is received. */
    final static public int CustomVideoIOCapturerNotCreated                    = 1011001;

    /** The custom video capture module is not enabled. Please make sure it is enabled in the initialization configurations. */
    final static public int CustomVideoIONoCustomVideoCapture                  = 1011002;

    /** Failed to enable/disable custom video capture/rendering. Please make sure to enable/disable it before the engine is started (i.e., before calling `startPreview`, `startPublishingStream` or `startPlayingStream`). */
    final static public int CustomVideoIOEnableCustomIoFailed                  = 1011003;

    /** The currently configured custom video capture format does not support this API. */
    final static public int CustomVideoIONotSupportedFormat                    = 1011010;

    /** Custom video rendering does not support the currently set video buffer type. */
    final static public int CustomVideoIONotSupportedBufferType                = 1011011;

    /** Unsupported custom audio source type. */
    final static public int CustomAudioIOUnsupportedAudioSourceType            = 1012001;

    /** The custom audio capture feature is not enabled. Please make sure that the custom audio IO module is enabled for the specified stream publishing channel. */
    final static public int CustomAudioIOCapturerNotCreated                    = 1012002;

    /** The custom audio rendering feature is not enabled. Please make sure that the custom audio IO module is enabled. */
    final static public int CustomAudioIORendererNotCreated                    = 1012003;

    /** Failed to enable/disable custom audio IO. Please make sure to enable/disable it before the engine is started (i.e., before calling `startPreview`, `startPublishingStream` or `startPlayingStream`). */
    final static public int CustomAudioIOEnableCustomAudioIoFailed             = 1012004;


}
