/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.internal;

import android.graphics.Bitmap;
import android.os.Handler;
import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoMediaPlayerAudioHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerSeekToCallback;
import im.zego.zegoexpress.constants.ZegoAudioChannel;
import im.zego.zegoexpress.constants.ZegoAudioSampleRate;
import im.zego.zegoexpress.constants.ZegoMediaPlayerNetworkEvent;
import im.zego.zegoexpress.constants.ZegoMediaPlayerState;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.internal.ZegoExpressEngineInternalImpl;
import im.zego.zegoexpress.internal.ZegoMediaPlayerInternalImpl;
import im.zego.zegoexpress.utils.ZegoCallbackHelpers;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ZegoMediaPlayerJniCallback {
    ZegoMediaPlayerJniCallback() {
    }

    public static void onMediaPlayerVideoHandlerCallback(int idx, ByteBuffer[] buffer, int[] datalength, int[] strides, int format, int width, int height) {
        ZegoVideoFrameParam videoFrameParam = new ZegoVideoFrameParam();
        videoFrameParam.height = height;
        for (int i = 0; i < strides.length; ++i) {
            videoFrameParam.strides[i] = strides[i];
        }
        videoFrameParam.width = width;
        videoFrameParam.format = ZegoVideoFrameFormat.values()[format];
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            Object mediaPlayerVideoHandler = item.getValue().videoHandler;
            if (mediaPlayerVideoHandler == null) {
                return;
            }
            ZegoCallbackHelpers.callMediaVideoFrameMethod(mediaPlayerVideoHandler, item.getKey(), buffer, datalength, videoFrameParam);
        }
    }

    public static void onMediaPlayerAudioHandlerCallback(int idx, ByteBuffer buffer, int bufferLength, int channel, int samplesRate) {
        ZegoAudioFrameParam audioFrame = new ZegoAudioFrameParam();
        audioFrame.channel = ZegoAudioChannel.values()[channel];
        audioFrame.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(samplesRate);
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            IZegoMediaPlayerAudioHandler mediaPlayerAudioHandler = item.getValue().audioHandler;
            if (mediaPlayerAudioHandler == null) {
                return;
            }
            mediaPlayerAudioHandler.onAudioFrame(item.getKey(), buffer, bufferLength, audioFrame);
        }
    }

    public static void onLoadResourceCallback(int idx, final int errorcode) {
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            final IZegoMediaPlayerLoadResourceCallback iZegoMediaPlayerLoadResourceCallback = item.getValue().loadResourceCallback;
            if (iZegoMediaPlayerLoadResourceCallback == null) {
                return;
            }
            ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    iZegoMediaPlayerLoadResourceCallback.onLoadResourceCallback(errorcode);
                }
            });
        }
    }

    public static void onSeekToTimeCallback(final int seq, int idx, final int errorcode) {
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            final IZegoMediaPlayerSeekToCallback seekToTimeCallback = item.getValue().seekToTimeCallbackHashMap.get(seq);
            if (seekToTimeCallback == null) {
                return;
            }
            ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    seekToTimeCallback.onSeekToTimeCallback(errorcode);
                    ((ZegoMediaPlayerInternalImpl.IdxAndHandler)item.getValue()).seekToTimeCallbackHashMap.remove(seq);
                }
            });
        }
    }

    public static void onMediaPlayerStateUpdateCallback(int state, final int errorcode, int idx) {
        final ZegoMediaPlayerState zegoMediaPlayerState = ZegoMediaPlayerState.values()[state];
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
            if (iZegoMediaPlayerEventHandler == null) {
                return;
            }
            ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    iZegoMediaPlayerEventHandler.onMediaPlayerStateUpdate((ZegoMediaPlayer)item.getKey(), zegoMediaPlayerState, errorcode);
                }
            });
        }
    }

    public static void onMediaPlayerNetWorkEventCallback(int event, int idx) {
        final ZegoMediaPlayerNetworkEvent zegoMediaPlayerNetworkEvent = ZegoMediaPlayerNetworkEvent.values()[event];
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
            if (iZegoMediaPlayerEventHandler == null) {
                return;
            }
            ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    iZegoMediaPlayerEventHandler.onMediaPlayerNetworkEvent((ZegoMediaPlayer)item.getKey(), zegoMediaPlayerNetworkEvent);
                }
            });
        }
    }

    public static void onMediaPlayerPlayingProgressCallback(int idx, final long millisecond) {
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
            if (iZegoMediaPlayerEventHandler == null) {
                return;
            }
            ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    iZegoMediaPlayerEventHandler.onMediaPlayerPlayingProgress((ZegoMediaPlayer)item.getKey(), millisecond);
                }
            });
        }
    }

    public static void onMediaPlayerRecvSEICallback(int idx, final byte[] data) {
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
            if (iZegoMediaPlayerEventHandler == null) {
                return;
            }
            ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable(){

                @Override
                public void run() {
                    iZegoMediaPlayerEventHandler.onMediaPlayerRecvSEI((ZegoMediaPlayer)item.getKey(), data);
                }
            });
        }
    }

    public static void onTakeSnapshotResult(int idx, final int errorCode, final Bitmap image) {
        Handler handler = ZegoExpressEngineInternalImpl.mUIHandler;
        if (handler == null) {
            return;
        }
        ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
        for (Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx != idx) continue;
            final Object takeSnapshotHandler = item.getValue().mediaPlayerTakeSnapshotCallback;
            if (takeSnapshotHandler == null) {
                return;
            }
            handler.post(new Runnable(){

                @Override
                public void run() {
                    ZegoCallbackHelpers.callMediaPlayerSnapshotMethod(takeSnapshotHandler, errorCode, image);
                }
            });
        }
    }
}

