/*
 * Decompiled with CFR 0.152.
 */
package im.zego.zegoexpress.internal;

import android.os.Handler;
import android.os.Looper;
import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoMediaPlayerAudioHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerSeekToCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerTakeSnapshotCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerVideoHandler;
import im.zego.zegoexpress.constants.ZegoMediaPlayerAudioChannel;
import im.zego.zegoexpress.constants.ZegoMediaPlayerState;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAccurateSeekConfig;
import im.zego.zegoexpress.entity.ZegoCanvas;
import im.zego.zegoexpress.entity.ZegoVoiceChangerParam;
import im.zego.zegoexpress.internal.ZegoExpressEngineInternalImpl;
import im.zego.zegoexpress.internal.ZegoMediaPlayerJniAPI;
import im.zego.zegoexpress.utils.ZegoDebugLevel;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ZegoMediaPlayerInternalImpl
extends ZegoMediaPlayer {
    public static Handler mUIHandler = new Handler(Looper.getMainLooper());
    public static ConcurrentHashMap<ZegoMediaPlayer, IdxAndHandler> mediaplayerToIdxAndEventhandler = new ConcurrentHashMap();

    @Override
    public void setEventHandler(IZegoMediaPlayerEventHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.eventHandler = handler;
        }
    }

    @Override
    public void setVideoHandler(IZegoMediaPlayerVideoHandler handler, ZegoVideoFrameFormat frameFormat) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.videoHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJniAPI.enableVideoDataJni(frameFormat.value(), false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJniAPI.enableVideoDataJni(frameFormat.value(), true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }

    @Override
    public void setAudioHandler(IZegoMediaPlayerAudioHandler handler) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            idxAndHandler.audioHandler = handler;
            if (handler == null) {
                ZegoMediaPlayerJniAPI.enableAudioDataJni(false, idxAndHandler.kMediaPlayerIdx);
            } else {
                ZegoMediaPlayerJniAPI.enableAudioDataJni(true, idxAndHandler.kMediaPlayerIdx);
            }
        }
    }

    @Override
    public void loadResource(String path, IZegoMediaPlayerLoadResourceCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.loadResourceJni(idxAndHandler.kMediaPlayerIdx, path);
            idxAndHandler.loadResourceCallback = callback;
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer loadResource", errorCode, new Object[0]);
        }
    }

    @Override
    public int getIndex() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer getIndex", 0, new Object[0]);
            return idxAndHandler.kMediaPlayerIdx;
        }
        return 0;
    }

    @Override
    public void start() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.startJni(idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer start", errorCode, new Object[0]);
        }
    }

    @Override
    public void stop() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.stopJni(idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer stop", errorCode, new Object[0]);
        }
    }

    @Override
    public void pause() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.pauseJni(idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer pause", errorCode, new Object[0]);
        }
    }

    @Override
    public void resume() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.resumeJni(idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer resume", errorCode, new Object[0]);
        }
    }

    @Override
    public void seekTo(long millisecond, IZegoMediaPlayerSeekToCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int seq = ZegoMediaPlayerJniAPI.seekToJni(idxAndHandler.kMediaPlayerIdx, millisecond);
            idxAndHandler.seekToTimeCallbackHashMap.put(seq, callback);
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer seekTo", 0, new Object[0]);
        }
    }

    @Override
    public void enableRepeat(boolean enable) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.enableRepeatJni(idxAndHandler.kMediaPlayerIdx, enable);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer enableRepeat", errorCode, new Object[0]);
        }
    }

    @Override
    public void enableAux(boolean enable) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.enableAuxJni(idxAndHandler.kMediaPlayerIdx, enable);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer enableAux", errorCode, new Object[0]);
        }
    }

    @Override
    public void muteLocal(boolean mute) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.muteLocalJni(idxAndHandler.kMediaPlayerIdx, mute);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer muteLocal", errorCode, new Object[0]);
        }
    }

    @Override
    public void setPlayerCanvas(ZegoCanvas canvas) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = 0;
            errorCode = canvas != null ? ZegoMediaPlayerJniAPI.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, canvas.view, canvas.viewMode.value(), canvas.backgroundColor) : ZegoMediaPlayerJniAPI.setPlayerCanvasJni(idxAndHandler.kMediaPlayerIdx, null, 0, 0);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer setPlayerCanvas", errorCode, new Object[0]);
        }
    }

    @Override
    public void setVolume(int volume) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer setVolume", errorCode, new Object[0]);
        }
    }

    @Override
    public void setProgressInterval(long millisecond) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setProgressIntervalJni(idxAndHandler.kMediaPlayerIdx, millisecond);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer setProgressInterval", errorCode, new Object[0]);
        }
    }

    @Override
    public void setPlayVolume(int volume) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setPlayVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer setPlayVolume", errorCode, new Object[0]);
        }
    }

    @Override
    public void setPublishVolume(int volume) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setPublishVolumeJni(idxAndHandler.kMediaPlayerIdx, volume);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer setPublishVolume", errorCode, new Object[0]);
        }
    }

    @Override
    public int getPlayVolume() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer getPlayVolume", 0, new Object[0]);
            return ZegoMediaPlayerJniAPI.getPlayVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return 0;
    }

    @Override
    public int getPublishVolume() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer getPublishVolume", 0, new Object[0]);
            return ZegoMediaPlayerJniAPI.getPublishVolumeJni(idxAndHandler.kMediaPlayerIdx);
        }
        return 0;
    }

    @Override
    public long getTotalDuration() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer getTotalDuration", 0, new Object[0]);
            return ZegoMediaPlayerJniAPI.getTotalDurationJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1L;
    }

    @Override
    public long getCurrentProgress() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer getCurrentProgress", 0, new Object[0]);
            return ZegoMediaPlayerJniAPI.getCurrentProgressJni(idxAndHandler.kMediaPlayerIdx);
        }
        return -1L;
    }

    @Override
    public int getAudioTrackCount() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer getAudioTrackCount", 0, new Object[0]);
            return ZegoMediaPlayerJniAPI.getAudioTrackCount(idxAndHandler.kMediaPlayerIdx);
        }
        return -1;
    }

    @Override
    public void setAudioTrackIndex(int index) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setAudioTrackIndex(index, idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer setAudioTrackIndex", errorCode, new Object[0]);
        }
    }

    @Override
    public void setVoiceChangerParam(ZegoMediaPlayerAudioChannel audioChannel, ZegoVoiceChangerParam param) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.setVoiceChangerParam(audioChannel.value(), param.pitch, idxAndHandler.kMediaPlayerIdx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer setVoiceChangerParam", errorCode, new Object[0]);
        }
    }

    public static ZegoMediaPlayer createMediaPlayer() {
        int index = ZegoMediaPlayerJniAPI.createMediaPlayerJni();
        if (index >= 0) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer createMediaPlayer", 0, new Object[0]);
            ZegoMediaPlayerInternalImpl zegoMediaPlayer = new ZegoMediaPlayerInternalImpl();
            IdxAndHandler idxAndHandler = new IdxAndHandler(index);
            idxAndHandler.seekToTimeCallbackHashMap = new ConcurrentHashMap();
            mediaplayerToIdxAndEventhandler.put(zegoMediaPlayer, idxAndHandler);
            return zegoMediaPlayer;
        }
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.ERROR, 8, "MediaPlayer createMediaPlayer", 1008030, new Object[0]);
        return null;
    }

    public static void destroyMediaPlayer(ZegoMediaPlayer mediaplayer) {
        Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
            if (item.getKey() != mediaplayer) continue;
            item.getValue().videoHandler = null;
            item.getValue().audioHandler = null;
            item.getValue().eventHandler = null;
            item.getValue().loadResourceCallback = null;
            item.getValue().mediaPlayerTakeSnapshotCallback = null;
            Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
            while (itSeekToTimeCallbackHashMap.hasNext()) {
                itSeekToTimeCallbackHashMap.next();
                itSeekToTimeCallbackHashMap.remove();
            }
            item.getValue().seekToTimeCallbackHashMap = null;
            int idx = item.getValue().kMediaPlayerIdx;
            int errorCode = ZegoMediaPlayerJniAPI.destroyMediaPlayerJni(idx);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer destroyMediaPlayer", errorCode, new Object[0]);
            it.remove();
            break;
        }
    }

    public static void destroyAllMediaPlayer() {
        ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer destroyAllMediaPlayer", 0, new Object[0]);
        Iterator<Map.Entry<ZegoMediaPlayer, IdxAndHandler>> it = mediaplayerToIdxAndEventhandler.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ZegoMediaPlayer, IdxAndHandler> item = it.next();
            item.getValue().videoHandler = null;
            item.getValue().audioHandler = null;
            item.getValue().eventHandler = null;
            item.getValue().loadResourceCallback = null;
            item.getValue().mediaPlayerTakeSnapshotCallback = null;
            Iterator<Map.Entry<Integer, IZegoMediaPlayerSeekToCallback>> itSeekToTimeCallbackHashMap = item.getValue().seekToTimeCallbackHashMap.entrySet().iterator();
            while (itSeekToTimeCallbackHashMap.hasNext()) {
                itSeekToTimeCallbackHashMap.next();
                itSeekToTimeCallbackHashMap.remove();
            }
            item.getValue().seekToTimeCallbackHashMap = null;
            int idx = item.getValue().kMediaPlayerIdx;
            ZegoMediaPlayerJniAPI.destroyMediaPlayerJni(idx);
            it.remove();
        }
    }

    @Override
    public ZegoMediaPlayerState getCurrentState() {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            ZegoExpressEngineInternalImpl.printDebugInfo(ZegoDebugLevel.INFO, 8, "MediaPlayer getCurrentState", 0, new Object[0]);
            int state = ZegoMediaPlayerJniAPI.getCurrentStateJni(idxAndHandler.kMediaPlayerIdx);
            ZegoMediaPlayerState zegoMediaPlayerState = state == ZegoMediaPlayerState.NO_PLAY.value() ? ZegoMediaPlayerState.NO_PLAY : (state == ZegoMediaPlayerState.PLAYING.value() ? ZegoMediaPlayerState.PLAYING : (state == ZegoMediaPlayerState.PAUSING.value() ? ZegoMediaPlayerState.PAUSING : (state == ZegoMediaPlayerState.PLAY_ENDED.value() ? ZegoMediaPlayerState.PLAY_ENDED : ZegoMediaPlayerState.NO_PLAY)));
            return zegoMediaPlayerState;
        }
        return ZegoMediaPlayerState.NO_PLAY;
    }

    @Override
    public void takeSnapshot(IZegoMediaPlayerTakeSnapshotCallback callback) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.takeSnapshotJni(idxAndHandler.kMediaPlayerIdx);
            idxAndHandler.mediaPlayerTakeSnapshotCallback = callback;
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer takeSnapshot", errorCode, new Object[0]);
        }
    }

    @Override
    public void enableAccurateSeek(boolean enable, ZegoAccurateSeekConfig config) {
        IdxAndHandler idxAndHandler = mediaplayerToIdxAndEventhandler.get(this);
        if (idxAndHandler != null) {
            int errorCode = ZegoMediaPlayerJniAPI.enableAccurateSeek(idxAndHandler.kMediaPlayerIdx, enable, config);
            ZegoExpressEngineInternalImpl.printDebugInfo(errorCode == 0 ? ZegoDebugLevel.INFO : ZegoDebugLevel.ERROR, 8, "MediaPlayer enableAccurateSeek", errorCode, new Object[0]);
        }
    }

    static class IdxAndHandler {
        int kMediaPlayerIdx;
        ConcurrentHashMap<Integer, IZegoMediaPlayerSeekToCallback> seekToTimeCallbackHashMap;
        Object mediaPlayerTakeSnapshotCallback;
        IZegoMediaPlayerLoadResourceCallback loadResourceCallback;
        IZegoMediaPlayerEventHandler eventHandler;
        IZegoMediaPlayerAudioHandler audioHandler;
        Object videoHandler;

        IdxAndHandler(int idx) {
            this.kMediaPlayerIdx = idx;
        }
    }
}

