package im.zego.zegoexpress.internal;

import android.graphics.Bitmap;
import android.os.Handler;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import im.zego.zegoexpress.ZegoMediaPlayer;
import im.zego.zegoexpress.callback.IZegoMediaPlayerAudioHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerEventHandler;
import im.zego.zegoexpress.callback.IZegoMediaPlayerLoadResourceCallback;
import im.zego.zegoexpress.callback.IZegoMediaPlayerSeekToCallback;
import im.zego.zegoexpress.constants.ZegoAudioChannel;
import im.zego.zegoexpress.constants.ZegoAudioSampleRate;
import im.zego.zegoexpress.constants.ZegoMediaPlayerNetworkEvent;
import im.zego.zegoexpress.constants.ZegoMediaPlayerState;
import im.zego.zegoexpress.constants.ZegoVideoFrameFormat;
import im.zego.zegoexpress.entity.ZegoAudioFrameParam;
import im.zego.zegoexpress.entity.ZegoVideoFrameParam;
import im.zego.zegoexpress.utils.ZegoCallbackHelpers;

import static im.zego.zegoexpress.internal.ZegoMediaPlayerInternalImpl.mediaplayerToIdxAndEventhandler;
import static im.zego.zegoexpress.internal.ZegoExpressEngineInternalImpl.mUIHandler;

class ZegoMediaPlayerJniCallback {

    // opt_content_start: audio_or_video = video; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onMediaPlayerVideoHandlerCallback(int idx, final ByteBuffer[] buffer, final int[] datalength, int[] strides, int format, int width, int height) {
        final ZegoVideoFrameParam videoFrameParam = new ZegoVideoFrameParam();
        videoFrameParam.height = height;
        for (int i = 0; i < strides.length; i++) {
            videoFrameParam.strides[i] = strides[i];
        }
        videoFrameParam.width = width;
        videoFrameParam.format = ZegoVideoFrameFormat.values()[format];

        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final Object mediaPlayerVideoHandler = item.getValue().videoHandler;
                if (mediaPlayerVideoHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    ZegoCallbackHelpers.callMediaVideoFrameMethod(mediaPlayerVideoHandler, item.getKey(), buffer, datalength, videoFrameParam);
                }
            }
        }

    }
    // opt_content_end: audio_or_video = video; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: audio_or_video = audio; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onMediaPlayerAudioHandlerCallback(int idx, final ByteBuffer buffer, final int bufferLength, int channel, int samplesRate) {

        final ZegoAudioFrameParam audioFrame = new ZegoAudioFrameParam();
        audioFrame.channel = ZegoAudioChannel.values()[channel];
        audioFrame.sampleRate = ZegoAudioSampleRate.getZegoAudioSampleRate(samplesRate);

        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final IZegoMediaPlayerAudioHandler mediaPlayerAudioHandler = item.getValue().audioHandler;
                if (mediaPlayerAudioHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    mediaPlayerAudioHandler.onAudioFrame(item.getKey(), buffer, bufferLength, audioFrame);
                }
            }
        }

    }
    // opt_content_end: audio_or_video = audio; sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onLoadResourceCallback(int idx, final int errorcode) {
        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final IZegoMediaPlayerLoadResourceCallback iZegoMediaPlayerLoadResourceCallback = item.getValue().loadResourceCallback;
                if (iZegoMediaPlayerLoadResourceCallback == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            iZegoMediaPlayerLoadResourceCallback.onLoadResourceCallback(errorcode);
                        }
                    });
                }
            }
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER


    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onSeekToTimeCallback(final int seq, int idx, final int errorcode) {
        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final IZegoMediaPlayerSeekToCallback seekToTimeCallback = item.getValue().seekToTimeCallbackHashMap.get(seq);
                if (seekToTimeCallback == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            seekToTimeCallback.onSeekToTimeCallback(errorcode);
                            item.getValue().seekToTimeCallbackHashMap.remove(seq);
                        }
                    });
                }
            }
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onMediaPlayerStateUpdateCallback(int state, final int errorcode, int idx) {

        final ZegoMediaPlayerState zegoMediaPlayerState = ZegoMediaPlayerState.values()[state];
        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            iZegoMediaPlayerEventHandler.onMediaPlayerStateUpdate(item.getKey(), zegoMediaPlayerState, errorcode);
                        }
                    });
                }
            }
        }

    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onMediaPlayerNetWorkEventCallback(int event, int idx) {

        final ZegoMediaPlayerNetworkEvent zegoMediaPlayerNetworkEvent = ZegoMediaPlayerNetworkEvent.values()[event];
        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            iZegoMediaPlayerEventHandler.onMediaPlayerNetworkEvent(item.getKey(), zegoMediaPlayerNetworkEvent);
                        }
                    });
                }
            }
        }

    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onMediaPlayerPlayingProgressCallback(int idx, final long millisecond) {
        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable() {
                        @Override
                        public void run() {
                            iZegoMediaPlayerEventHandler.onMediaPlayerPlayingProgress(item.getKey(), millisecond);
                        }
                    });
                }
            }
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onMediaPlayerRecvSEICallback(int idx, final byte[] data) {
        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final IZegoMediaPlayerEventHandler iZegoMediaPlayerEventHandler = item.getValue().eventHandler;
                if (iZegoMediaPlayerEventHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    ZegoMediaPlayerInternalImpl.mUIHandler.post(new Runnable() {
                        @Override
                        public void run() {

                            iZegoMediaPlayerEventHandler.onMediaPlayerRecvSEI(item.getKey(), data);

                        }
                    });
                }
            }
        }
    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER

    // opt_content_start: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
    public static void onTakeSnapshotResult(int idx, final int errorCode, final Bitmap image) {
        final Handler handler = mUIHandler;
        if (handler == null) {
            return;
        }
        final ConcurrentHashMap<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> mMediaplayerToIdxAndEventhandler = mediaplayerToIdxAndEventhandler;
        for (final Map.Entry<ZegoMediaPlayer, ZegoMediaPlayerInternalImpl.IdxAndHandler> item : mMediaplayerToIdxAndEventhandler.entrySet()) {
            if (item.getValue().kMediaPlayerIdx == idx) {
                final Object takeSnapshotHandler = item.getValue().mediaPlayerTakeSnapshotCallback;
                if (takeSnapshotHandler == null) {
                    //todo: 这里需要增加日志打印
                    return;
                } else {
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            ZegoCallbackHelpers.callMediaPlayerSnapshotMethod(takeSnapshotHandler, errorCode, image);
                        }
                    });

                }
            }
        }

    }
    // opt_content_end: sdk_exclusive_strategy = ZEGO_ENABLE_FEATURE_MEDIA_PLAYER
}
